/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.graphics.Bitmap;
import android.net.Uri;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callable.FileCompressCallableTasks;
import com.zxy.tiny.callback.Callback;
import com.zxy.tiny.callback.DefaultCallbackDispatcher;
import com.zxy.tiny.callback.FileBatchCallback;
import com.zxy.tiny.callback.FileWithBitmapBatchCallback;
import com.zxy.tiny.common.BatchCompressResult;
import com.zxy.tiny.core.CompressEngine;
import com.zxy.tiny.core.CompressExecutor;
import com.zxy.tiny.core.CompressFutureTask;
import com.zxy.tiny.core.CompressKit;
import java.io.File;

public class FileBatchCompressEngine
extends CompressEngine {
    private Tiny.FileCompressOptions mCompressOptions;

    public FileBatchCompressEngine withOptions(Tiny.FileCompressOptions options) {
        options.config = CompressKit.filterConfig(options.config);
        this.mCompressOptions = options;
        return this;
    }

    public void batchCompress(FileBatchCallback callback) {
        this.impl(callback);
    }

    public void batchCompress(FileWithBitmapBatchCallback callback) {
        this.impl(callback);
    }

    private void impl(Callback callback) {
        if (this.mSource == null) {
            return;
        }
        boolean shouldReturnBitmap = false;
        if (callback != null && callback instanceof FileWithBitmapBatchCallback) {
            shouldReturnBitmap = true;
        }
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.FileCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE_ARRAY) {
            File[] files = (File[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<BatchCompressResult>(new FileCompressCallableTasks.FileArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, files), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP_ARRAY) {
            Bitmap[] bitmaps = (Bitmap[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<BatchCompressResult>(new FileCompressCallableTasks.BitmapArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, bitmaps), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.URI_ARRAY) {
            Uri[] uris = (Uri[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<BatchCompressResult>(new FileCompressCallableTasks.UriArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, uris), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID_ARRAY) {
            int[] resIds = (int[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<BatchCompressResult>(new FileCompressCallableTasks.ResourceArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, resIds), new DefaultCallbackDispatcher(callback)));
        }
    }
}

