/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import com.zxy.libjpegturbo.JpegTurboCompressor;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.common.CompressResult;
import com.zxy.tiny.common.Conditions;
import com.zxy.tiny.common.Logger;
import com.zxy.tiny.core.BitmapCompressor;
import com.zxy.tiny.core.CompressKit;
import com.zxy.tiny.core.FileKit;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileCompressor {
    public static CompressResult compress(byte[] bytes, Tiny.FileCompressOptions options, boolean withBitmap, boolean recycle) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (options == null) {
            options = new Tiny.FileCompressOptions();
        }
        CompressResult result = null;
        Bitmap bitmap = null;
        if (options.isKeepSampling) {
            BitmapFactory.Options decodeOptions = CompressKit.getDefaultDecodeOptions();
            decodeOptions.inPreferredConfig = options.config;
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)decodeOptions);
        } else {
            bitmap = BitmapCompressor.compress(bytes, (Tiny.BitmapCompressOptions)options, false);
        }
        result = FileCompressor.compress(bitmap, options, withBitmap, recycle);
        return result;
    }

    public static CompressResult compress(Bitmap bitmap, Tiny.FileCompressOptions options, boolean withBitmap, boolean recycle) {
        if (bitmap == null || bitmap.isRecycled()) {
            return null;
        }
        CompressResult result = new CompressResult();
        if (options == null) {
            options = new Tiny.FileCompressOptions();
        }
        int quality = options.quality;
        String outfile = options.outfile;
        float size = options.size;
        if (quality < 0 || quality > 100) {
            quality = 76;
        }
        if (Conditions.isDirectory(outfile)) {
            outfile = FileKit.generateCompressOutfileFormatJPEG().getAbsolutePath();
        }
        if (!Conditions.isJpegFormat(outfile)) {
            outfile = FileKit.generateCompressOutfileFormatJPEG().getAbsolutePath();
        }
        if (bitmap.hasAlpha()) {
            outfile = FileKit.generateCompressOutfileFormatPNG().getAbsolutePath();
        }
        boolean isSuccess = FileCompressor.compress(bitmap, outfile, quality);
        if (size > 0.0f && isSuccess) {
            float outfileSize = (float)FileKit.getSizeInBytes(outfile) / 1024.0f;
            while (outfileSize > size && quality > 25 && (isSuccess = FileCompressor.compress(bitmap, outfile, quality -= 5))) {
                outfileSize = (float)FileKit.getSizeInBytes(outfile) / 1024.0f;
            }
        }
        Logger.e("compress quality: " + quality);
        result.outfile = outfile;
        result.success = isSuccess;
        if (withBitmap) {
            result.bitmap = bitmap;
        } else if (recycle) {
            result.bitmap = null;
            bitmap.recycle();
            bitmap = null;
        }
        return result;
    }

    private static boolean compress(Bitmap bitmap, String outfile, int quality) {
        if (bitmap == null || bitmap.isRecycled()) {
            return false;
        }
        if (bitmap.hasAlpha()) {
            return CompatCompressor.compress(bitmap, outfile, quality, Bitmap.CompressFormat.PNG);
        }
        if (Build.VERSION.SDK_INT < 24) {
            return JpegTurboCompressor.compress(bitmap, outfile, quality);
        }
        return CompatCompressor.compress(bitmap, outfile, quality, Bitmap.CompressFormat.JPEG);
    }

    private static final class CompatCompressor {
        private CompatCompressor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean compress(Bitmap bitmap, String outfile, int quality, Bitmap.CompressFormat format) {
            boolean isSuccess = false;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(outfile);
                isSuccess = bitmap.compress(format, quality, (OutputStream)fos);
            }
            catch (FileNotFoundException e) {
                isSuccess = false;
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (isSuccess && fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return isSuccess;
        }
    }
}

