/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.net.Uri;
import android.text.TextUtils;
import com.zxy.tiny.common.TinyException;
import com.zxy.tiny.common.UriUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpUrlConnectionFetcher {
    private static final int MAX_REDIRECTS = 5;
    private static final int HTTP_TEMPORARY_REDIRECT = 307;
    private static final int HTTP_PERMANENT_REDIRECT = 308;
    private static final int TIMEOUT = 10000;

    public static void fetch(String url, ResponseCallback callback) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        Uri uri = Uri.parse((String)url);
        HttpUrlConnectionFetcher.fetch(uri, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetch(Uri uri, ResponseCallback callback) {
        if (!UriUtil.isNetworkUri(uri)) {
            return;
        }
        HttpURLConnection connection = null;
        InputStream is = null;
        connection = HttpUrlConnectionFetcher.obtainHttpURLConnection(uri, 5);
        if (connection == null) {
            return;
        }
        try {
            is = connection.getInputStream();
            if (callback != null) {
                callback.callback(is);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static HttpURLConnection obtainHttpURLConnection(Uri uri, int maxRedirects) {
        if (uri == null) {
            return null;
        }
        HttpURLConnection connection = null;
        try {
            URL url = new URL(uri.toString());
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                return connection;
            }
            if (HttpUrlConnectionFetcher.isHttpRedirect(responseCode)) {
                String nextUriString = connection.getHeaderField("Location");
                connection.disconnect();
                Uri nextUri = nextUriString == null ? null : Uri.parse((String)nextUriString);
                String originalScheme = uri.getScheme();
                if (maxRedirects > 0 && nextUri != null && !nextUri.getScheme().equals(originalScheme)) {
                    return HttpUrlConnectionFetcher.obtainHttpURLConnection(nextUri, maxRedirects - 1);
                }
                String message = maxRedirects == 0 ? "URL %s follows too many redirects, uri:" + uri.toString() : "URL %s returned %d without a valid redirect, uri:" + uri.toString() + ", responseCode:" + responseCode;
                throw new TinyException.NetworkIOException(message);
            }
            connection.disconnect();
            connection = null;
        }
        catch (MalformedURLException e) {
            connection = null;
            e.printStackTrace();
        }
        catch (IOException e) {
            connection = null;
            e.printStackTrace();
        }
        catch (Exception e) {
            connection = null;
            e.printStackTrace();
        }
        return connection;
    }

    private static boolean isHttpRedirect(int responseCode) {
        switch (responseCode) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    static {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new TinyTrustManager()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return !"www.abcdefgzxy.com".equalsIgnoreCase(hostname);
                }
            });
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface ResponseCallback {
        public void callback(InputStream var1);
    }

    private static final class TinyTrustManager
    implements X509TrustManager {
        private TinyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

