/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.os.Handler;
import android.os.Looper;
import com.zxy.tiny.callback.CallbackDispatcher;

public class MainThreadExecutor {
    private static Handler sMainThreadHandler;

    public static <T> void postToMainThread(final T t, final CallbackDispatcher<T> dispatcher) {
        if (dispatcher == null) {
            return;
        }
        MainThreadExecutor.enableMainThread();
        sMainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                dispatcher.dispatch(t);
            }
        });
    }

    private static void enableMainThread() {
        if (sMainThreadHandler == null || !MainThreadExecutor.isMainThreadHandler(sMainThreadHandler)) {
            sMainThreadHandler = new Handler(Looper.getMainLooper());
        }
    }

    private static boolean isMainThreadHandler(Handler handler) {
        return handler.getLooper().getThread() == Looper.getMainLooper().getThread();
    }
}

