/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.updatelibrary.data;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import com.xdja.update.UpdateManager;
import com.xdja.updatelibrary.R;
import com.xdja.updatelibrary.activtiy.UpgradeShowActivity;
import com.xdja.updatelibrary.receive.UpdateclockReceive;
import com.xdja.updatelibrary.utils.AppUtil;

public class UpdateLoadingNotification {
    static final int UPDATE_NOTIFY_ID = 200;
    String content;
    String title;
    int resSmallIcon;
    int resLargeIcon;
    boolean forceUpdate;
    int notifyId;
    boolean isProgress;
    boolean enableNotify;
    boolean autoCancel;
    private Notification.Builder mNbuilder;
    private static final String UPDATE_CHANNEL_ID = "NOTIFY_UPDATE_ID";
    private static final String UPDATE_CHANNEL_NAME = "\u5347\u7ea7\u901a\u77e5\u680f";
    private NotificationManager mNotificationManager;

    public UpdateLoadingNotification() {
    }

    public UpdateLoadingNotification(Builder builder) {
        this.content = builder.content;
        this.title = builder.title;
        this.resSmallIcon = builder.resSmallIcon;
        this.notifyId = builder.notifyId;
        this.enableNotify = builder.enableNotify;
        this.isProgress = builder.isProgress;
        this.autoCancel = builder.autoCancel;
        this.resLargeIcon = builder.resLargeIcon;
        this.forceUpdate = builder.forceUpdate;
    }

    public void showNotification(UpdateLoadingNotification notification) {
        Context context = UpdateManager.getInstance().getContext();
        if (!notification.enableNotify) {
            return;
        }
        this.mNbuilder = new Notification.Builder(context);
        this.mNbuilder.setContentTitle((CharSequence)notification.title);
        this.mNbuilder.setContentText((CharSequence)notification.content);
        this.mNbuilder.setTicker((CharSequence)notification.content);
        this.mNbuilder.setSmallIcon(notification.resSmallIcon);
        this.mNbuilder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)notification.resLargeIcon));
        this.mNbuilder.setAutoCancel(notification.autoCancel);
        if (Build.VERSION.SDK_INT >= 26) {
            UpdateLoadingNotification.createNotificationChannel(context, UPDATE_CHANNEL_ID, UPDATE_CHANNEL_NAME);
            this.mNbuilder.setChannelId(UPDATE_CHANNEL_ID);
        }
        if (notification.isProgress) {
            this.mNbuilder.setProgress(100, 0, false);
            this.getNotificationManager().notify(200, this.mNbuilder.build());
        } else {
            PendingIntent intent = notification.forceUpdate ? this.getReceiveIntent(context) : this.getActivityIntent(context);
            this.mNbuilder.setContentIntent(intent);
            this.getNotificationManager().notify(200, this.mNbuilder.build());
        }
    }

    private static void createNotificationChannel(Context context, String id2, String name) {
        NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(id2, (CharSequence)name, 2);
            if (manager != null) {
                channel.setSound(null, null);
                manager.createNotificationChannel(channel);
            }
        }
    }

    private PendingIntent getReceiveIntent(Context context) {
        Intent intent = new Intent(context, UpdateclockReceive.class);
        intent.putExtra("receiver_type", 1);
        PendingIntent clickIntent = PendingIntent.getBroadcast((Context)context, (int)1, (Intent)intent, (int)0x8000000);
        return clickIntent;
    }

    private PendingIntent getActivityIntent(Context context) {
        Intent intent = new Intent(context, UpgradeShowActivity.class);
        intent.addFlags(0x10000000);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)1, (Intent)intent, (int)0x8000000);
        return pendingIntent;
    }

    public void setProgress(int progress) {
        if (this.mNbuilder != null && this.getNotificationManager() != null) {
            this.mNbuilder.setProgress(100, progress, false);
            this.getNotificationManager().notify(200, this.mNbuilder.build());
        }
    }

    public void cancelNotification() {
        this.getNotificationManager().cancel(200);
    }

    private NotificationManager getNotificationManager() {
        if (this.mNotificationManager == null) {
            this.mNotificationManager = (NotificationManager)UpdateManager.getInstance().getContext().getSystemService("notification");
        }
        return this.mNotificationManager;
    }

    public static UpdateLoadingNotification setConfigProgressNf() {
        Builder builder = UpdateLoadingNotification.onConfigCommonNf(R.string.update_notification_title, R.string.update_notification_content);
        builder.setIsProgress(true);
        UpdateLoadingNotification mNotification = builder.builder();
        mNotification.showNotification(mNotification);
        return mNotification;
    }

    public static void setConfigInstallRemindNf(boolean isForceUpdate) {
        Builder builder = UpdateLoadingNotification.onConfigCommonNf(R.string.update_notification_insatll_title, R.string.update_notification_insatll_content);
        builder.setForceUpdate(isForceUpdate);
        builder.setIsProgress(false);
        UpdateLoadingNotification mNotification = builder.builder();
        mNotification.showNotification(mNotification);
    }

    private static Builder onConfigCommonNf(int titleId, int contentId) {
        Context context = UpdateManager.getInstance().getContext();
        Builder builder = new Builder();
        builder.setTitle(String.format(context.getResources().getString(titleId), AppUtil.getProjectName(context)));
        String content = String.format(context.getResources().getString(contentId), AppUtil.getProjectName(context));
        builder.setContent(content);
        builder.setResSmallIcon(R.drawable.notify_icon);
        builder.setResLargeIcon(R.drawable.notify_icon);
        builder.setEnableNotify(true);
        return builder;
    }

    public static class Builder {
        String content;
        String title;
        int resSmallIcon;
        int notifyId;
        boolean enableNotify;
        boolean isProgress;
        boolean autoCancel;
        int resLargeIcon;
        boolean forceUpdate;

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setResSmallIcon(int resSmallIcon) {
            this.resSmallIcon = resSmallIcon;
            return this;
        }

        public Builder setNotifyId(int notifyId) {
            this.notifyId = notifyId;
            return this;
        }

        public Builder setEnableNotify(boolean enableNotify) {
            this.enableNotify = enableNotify;
            return this;
        }

        public Builder setIsProgress(boolean isProgress) {
            this.isProgress = isProgress;
            return this;
        }

        public Builder setAutoCancel(boolean autoCancel) {
            this.autoCancel = autoCancel;
            return this;
        }

        public Builder setResLargeIcon(int resId) {
            this.resLargeIcon = resId;
            return this;
        }

        public Builder setForceUpdate(boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        public UpdateLoadingNotification builder() {
            return new UpdateLoadingNotification(this);
        }
    }
}

