/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.updatelibrary.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;

public class DensityUtil {
    public static int getScreenDpi(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        return dm.densityDpi;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int width = metrics.widthPixels;
        int height = metrics.heightPixels;
        return Math.max(width, height);
    }

    public static int dp2px(Context context, int dpVal) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)dpVal * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int getAndroidSDKVersion() {
        int version = 0;
        try {
            version = Build.VERSION.SDK_INT;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    public static int getNavigationBarHeight(Context context) {
        int navigationBarHeight = 0;
        if (DensityUtil.getAndroidSDKVersion() >= 21) {
            int resourceIdNavi = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
            navigationBarHeight = context.getResources().getDimensionPixelSize(resourceIdNavi);
        }
        return navigationBarHeight;
    }

    public static int getScreenWidth(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int width = metrics.widthPixels;
        int height = metrics.heightPixels;
        return Math.min(width, height);
    }

    public static int getStatusHeight(Activity activity) {
        int statusHeight = 0;
        Rect localRect = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(localRect);
        statusHeight = localRect.top;
        if (0 == statusHeight) {
            try {
                Class<?> localClass = Class.forName("com.android.internal.R$dimen");
                Object localObject = localClass.newInstance();
                int i5 = Integer.parseInt(localClass.getField("status_bar_height").get(localObject).toString());
                statusHeight = activity.getResources().getDimensionPixelSize(i5);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return statusHeight;
    }

    public static int getActionBarHeight(Context context) {
        TypedValue tv = new TypedValue();
        if (context.getTheme().resolveAttribute(16843499, tv, true)) {
            int actionBarHeight = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
            return actionBarHeight;
        }
        return 0;
    }

    public static void printScreenSize(Context context) {
        Log.e((String)"DensityUtil", (String)("width:" + DensityUtil.getScreenWidth(context) + ",height:" + DensityUtil.getScreenHeight(context)));
    }

    public static Point getScreenMetrics(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        int w_screen = dm.widthPixels;
        int h_screen = dm.heightPixels;
        return new Point(w_screen, h_screen);
    }

    public static float getScreenRate(Context context, float th) {
        Point P = DensityUtil.getScreenMetrics(context);
        float H = P.y;
        float W = P.x;
        H = (float)P.y - th;
        return H / W;
    }
}

