/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.updatelibrary.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.xdja.updatelibrary.data.UpdateInfo;
import com.xdja.updatelibrary.utils.AppUtil;

public class UpdateSharePreferenceUtils {
    private static final String UPDATE_REMIND = "update_remind";
    private static final String VERSION = "version";
    private static final String INFO = "info";
    private static final String FORCEUPDATE = "forceUpdate";

    public static void onChangeUpdateState(Context context, UpdateInfo info) {
        SharedPreferences preferences = context.getSharedPreferences(UPDATE_REMIND, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(VERSION, info.getVersion());
        editor.putString(INFO, info.getInfo());
        editor.putBoolean(FORCEUPDATE, info.isForceUpdate());
        editor.commit();
    }

    public static boolean getIsUpdateState(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(UPDATE_REMIND, 0);
        return !AppUtil.getCurrentVersion(context).equals(preferences.getString(VERSION, AppUtil.getCurrentVersion(context)));
    }

    public static UpdateInfo getUpdateMessage(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(UPDATE_REMIND, 0);
        UpdateInfo info = new UpdateInfo();
        info.setVersion(preferences.getString(VERSION, AppUtil.getCurrentVersion(context)));
        info.setInfo(preferences.getString(INFO, ""));
        info.setForceUpdate(preferences.getBoolean(FORCEUPDATE, false));
        return info;
    }

    public static void onChangeVersion(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(UPDATE_REMIND, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(VERSION, AppUtil.getCurrentVersion(context));
        editor.commit();
    }
}

