/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.updatelibrary;

import android.content.Context;
import com.xdja.updatelibrary.data.ServerPathBean;
import com.xdja.updatelibrary.data.ServerPathInterface;

public class UpdateConfig {
    private Context context;
    private boolean isReadAssets;
    private boolean isStartLocalAlarm;
    private int hour;
    private int minute;
    private boolean isNeedBreakPointResume;
    private ServerPathBean serverPathBean;
    private ServerPathInterface serverPathInterface;

    UpdateConfig(Builder builder) {
        this.context = builder.context;
        this.isReadAssets = builder.isReadAssets;
        this.hour = builder.alarmHour;
        this.minute = builder.alarmMinute;
        this.isStartLocalAlarm = builder.isStartLocakAlarm;
        this.isNeedBreakPointResume = builder.isNeedBreakPointResume;
        this.serverPathBean = builder.serverPathBean;
        this.serverPathInterface = builder.serverPathInterface;
    }

    public Context getApplictionContext() {
        return this.context;
    }

    public boolean getIsReadAssets() {
        return this.isReadAssets;
    }

    public boolean isStartLocaLAlarm() {
        return this.isStartLocalAlarm;
    }

    public int getLocaLAlarmHour() {
        return this.hour;
    }

    public int getLocaLAlarmMinute() {
        return this.minute;
    }

    public boolean isNeedBreakPointResume() {
        return this.isNeedBreakPointResume;
    }

    public ServerPathBean getServerPathBean() {
        return this.serverPathBean;
    }

    public void setServerPathBean(ServerPathBean serverPathBean) {
        this.serverPathBean = serverPathBean;
    }

    public ServerPathInterface getServerPathInterface() {
        return this.serverPathInterface;
    }

    public static class Builder {
        Context context;
        boolean isReadAssets = false;
        boolean isStartLocakAlarm = true;
        int alarmHour = 9;
        int alarmMinute = 0;
        boolean isNeedBreakPointResume = false;
        ServerPathBean serverPathBean;
        ServerPathInterface serverPathInterface;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder configIsReadAssets(boolean isReadAssets) {
            this.isReadAssets = isReadAssets;
            return this;
        }

        public Builder configIsStartLocalAlarmCheck(boolean isStart) {
            this.isStartLocakAlarm = isStart;
            return this;
        }

        public Builder configLocalAlarmCheckTime(int hour, int minute) {
            this.alarmHour = hour;
            this.alarmMinute = minute;
            return this;
        }

        public Builder configIsNeedBreakPointResume(boolean isNeedBreakPointResume) {
            this.isNeedBreakPointResume = isNeedBreakPointResume;
            return this;
        }

        public Builder configServerPath(ServerPathBean serverPathBean) {
            this.serverPathBean = serverPathBean;
            return this;
        }

        public Builder configServerPathInterface(ServerPathInterface serverPathInterface) {
            this.serverPathInterface = serverPathInterface;
            return this;
        }

        public UpdateConfig build() {
            return new UpdateConfig(this);
        }
    }
}

