/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.updatelibrary;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import com.xdja.update.UpdateManager;
import com.xdja.updatelibrary.ModuleToast;
import com.xdja.updatelibrary.R;
import com.xdja.updatelibrary.XDJAUpdateService;
import com.xdja.updatelibrary.data.DialogCancelInterface;
import com.xdja.updatelibrary.data.UpdateInfo;
import com.xdja.updatelibrary.data.UpdateLoadingNotification;
import com.xdja.updatelibrary.utils.DialogUpdateUtil;
import com.xdja.updatelibrary.utils.UpdateSharePreferenceUtils;
import com.xdja.updatelibrary.widget.UpdateProgressDialog;
import java.lang.ref.WeakReference;

public class XDJAUpdateExecutor
implements XDJAUpdateService.UpdateInterface,
DialogUpdateUtil.DialogUpdateInterface {
    private UpdateLoadingNotification mNotification;
    public static final int UPDATE_CLICK_CHECK = 1;
    public static final int UPDATE_ALARM_CHECK = 2;
    public static final int UPDATE_ONLY_CHECK = 3;
    private boolean mNoShowToast;
    private WeakReference<Context> mWeakReferenceContext;
    private int mUpdateType;
    private UpdateProgressDialog mProgressDialog;
    private AlertDialog mCheckingDialog;
    private boolean mIsForceUpdate;
    private DialogCancelInterface mCancelInterface;

    public static XDJAUpdateExecutor getInstance() {
        return new XDJAUpdateExecutor();
    }

    public void onCheckIsNeedUpdate(Context context) {
        if (!XDJAUpdateService.getInstance().isCheckingOrLoading()) {
            this.mWeakReferenceContext = new WeakReference<Context>(context);
            this.mUpdateType = 1;
            if (this.mWeakReferenceContext.get() != null) {
                this.mCheckingDialog = DialogUpdateUtil.showCheckLoading((Context)this.mWeakReferenceContext.get());
                this.mCheckingDialog.show();
            }
            XDJAUpdateService.getInstance().onStartCheckUpdate(this);
        }
    }

    public void onLocalAlarmCheckUpdate() {
        if (!XDJAUpdateService.getInstance().isCheckingOrLoading()) {
            this.mUpdateType = 2;
            XDJAUpdateService.getInstance().onStartCheckUpdate(this);
        }
    }

    public void onForceShowUpdateDialog(Context context) {
        if (!XDJAUpdateService.getInstance().isCheckingOrLoading()) {
            this.mNoShowToast = true;
            this.mWeakReferenceContext = new WeakReference<Context>(context);
            this.mUpdateType = 1;
            XDJAUpdateService.getInstance().onStartCheckUpdate(this);
        }
    }

    public void onOnlyCheckUpdate() {
        if (!XDJAUpdateService.getInstance().isCheckingOrLoading()) {
            this.mUpdateType = 3;
            XDJAUpdateService.getInstance().onStartCheckUpdate(this);
        }
    }

    public void onClickNotificationShowDialog(Context context, DialogCancelInterface dialogCancelInterface) {
        this.mCancelInterface = dialogCancelInterface;
        if (!XDJAUpdateService.getInstance().isCheckingOrLoading()) {
            this.onCheckIsNeedUpdate(context);
        } else {
            this.onCancelInterface();
        }
    }

    public void onDownloadUpdateFile(int updateType) {
        this.mUpdateType = updateType;
        if (!XDJAUpdateService.getInstance().isCheckingOrLoading() && UpdateSharePreferenceUtils.getIsUpdateState(UpdateManager.getInstance().getContext())) {
            boolean isError = XDJAUpdateService.getInstance().onDownLoadApkFile(this);
            if (isError) {
                this.onUpdateDownloadFailUi(true);
            }
        } else {
            this.onUpdateDownloadFailUi(false);
        }
    }

    private void onCancelDownLoadUpdate() {
        XDJAUpdateService.getInstance().onStopLoad();
    }

    @Override
    public void onUpdateCheckResult(String result, UpdateInfo info) {
        this.mIsForceUpdate = info.isForceUpdate();
        if (this.mCheckingDialog != null) {
            this.mCheckingDialog.dismiss();
            this.mCheckingDialog = null;
        }
        if (this.mUpdateType == 3) {
            return;
        }
        if (this.mUpdateType == 1) {
            if (this.mWeakReferenceContext.get() == null) {
                return;
            }
            if (this.mWeakReferenceContext.get() instanceof Activity && (((Activity)this.mWeakReferenceContext.get()).isFinishing() || ((Activity)this.mWeakReferenceContext.get()).isDestroyed())) {
                return;
            }
            if (result.equals("0")) {
                DialogUpdateUtil.showUpdateDialog((Context)this.mWeakReferenceContext.get(), info, this);
            } else if (result.equals("1") && !this.mNoShowToast) {
                ModuleToast.showNoRepeat((Context)this.mWeakReferenceContext.get(), ((Context)this.mWeakReferenceContext.get()).getResources().getString(R.string.update_check_newest));
                this.onCancelInterface();
            } else if (!this.mNoShowToast) {
                ModuleToast.showNoRepeat((Context)this.mWeakReferenceContext.get(), ((Context)this.mWeakReferenceContext.get()).getResources().getString(R.string.update_check_error));
                this.onCancelInterface();
            }
        } else if (result.equals("0")) {
            UpdateLoadingNotification.setConfigInstallRemindNf(info.isForceUpdate());
        }
    }

    @Override
    public void onUpdatedownloadStart() {
        this.mNotification = UpdateLoadingNotification.setConfigProgressNf();
    }

    @Override
    public void onUpdatedownloadProgress(long totalSize, long cSize) {
        int progress = (int)((float)cSize / (float)totalSize * 100.0f);
        if (this.mNotification != null) {
            this.mNotification.setProgress(progress);
        }
        if (this.mUpdateType == 1 && this.mProgressDialog != null) {
            this.mProgressDialog.setProgress(progress);
        }
    }

    @Override
    public void onUpdatedownloadSuccess() {
        if (this.mNotification != null) {
            this.mNotification.cancelNotification();
        }
        this.onCancelInterface();
        this.onDismissProgressDialog();
    }

    @Override
    public void onUpdatedownloadError() {
        this.onUpdateDownloadFailUi(true);
    }

    private void onUpdateDownloadFailUi(boolean isShowErrDg) {
        if (this.mNotification != null) {
            this.mNotification.cancelNotification();
            this.mNotification = null;
        }
        this.onDismissProgressDialog();
        if (this.mUpdateType == 1 && isShowErrDg) {
            if (this.mWeakReferenceContext.get() == null) {
                return;
            }
            DialogUpdateUtil.showDownLoadFailed((Context)this.mWeakReferenceContext.get(), this);
        }
    }

    private void onShowDownProgress() {
        if (this.mWeakReferenceContext.get() == null) {
            return;
        }
        this.mProgressDialog = new UpdateProgressDialog((Context)this.mWeakReferenceContext.get());
        this.mProgressDialog.setDialogClickInterface(this);
        this.mProgressDialog.setIsForceUpdate(this.mIsForceUpdate);
        this.mProgressDialog.show();
        this.onDownloadUpdateFile(this.mUpdateType);
    }

    private void onDismissProgressDialog() {
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
            this.mProgressDialog = null;
        }
    }

    @Override
    public void onDgUpdateSuccess(String result) {
        if (result != null) {
            if (result.equals("cancel_download")) {
                this.onUpdateDownloadFailUi(true);
                this.onCancelDownLoadUpdate();
            } else if (result.equals("dialog_download_ok")) {
                this.onShowDownProgress();
            } else if (result.equals("dialog_cancel")) {
                this.onCancelInterface();
            }
        }
    }

    private void onCancelInterface() {
        if (this.mCancelInterface != null) {
            this.mCancelInterface.onFinshActivity();
            this.mCancelInterface = null;
        }
    }
}

