/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.updatelibrary;

import android.content.Context;
import android.util.Log;
import com.xdja.update.UpdateManager;
import com.xdja.updatelibrary.UpdateConfig;
import com.xdja.updatelibrary.data.ServerPathInterface;
import com.xdja.updatelibrary.utils.UpdateAlarmUtils;

public class XDJAUpdateManager {
    static UpdateConfig config;

    public static void onConfigCheckProtocol(ServerPathInterface serverPath) {
        config.setServerPathBean(serverPath.getServerPath());
    }

    public static void init(UpdateConfig config) {
        XDJAUpdateManager.config = config;
        if (config != null) {
            UpdateManager.getInstance().install(config.getApplictionContext());
            if (config.getServerPathInterface() != null) {
                XDJAUpdateManager.onConfigCheckProtocol(config.getServerPathInterface());
            } else {
                XDJAUpdateManager.onConfigCheckProtocol(ServerPathInterface.DEFAULT_SERVERPATH);
            }
            if (config.isStartLocaLAlarm()) {
                UpdateAlarmUtils.setLocalAlarm(UpdateManager.getInstance().getContext(), config.getLocaLAlarmHour(), config.getLocaLAlarmMinute(), 1);
            }
        } else {
            Log.e((String)"XDJAUpdateManager", (String)"\u5347\u7ea7\u914d\u7f6e\u4e3a\u7a7a");
        }
    }

    public static void init(Context context) {
        UpdateConfig config = new UpdateConfig.Builder(context).configIsReadAssets(true).build();
        XDJAUpdateManager.init(config);
    }

    public static UpdateConfig getConfig() {
        if (config == null) {
            throw new IllegalStateException("Configuration is not initialized. Please call init(FlowConfig) in your application class.");
        }
        return config;
    }
}

