/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.updatelibrary.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.updatelibrary.R;
import com.xdja.updatelibrary.data.UpdateInfo;

public class DialogUpdateUtil {
    public static final String DIALOG_CANCEL = "dialog_cancel";
    public static final String DIALOG_DOWNLOAD_OK = "dialog_download_ok";

    public static AlertDialog showCheckLoading(Context context) {
        AlertDialog connectDialog = new AlertDialog.Builder(context, R.style.UpdateLibDialogTheme).create();
        View view = LayoutInflater.from((Context)context).inflate(R.layout.dialog_checking_progress, null);
        ImageView mConnectingView = (ImageView)view.findViewById(R.id.iv_loading);
        Animation rotateAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.rotate_anim);
        mConnectingView.startAnimation(rotateAnimation);
        connectDialog.setView(view);
        return connectDialog;
    }

    public static void showUpdateDialog(Context context, UpdateInfo updateInfo, final DialogUpdateInterface result) {
        final AlertDialog dialog = new AlertDialog.Builder((Context)new ContextThemeWrapper(context, R.style.UpdateLibDialogTheme)).create();
        dialog.requestWindowFeature(1);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.update_dialog, null, false);
        dialog.setView(view);
        boolean forceUpdate = updateInfo.isForceUpdate();
        TextView title = (TextView)view.findViewById(R.id.title);
        title.setText(forceUpdate ? R.string.dg_update_force_update : R.string.dg_update_new_version);
        TextView version = (TextView)view.findViewById(R.id.version_code);
        version.setText((CharSequence)String.format(context.getResources().getString(R.string.update_version), updateInfo.getVersion()));
        TextView info = (TextView)view.findViewById(R.id.version_desc);
        info.setText((CharSequence)updateInfo.getInfo());
        Button positive = (Button)view.findViewById(R.id.dialog_positive);
        positive.setText(R.string.dg_update_update_now);
        positive.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.cancel();
                result.onDgUpdateSuccess(DialogUpdateUtil.DIALOG_DOWNLOAD_OK);
            }
        });
        Button negative = (Button)view.findViewById(R.id.dialog_negative);
        negative.setText(R.string.dg_update_remind_later);
        negative.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.cancel();
                result.onDgUpdateSuccess(DialogUpdateUtil.DIALOG_CANCEL);
            }
        });
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        negative.setVisibility(forceUpdate ? 8 : 0);
        dialog.show();
    }

    public static void showNoWifeDialog(Context context, DialogUpdateInterface updateInterface) {
        AlertDialog dialog = new AlertDialog.Builder((Context)new ContextThemeWrapper(context, R.style.UpdateLibDialogTheme)).create();
        dialog.requestWindowFeature(1);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.nowife_dialog, null, false);
        dialog.setView(view);
        dialog.show();
    }

    public static void showDownLoadFailed(Context context, final DialogUpdateInterface result) {
        if (((Activity)context).isDestroyed() || ((Activity)context).isFinishing()) {
            return;
        }
        final AlertDialog dialog = new AlertDialog.Builder((Context)new ContextThemeWrapper(context, R.style.UpdateLibDialogTheme)).create();
        dialog.requestWindowFeature(1);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.download_failed_dialog, null, false);
        dialog.setView(view);
        Button positive = (Button)view.findViewById(R.id.dialog_positive);
        positive.setVisibility(8);
        Button negative = (Button)view.findViewById(R.id.dialog_negative);
        negative.setText(R.string.dg_update_fail_ok);
        negative.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.cancel();
                result.onDgUpdateSuccess(DialogUpdateUtil.DIALOG_CANCEL);
            }
        });
        dialog.show();
    }

    public static interface DialogUpdateInterface {
        public void onDgUpdateSuccess(String var1);
    }
}

