/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.updatelibrary.utils;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.xdja.updatelibrary.data.UpOperationInterface;
import com.xdja.updatelibrary.data.UpdatePushOperation;
import com.xdja.updatelibrary.receive.UpdateclockReceive;
import java.util.Calendar;

public class UpdateAlarmUtils {
    private static final int INTERVAL = 86400000;
    private static UpOperationInterface OPERATION = null;

    public static void sendPushData(int type) {
        if (OPERATION == null) {
            OPERATION = new UpdatePushOperation();
        }
        OPERATION.onSendUpdateMessage(type);
    }

    public static void setLocalAlarm(Context context, int hour, int minute, int type) {
        UpdateAlarmUtils.initAlarm(context, hour, minute, type);
    }

    public static void setUpOperationInterface(UpOperationInterface operation) {
        OPERATION = operation;
    }

    private static void initAlarm(Context context, int hour, int minute, int type) {
        AlarmManager alarmService = (AlarmManager)context.getSystemService("alarm");
        Calendar instance = Calendar.getInstance();
        instance.set(11, hour);
        instance.set(12, minute);
        instance.set(13, 0);
        Intent alarmIntent = new Intent(context, UpdateclockReceive.class);
        alarmIntent.putExtra("receiver_type", 2);
        PendingIntent broadcast = PendingIntent.getBroadcast((Context)context, (int)type, (Intent)alarmIntent, (int)0x10000000);
        if (Build.VERSION.SDK_INT >= 19) {
            alarmService.setWindow(0, UpdateAlarmUtils.calMethod(instance.getTimeInMillis()), 86400000L, broadcast);
        } else {
            alarmService.setRepeating(0, UpdateAlarmUtils.calMethod(instance.getTimeInMillis()), 86400000L, broadcast);
        }
    }

    private static long calMethod(long dateTime) {
        long time = 0L;
        time = dateTime > System.currentTimeMillis() ? dateTime : dateTime + 86400000L;
        return time;
    }
}

