/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.updatelibrary.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.xdja.updatelibrary.R;
import com.xdja.updatelibrary.utils.DensityUtil;
import com.xdja.updatelibrary.utils.DialogUpdateUtil;

public class UpdateProgressDialog
extends Dialog {
    public static final String CANCEL_DOWNLOAD = "cancel_download";
    private View mView;
    private ProgressBar mProgressBar;
    private static final int RESID = R.style.UpdateLibDialogTheme;
    private DialogUpdateUtil.DialogUpdateInterface mInterface;
    private View mBottomView;

    public UpdateProgressDialog(@NonNull Context context) {
        super(context, RESID);
        this.initView();
    }

    public UpdateProgressDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
        this.initView();
    }

    public void setDialogClickInterface(DialogUpdateUtil.DialogUpdateInterface updateInterface) {
        this.mInterface = updateInterface;
    }

    public void setIsForceUpdate(boolean isForceUpdate) {
        if (this.mBottomView == null) {
            return;
        }
        this.mBottomView.setVisibility(isForceUpdate ? 8 : 0);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.mView);
        this.setCanceledOnTouchOutside(false);
        this.setCancelable(false);
    }

    private void initView() {
        this.mView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.update_progress, null);
        this.mProgressBar = (ProgressBar)this.mView.findViewById(R.id.pb_download);
        Button positive = (Button)this.mView.findViewById(R.id.dialog_positive);
        positive.setVisibility(8);
        Button negative = (Button)this.mView.findViewById(R.id.dialog_negative);
        negative.setText(R.string.dg_cancel_downloan);
        negative.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UpdateProgressDialog.this.dismiss();
                if (UpdateProgressDialog.this.mInterface != null) {
                    UpdateProgressDialog.this.mInterface.onDgUpdateSuccess(UpdateProgressDialog.CANCEL_DOWNLOAD);
                }
            }
        });
        this.mBottomView = this.mView.findViewById(R.id.include_bottom);
        LinearLayout linear = (LinearLayout)this.mView.findViewById(R.id.linear_update_progress);
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)linear.getLayoutParams();
        layoutParams.width = (int)((double)DensityUtil.getScreenWidth(this.getContext()) * 0.9);
        linear.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setProgress(int progress) {
        if (this.mProgressBar != null) {
            this.mProgressBar.setProgress(progress);
        }
    }
}

