/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.authorize;

import android.content.Context;
import android.text.TextUtils;
import com.xdja.authorize.AuthorizeLogin;
import com.xdja.authorize.AuthorizeLoginHandler;
import com.xdja.authorize.AuthorizeReceiver;

public class AuthorHelper {
    private final Context mcontext;
    private final AuthorizeLoginHandler mauthorizeLoginHandler;

    public AuthorHelper(Context context, AuthorizeLoginHandler authorizeLoginHandler) {
        this.mcontext = context;
        this.mauthorizeLoginHandler = authorizeLoginHandler;
        AuthorizeReceiver.setHandle(this.mauthorizeLoginHandler);
    }

    public void author(String packageName) {
        this.author(packageName, "1");
    }

    public void author(String packageName, String needLoginPage) {
        String billString = AuthorizeLogin.getBill(this.mcontext, packageName, needLoginPage);
        if (!TextUtils.isEmpty((CharSequence)billString)) {
            this.mauthorizeLoginHandler.onAuthorizeOKHandle(billString);
        } else if (this.mauthorizeLoginHandler != null) {
            this.mauthorizeLoginHandler.onAuthorizeErrorHandle(AuthorizeLogin.getCode(), AuthorizeLogin.getMessage());
        }
    }
}

