/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.bean;

import android.content.Context;
import com.xdja.safeclient.certcreation.R;

public class OkNetError {
    public static final String MISSING_REQUIRED_PARAMETERS = "missing_required_parameters";
    public static final String MISSING_REQUIRED_PARAMETERS_CODE = String.valueOf(4);
    public static final String ILLEGAL_REQUEST_PARAMETER = "illegal_request_parameter";
    public static final String ILLEGAL_REQUEST_PARAMETER_CODE = String.valueOf(5);
    public static final String SERVER_INTERNAL_EXCEPTION = "server_internal_exception";
    public static final String SERVER_INTERNAL_EXCEPTION_CODE = String.valueOf(9);
    public static final String REQUEST_METHOD_NOT_SUPPORTED = "request_method_not_supported";
    public static final String REQUEST_METHOD_NOT_SUPPORTED_CODE = String.valueOf(16);
    public static final String PARAMETERS_SIGN_VERIFY_FAILED = "parameters_sign_verify_failed";
    public static final String PARAMETERS_SIGN_VERIFY_FAILED_CODE = String.valueOf(17);
    public static final String ID_CARD_RESOLVE_FAILED = "id_card_resolve_failed";
    public static final String ID_CARD_RESOLVE_FAILED_CODE = String.valueOf(4097);
    public static final String FACE_AUTH_FAILED = "face_auth_failed";
    public static final String FACE_AUTH_FAILED_CODE = String.valueOf(4129);
    public static final String IDENTIFY_NOT_POLICE = "identity_not_police";
    public static final String IDENTIFY_NOT_POLICE_CODE = String.valueOf(4131);
    public static final String IDENTITY_CHECK_REPEAT = "identity_check_repeat";
    public static final String IDENTITY_CHECK_REPEAT_CODE = String.valueOf(4132);
    public static final String CARD_TYPE_ERROR = "card_type_error";
    public static final String CARD_TYPE_ERROR_CODE = String.valueOf(4133);
    public static final String LICENSE_LIMIT = "license_limit";
    public static final String LICENSE_LIMIT_CODE = String.valueOf(4134);
    public static final String CAALG_ERROR = "caAlg_error";
    public static final String CAALG_ERROR_CODE = String.valueOf(4135);
    public static final String IDENTITY_EXPIRE = "identity_expire";
    public static final String IDENTITY_EXPIRE_CODE = String.valueOf(4136);
    public static final String CARD_IDENTITY_NOT_SAME = "card_identity_not_same";
    public static final String CARD_IDENTITY_NOT_SAME_CODE = String.valueOf(4137);
    public static final String PHONE_NOT_VALID_PAMS = "phone_not_valid_pams";
    public static final String PHONE_NOT_VALID_PAMS_CODE = String.valueOf(4144);
    public static final String NOT_MATCH_HEADER_IMG = "not_match_header_img";
    public static final String NOT_MATCH_HEADER_IMG_CODE = String.valueOf(4145);
    public static final String NOT_REALITY_HEADER_IMG = "not_reality_header_img";
    public static final String NOT_REALITY_HEADER_IMG_CODE = String.valueOf(4146);
    public static final String ONE_CARD_TYPE_ONE_CERT = "one_card_type_one_cert";
    public static final String ONE_CARD_TYPE_ONE_CERT_CODE = String.valueOf(4147);
    public static final String PHOTO_IDENTITY_FAIL = "photo_identity_fail";
    public static final String PHOTO_IDENTITY_FAIL_CODE = String.valueOf(4161);
    public static final String NOT_FOUND_CHECK_INFO = "not_found_check_info";
    public static final String NOT_FOUND_CHECK_INFO_CODE = String.valueOf(4162);
    public static final String CARD_CERT_EXIST = "card_cert_exist";
    public static final String CARD_CERT_EXIST_CODE = String.valueOf(4193);
    public static final String P10_FROMAT_ERROR = "P10_fromat_error";
    public static final String P10_FROMAT_ERROR_CODE = String.valueOf(4194);
    public static final String IDENTITY_INFO_ERROR = "identity_info_error";
    public static final String IDENTITY_INFO_ERROR_CODE = String.valueOf(4195);
    public static final String CERT_ISSUE_FREQUENTLY = "cert_issue_frequently";
    public static final String CERT_ISSUE_FREQUENTLY_CODE = String.valueOf(4196);
    public static final String IDENTITY_CHECK_REFUSE = "identity_check_refuse";
    public static final String IDENTITY_CHECK_REFUSE_CODE = String.valueOf(4197);
    public static final String IDENTITY_CHECK_WAITING = "identity_check_waiting";
    public static final String IDENTITY_CHECK_WAITING_CODE = String.valueOf(4198);
    public static final String CERT_ISSUE_FAILE = "cert_issue_faile";
    public static final String CERT_ISSUE_FAILE_CODE = String.valueOf(4199);
    public static final String CERT_UPDATES_FAIL = "cert_updates_fail";
    public static final String CERT_UPDATES_FAIL_CODE = String.valueOf(4209);
    public static final String CERT_UPDATE_FREQUENTLY = "cert_update_frequently";
    public static final String CERT_UPDATE_FREQUENTLY_CODE = String.valueOf(4210);
    public static final String CERT_STATUS_NORMAL = "cert_status_normal";
    public static final String CERT_STATUS_NORMAL_CODE = String.valueOf(4242);
    public static final String CERT_FREEZE_FREQUENTLY = "cert_freeze_frequently";
    public static final String CERT_FREEZE_FREQUENTLY_CODE = String.valueOf(4243);
    public static final String CERT_NOT_EXIST = "cert_not_exist";
    public static final String CERT_NOT_EXIST_CODE = String.valueOf(4257);
    public static final String CERT_IS_REVOKE = "cert_is_revoke";
    public static final String CERT_IS_REVOKE_CODE = String.valueOf(4258);
    public static final String CERT_REVOKE_FAIL = "cert_revoke_fail";
    public static final String CERT_REVOKE_FAIL_CODE = String.valueOf(4259);
    public static final String CERT_STATUS_OTHER = "cert_status_other";
    public static final String CERT_STATUS_OTHER_CODE = String.valueOf(4260);
    public static final String APP_TIME_EXCEPTION = "app_time_exception";
    public static final String APP_TIME_EXCEPTION_CODE = String.valueOf(5797);
    public static final String NOT_EXIST_INFO = "not_exist_info";
    public static final String NOT_EXIST_INFO_CODE = String.valueOf(4261);
    public static final String CLIENT_SERVER_CERT_NOT_SAME = "client_server_cert_not_same";
    public static final String CLIENT_SERVER_CERT_NOT_SAME_CODE = String.valueOf(4262);
    public static final String CERT_UNLOCK_FAILED = "cert_status_other";
    public static final String CERT_UNLOCK_FAILED_CODE = String.valueOf(4241);
    public static final String CERT_UPDATES_FREEZE_FAIL = "cert_updates_freeze_fail";
    public static final String CERT_UPDATES_FERRZE_FAIL_CODE = String.valueOf(8193);
    public static final String CHIP_NOT_USER_INFO = "chip_not_user_info";
    public static final String CHIP_NOT_USER_INFO_CODE = String.valueOf(12289);
    public static final String CERT_HAS_FREEZE = "cert_has_freeze";
    public static final String CERT_HAS_FREEZE_CODE = String.valueOf(8194);

    public static String handleErrorCodeToMsg(Context context, String errorCode) {
        return OkNetError.userError(context, errorCode);
    }

    public static String toHex(String errorCode) {
        String hex = Integer.toHexString(Integer.parseInt(errorCode));
        return OkNetError.fill(hex);
    }

    private static String fill(String errorCode) {
        int num = 4 - errorCode.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            sb.append("0");
        }
        sb.append(errorCode);
        return sb.toString();
    }

    public static String userError(Context context, String errorCode) {
        try {
            if (errorCode.equals(MISSING_REQUIRED_PARAMETERS_CODE) || errorCode.equals(ILLEGAL_REQUEST_PARAMETER_CODE) || errorCode.equals(SERVER_INTERNAL_EXCEPTION_CODE) || errorCode.equals(REQUEST_METHOD_NOT_SUPPORTED_CODE) || errorCode.equals(PARAMETERS_SIGN_VERIFY_FAILED_CODE) || errorCode.equals(ID_CARD_RESOLVE_FAILED_CODE) || errorCode.equals(PHOTO_IDENTITY_FAIL_CODE) || errorCode.equals(NOT_FOUND_CHECK_INFO_CODE) || errorCode.equals(FACE_AUTH_FAILED_CODE) || errorCode.equals(CERT_ISSUE_FAILE_CODE) || errorCode.equals(CERT_STATUS_OTHER_CODE) || errorCode.equals(IDENTITY_INFO_ERROR_CODE) || errorCode.equals(P10_FROMAT_ERROR_CODE) || errorCode.equals(CERT_REVOKE_FAIL_CODE) || errorCode.equals(CAALG_ERROR_CODE) || errorCode.equals(CARD_TYPE_ERROR_CODE) || errorCode.equals(CERT_UNLOCK_FAILED_CODE) || errorCode.equals(CERT_UPDATES_FAIL_CODE) || errorCode.equals(CERT_UPDATES_FERRZE_FAIL_CODE)) {
                return String.format(context.getString(R.string.server_error), OkNetError.toHex(errorCode));
            }
            if (errorCode.equals(CERT_NOT_EXIST_CODE) || errorCode.equals(NOT_EXIST_INFO_CODE)) {
                return String.format(context.getString(R.string.cert_not_exist_show), OkNetError.toHex(errorCode));
            }
            if (errorCode.equals(IDENTIFY_NOT_POLICE_CODE)) {
                return context.getString(R.string.identity_not_police_user);
            }
            if (errorCode.equals(NOT_MATCH_HEADER_IMG_CODE)) {
                return context.getString(R.string.not_match_header_img_user);
            }
            if (errorCode.equals(LICENSE_LIMIT_CODE)) {
                return context.getString(R.string.license_limit_user);
            }
            if (errorCode.equals(CARD_CERT_EXIST_CODE) || errorCode.equals(CLIENT_SERVER_CERT_NOT_SAME_CODE) || errorCode.equals(CARD_IDENTITY_NOT_SAME_CODE)) {
                return String.format(context.getString(R.string.device_occupied), OkNetError.toHex(errorCode));
            }
            if (errorCode.equals(CHIP_NOT_USER_INFO_CODE)) {
                return context.getString(R.string.chip_not_user_info);
            }
            if (errorCode.equals(IDENTITY_CHECK_REPEAT_CODE) || errorCode.equals(IDENTITY_CHECK_WAITING_CODE)) {
                return context.getString(R.string.apply_should_be_only_once);
            }
            if (errorCode.equals(ONE_CARD_TYPE_ONE_CERT_CODE)) {
                return context.getString(R.string.one_card_type_one_cert_user);
            }
            if (errorCode.equals(NOT_REALITY_HEADER_IMG_CODE)) {
                return context.getString(R.string.not_reality_header_img_user);
            }
            if (errorCode.equals(IDENTITY_EXPIRE_CODE)) {
                return context.getString(R.string.identity_expire_user);
            }
            if (errorCode.equals(CERT_ISSUE_FREQUENTLY_CODE) || errorCode.equals(CERT_FREEZE_FREQUENTLY_CODE)) {
                return String.format(context.getString(R.string.operate_frequently), OkNetError.toHex(errorCode));
            }
            if (errorCode.equals(CERT_IS_REVOKE_CODE)) {
                return context.getString(R.string.cert_is_revoke_user);
            }
            if (errorCode.equals(CERT_HAS_FREEZE_CODE)) {
                return context.getString(R.string.cert_has_freeze_code);
            }
            if (errorCode.equals(APP_TIME_EXCEPTION_CODE)) {
                return context.getString(R.string.app_time_exception_user);
            }
            if (errorCode.equals(PHONE_NOT_VALID_PAMS_CODE)) {
                return context.getString(R.string.phone_not_valid_pams);
            }
            if (errorCode.equals(IDENTITY_CHECK_REFUSE_CODE)) {
                return context.getString(R.string.identity_check_refuse);
            }
            if (errorCode.equals(CERT_STATUS_NORMAL_CODE)) {
                return context.getString(R.string.cert_status_normal);
            }
            return String.format(context.getString(R.string.unknown_error_2), OkNetError.toHex(errorCode));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return errorCode;
        }
    }
}

