/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.util;

import android.content.Context;
import android.content.res.AssetManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.util.ModuleLog;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Util {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean assetFileIsExist(Context context, String fileName) {
        InputStream inputStream = null;
        AssetManager manager = context.getAssets();
        try {
            inputStream = manager.open(fileName);
            if (inputStream != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static CryptoDevType getChipBeanType(ChipBean chipBean) {
        switch (chipBean.getType()) {
            case 0: {
                return CryptoDevType.DEV_TYPE_SdCard;
            }
            case 1: {
                return CryptoDevType.DEV_TYPE_Chip;
            }
            case 3: {
                return CryptoDevType.DEV_TYPE_SimKey;
            }
            case 7: {
                return CryptoDevType.DEV_TYPE_VHSM;
            }
        }
        return CryptoDevType.DEV_TYPE_Chip;
    }

    public static CryptoDevType getChipBeanType(int type) {
        switch (type) {
            case 0: {
                return CryptoDevType.DEV_TYPE_SdCard;
            }
            case 1: {
                return CryptoDevType.DEV_TYPE_Chip;
            }
            case 3: {
                return CryptoDevType.DEV_TYPE_SimKey;
            }
            case 7: {
                return CryptoDevType.DEV_TYPE_VHSM;
            }
        }
        return CryptoDevType.DEV_TYPE_Chip;
    }

    public static int convertCardType(int type) {
        switch (type) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 6;
            }
            case 7: {
                return 7;
            }
        }
        return -1;
    }

    public static String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    private static boolean certIsValid(CertDetailInfo info) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date dataStart = sdf.parse(info.notBefore);
            Date dataEnd = sdf.parse(info.notAfter);
            Date currentDate = new Date();
            ModuleLog.e("currentDate = " + currentDate.toString());
            ModuleLog.e("currentDate.after(dataStart) = " + currentDate.after(dataStart));
            ModuleLog.e("currentDate.before(dataEnd) = " + currentDate.before(dataEnd));
            if (currentDate.after(dataStart) && currentDate.before(dataEnd)) {
                return true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean certValidIsExpire(CertDetailInfo info) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date dataEnd = sdf.parse(info.notAfter);
            Date currentDate = new Date();
            ModuleLog.e("currentDate = " + currentDate.toString());
            ModuleLog.e("currentDate.getTime() = " + currentDate.getTime());
            ModuleLog.e("dataEnd.getTime() = " + dataEnd.getTime());
            if (Util.certIsValid(info) && dataEnd.getTime() - currentDate.getTime() < 1296000000L) {
                return true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }
}

