/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.view;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.widget.TextView;
import com.xdja.safeclient.certcreation.R;
import com.xdja.util.WeakReferenceHandler;

public class LoadingDialog
extends Dialog {
    private TextView tv_content;
    private String content;
    private long startTime = 0L;
    private long dur = 500L;
    private long endTime = 0L;
    private MyHandler myHandler = new MyHandler(this);
    private static final int MSG_DISMISS = 0;

    public LoadingDialog(Context context) {
        super(context, R.style.Theme_AppCompat_Dialog);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.loading_dialog);
        this.tv_content = (TextView)this.findViewById(R.id.tv_content);
        this.setContent(this.content);
        this.setCanceledOnTouchOutside(false);
    }

    public void setContent(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        this.content = content;
        if (this.tv_content == null) {
            return;
        }
        this.tv_content.setText((CharSequence)this.content);
    }

    public void setContent(@StringRes int strRes) {
        if (strRes == 0) {
            return;
        }
        this.content = this.getContext().getString(strRes);
        if (this.tv_content == null) {
            return;
        }
        this.tv_content.setText((CharSequence)this.content);
    }

    public void showLoading() {
        if (this.isShowing()) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.show();
    }

    public void dismissLoading() {
        if (this.isShowing()) {
            this.endTime = System.currentTimeMillis();
            long del = this.endTime - this.startTime;
            if (del > this.dur) {
                this.myHandler.removeMessages(0);
                this.dismiss();
            } else {
                long delay = this.startTime + this.dur - this.endTime;
                this.myHandler.sendEmptyMessageDelayed(0, delay);
            }
        }
    }

    static class MyHandler
    extends WeakReferenceHandler<LoadingDialog> {
        public MyHandler(LoadingDialog reference) {
            super((Object)reference);
        }

        protected void handleMessage(LoadingDialog reference, Message msg) {
            if (reference != null && reference.isShowing()) {
                try {
                    reference.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

