/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.util.ActivityController;

@Route(path="/cert/auth_fail", name="\u5b9e\u4f53\u8ba4\u8bc1\u5931\u8d25")
public class AuthenticationFailActivity
extends BaseActivity {
    private TextView fail_reason;
    private Button retry;
    @Autowired(name="result")
    public CompareResult compareResult;
    @Autowired(name="devType")
    public CryptoDevType currentChipBeanType;
    private final int ERROR_RETRY = 1;
    private final int ERROR_REAPPLY = 2;
    private int error = 1;
    private String errorMsg;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.compare_fail);
        ARouter.getInstance().inject((Object)this);
        this.getErrorCode();
        this.initView();
    }

    private void initView() {
        this.fail_reason = (TextView)this.findViewById(R.id.tv_fail);
        if (this.errorMsg.equals(this.context.getString(R.string.unknown_error)) && this.compareResult.getMessage().equals(this.context.getString(R.string.get_imsi_failed)) || this.compareResult.getMessage().equals(this.context.getString(R.string.net_disconnected_text))) {
            this.fail_reason.setText((CharSequence)this.compareResult.getMessage());
        } else {
            this.fail_reason.setText((CharSequence)this.errorMsg);
        }
        this.retry = (Button)this.findViewById(R.id.retry);
        if (this.error == 1) {
            this.retry.setText((CharSequence)this.getResources().getString(R.string.identify_again));
        } else {
            this.retry.setText((CharSequence)this.getResources().getString(R.string.apply_again));
        }
        this.retry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AuthenticationFailActivity.this.error == 1) {
                    AuthenticationFailActivity.this.finish();
                } else {
                    ActivityController.getInstance().finishOcrActivities();
                    OttoUtil.postFinishActivity();
                }
            }
        });
    }

    private void getErrorCode() {
        String errorCode = this.compareResult.getResult();
        this.errorMsg = OkNetError.handleErrorCodeToMsg((Context)this, errorCode);
        this.error = errorCode.matches(OkNetError.CAALG_ERROR_CODE) || this.compareResult.getMessage().equals(this.context.getString(R.string.net_disconnected_text)) ? 1 : 2;
    }

    protected boolean isOCRActivity() {
        return true;
    }

    protected int getTitleRes() {
        return R.string.identify_failed;
    }
}

