/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import ocr.bean.IDCardInfo;
import ocr.view.CanvasView;

public abstract class IDCardActivity
extends BaseActivity {
    private static final String IDENTIFY_INFO = "identify_info";
    public Bitmap faceBitmap;
    private ImageView id_front;
    private ImageView id_back;
    @Autowired(name="identify_info")
    public IDCardInfo info;
    @Autowired(name="faceImg")
    public String faceImg;

    protected int getToolbarType() {
        return super.getToolbarType();
    }

    protected int getTitleRes() {
        return R.string.identify_result_title;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_result);
        this.initView();
        this.getData();
        this.initIDFace();
        this.setData();
    }

    public void initIDFace() {
    }

    public void getData() {
        Bundle others = this.getIntent().getExtras();
        if (others != null && others.containsKey(IDENTIFY_INFO)) {
            this.info = (IDCardInfo)others.getParcelable(IDENTIFY_INFO);
        }
        if (others != null && others.containsKey("faceImg")) {
            this.faceImg = others.getString("faceImg");
        }
    }

    protected void setData() {
        if (this.info != null) {
            this.showIdentifyInfo(this.info);
        }
    }

    public void rescan() {
    }

    @Override
    public void next() {
    }

    private void initView() {
        this.id_front = (ImageView)this.findViewById(R.id.id_front);
        this.id_back = (ImageView)this.findViewById(R.id.id_back);
        Button btn_next = (Button)this.findViewById(R.id.btn_next);
        btn_next.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IDCardActivity.this.next();
            }
        });
        Button btn_again = (Button)this.findViewById(R.id.btn_again);
        btn_again.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IDCardActivity.this.rescan();
            }
        });
        this.id_front.setImageBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.id_z));
        this.id_back.setImageBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.id_f));
    }

    private void showIdentifyInfo(IDCardInfo info) {
        this.setData(info);
    }

    private void setData(IDCardInfo cardInfo) {
        if (cardInfo.getName() == null) {
            return;
        }
        String gender = "\u7537";
        if (cardInfo.getSex() == 2) {
            gender = "\u5973";
        }
        String[] info = new String[]{cardInfo.getName(), gender, cardInfo.getNation(), cardInfo.getBirthDate(), cardInfo.getAddr(), cardInfo.getIdNum()};
        this.id_front.setImageBitmap(CanvasView.getPictureBitmap(info, 2, this.faceBitmap, (Context)this));
        String[] info2 = new String[]{cardInfo.getIssueOffice(), cardInfo.getValidDate()};
        this.id_back.setImageBitmap(CanvasView.getPictureBitmap(info2, 1, null, (Context)this));
    }
}

