package com.xdja.combox.button;

import java.io.IOException;
import java.io.InputStream;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;

/**
 * 自定义按钮
 * @author hhz
 *
 */
public class XDButton extends Button {
	
	private Drawable mDrawable;						//用户通过xml传入的值，用于设置按钮的背景；
	private int type;								//按钮类型；
	private Drawable[] drawables_round;				//圆形图片组；
	private Drawable[] drawables_square;			//方形图片组；
	private StateListDrawable mStateListDrawable;	//默认背景选择器；

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
		setBackgroundByType();
	}
	
	public Drawable getmDrawable() {
		return mDrawable;
	}

	public void setmDrawable(Drawable mDrawable) {
		this.mDrawable = mDrawable;
		setBackgroundByType();
	}
	
	public void setmDrawable(int resouceId) {
		this.mDrawable = getResources().getDrawable(resouceId);
		setBackgroundByType();
	}

	public XDButton(Context context) {
		this(context, null);
	}

	public XDButton(Context context, AttributeSet attrs) {
		super(context, attrs);
		/*
		 * 获取各种state状态时的圆角图片；
		 * 数组存储顺序pressed的图片、focused的图片、normal的图片
		 */
		drawables_round = new Drawable[3];
		drawables_round[0] = get9ImageFromAssetsFile(context, "xdbutton_round_pressed.9.png");
		drawables_round[1] = get9ImageFromAssetsFile(context, "xdbutton_round.9.png");
		
		/*
		 * 获取各种state状态时的圆角图片；
		 * 数组存储顺序pressed的图片、focused的图片、normal的图片
		 */
		drawables_square = new Drawable[3];
		drawables_square[0] = get9ImageFromAssetsFile(context, "xdbutton_square_pressed.9.png");
		drawables_square[1] = get9ImageFromAssetsFile(context, "xdbutton_square.9.png");
		
		if (attrs != null) {
			/*
			 * 遍历xml中XDButton声明的所有属性
			 */
			for (int i = 0; i < attrs.getAttributeCount(); i ++) {
				if ("type".equals(attrs.getAttributeName(i))) {
					//获取XDButton的类型
					type = Integer.parseInt(attrs.getAttributeValue(i));
				} else if ("background".equals(attrs.getAttributeName(i))) {
					int resourceId = attrs.getAttributeResourceValue(i, 0);
					if (resourceId > 0) {
						mDrawable = getResources().getDrawable(resourceId);
					}
				}
			}
		}
		setBackgroundByType();
	}
	
	private void setBackgroundByType() {
		switch (type) {
		case 0:
			this.mStateListDrawable = setBg(drawables_square);
			break;
		case 1:
			this.mStateListDrawable = setBg(drawables_round);
			break;
		default:
			break;
		}
		/*
		 * 判断XDButton是否用默认的图片；
		 */
        if (mDrawable == null) {
        	this.setBackgroundDrawable(mStateListDrawable);
        } else {
        	this.setBackgroundDrawable(mDrawable);
        }
        setPadding(10, 5, 10, 5);
	}
	
	/*
	 * 获取9.png的图片
	 */
	private NinePatchDrawable get9ImageFromAssetsFile(Context context,String FileName) {
		InputStream stream;
		try {
			stream = context.getAssets().open(FileName);
		    Bitmap bitmap = BitmapFactory.decodeStream(stream);  
		    byte[] chunk = bitmap.getNinePatchChunk();
		    boolean result = NinePatch.isNinePatchChunk(chunk);
		    NinePatchDrawable patchy = null;
		    if(result) {
		      patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
		    }
		    return patchy;
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	//构建状态选择器
	private StateListDrawable setBg(Drawable[] drawables) {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(View.PRESSED_ENABLED_STATE_SET, drawables[0]);
        bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[0]);
        bg.addState(View.ENABLED_STATE_SET, drawables[1]);
        bg.addState(View.FOCUSED_STATE_SET, drawables[0]);
        bg.addState(View.EMPTY_STATE_SET, drawables[1]);
        return bg;
    }

}
