package com.xdja.combox.dialog;

import java.util.List;

import com.xdja.combox.dialog.MyAdapter.HolderView;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListView;

public class XDMultipleDialog {
	
	private AlertDialog dialog;				//弹出框
	private CharSequence mTitle;			//显示标题
	private OnCancelListener onCancelListener;
	private ListView mListView;
	private int iconId;
	private Context context;
	private List<Boolean> list;
	
	/**
	 * 获取选中的数据true为选中
	 * @return
	 */
	public List<Boolean> getList() {
		return list;
	}

	public XDMultipleDialog(Context context) {
		this.context = context;
	}
	
	/**
	 * 创建对话框
	 * @param context
	 */
	public void createDialog() {
		dialog = new AlertDialog.Builder(context).create();
		mListView = new ListView(context);
		mListView.setBackgroundColor(0xffe6e9ef);
		mListView.setCacheColorHint(Color.TRANSPARENT);
		LinearLayout.LayoutParams paramsTimeview = new LinearLayout.LayoutParams(LayoutParams.FILL_PARENT, 
				LayoutParams.FILL_PARENT);
		mListView.setLayoutParams(paramsTimeview);
		dialog.setView(mListView);
		
		if (onCancelListener != null) {
			setOnCancelListener(onCancelListener);
		}
		if (mTitle != null) {
			setTitle(mTitle);
		}
		
		if (iconId != 0) {
			setIcon(iconId);
		}
	}
	
	public ListView getListView() {
		return this.mListView;
	}
	
	public void setOnCancelListener(OnCancelListener onCancelListener) {
		if (onCancelListener != null) {
			dialog.setOnCancelListener(onCancelListener);
		} else {
			this.onCancelListener = onCancelListener;
		}
	}
	
	public void setOnItemCheckedListener(String str, List<String> list, final ItemCheckedListener listener) {
		final MyAdapter mAdapter = new MyAdapter(list, context, str);
		mListView.setAdapter(mAdapter);
		mAdapter.notifyDataSetInvalidated();
		mListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> arg0, View view, int position,
					long arg3) {
				HolderView holerView = (HolderView) view.getTag();
				holerView.checkBox.toggle();
				MyAdapter.isSelected.set(position, holerView.checkBox.isChecked());
				listener.onItemCheckListenner(MyAdapter.isSelected);
				XDMultipleDialog.this.list = MyAdapter.isSelected;
			}
		});
	}
	
	public void setButton(CharSequence text, DialogInterface.OnClickListener listener) {
		if (dialog != null) {
			dialog.setButton(text, listener);
		}
	}
	
	public void setButton2(CharSequence text, DialogInterface.OnClickListener listener) {
		if (dialog != null) {
			dialog.setButton2(text, listener);
		}
	}
	
	public void setButton3(CharSequence text, DialogInterface.OnClickListener listener) {
		if (dialog != null) {
			dialog.setButton3(text, listener);
		}
	}
	
	/**
	 * 显示dialog对话框
	 */
	public void show() {
		dialog.show();
	}
	/**
	 * 隐藏dialog对话框
	 */
	public void dismiss() {
		dialog.dismiss();
	}
	
	/**
	 * 弹出框标题；
	 * @param title
	 */
	public void setTitle(CharSequence title) {
		if (dialog != null) {
			dialog.setTitle(title);
		} else {
			mTitle = title;
		}
	}
	/**
	 * 弹出框图标；
	 * @param title
	 */
	public void setIcon(int iconId) {
		if (dialog != null) {
			dialog.setIcon(iconId);
		} else {
			this.iconId = iconId;
		}
	}
	
	public interface ItemCheckedListener {
		public void onItemCheckListenner(List<Boolean> list);
	}
	
}
