package com.xdja.combox.gridview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

import android.R.color;
import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

/**
 * 九宫格适配器
 * @author LHC
 *
 */
public class XDGridViewAdapter extends BaseAdapter {

	private Context context;
	private ArrayList<HashMap<String,Object>> date;
	private static int textColor = color.black;

	
	public XDGridViewAdapter(Context context,ArrayList<HashMap<String,Object>> date){
		this.context = context;
		this.date = date;
	}
	@Override
	public int getCount() {
		return date.size();
	}
	
	@Override
	public Object getItem(int position) {
		return date.get(position);
	}
	
	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		
		/*
		 * 刘焕超 2012-11-02 
		 * 添加代码:防止屏幕元素过多申请内存,导致内存溢出
		 * start
		 */
		if(convertView != null){
			return convertView;
		}
		/*
		 * end
		 */
		
		LayoutInflater inflater = LayoutInflater.from(context);
		viewHolder holder = new viewHolder(context);
		
		TableLayout ll = new TableLayout(context);
		TableRow tb_icon = new TableRow(context);
		TableRow tb_name = new TableRow(context);
		
		/*
		 * 屏幕自适应
		 */
		DisplayMetrics dm = new DisplayMetrics();
		((Activity) context).getWindowManager().getDefaultDisplay().getMetrics(dm);
		int width = dm.widthPixels;   // 当前屏幕宽度
		int height = dm.heightPixels; // 当前屏幕高度
		
		holder.app_icon.setAdjustViewBounds(true);
		if(width <= 320 && height <= 480){
			holder.app_icon.setMaxHeight(20);
			holder.app_icon.setMaxWidth(20);
		}else if(width <= 480 && height <= 800){
			holder.app_icon.setMaxHeight(45);
			holder.app_icon.setMaxWidth(45);
		}else if(width <= 600 && height <= 1024){
			holder.app_icon.setMaxHeight(50);
			holder.app_icon.setMaxWidth(50);
		}
		
		Set<String> set = date.get(position).keySet();
		Object[] mapKey = (Object[])set.toArray();
		holder.app_icon.setBackgroundResource((Integer)(date.get(position)).get(mapKey[0].toString()));
		holder.app_name.setText((String)(date.get(position)).get(mapKey[1].toString()));
		
		tb_icon.addView(holder.app_icon);
		
		holder.app_name.setGravity(Gravity.CENTER_HORIZONTAL);
		holder.app_name.setTextColor(textColor);
		tb_name.addView(holder.app_name);
		
		tb_icon.setGravity(Gravity.CENTER);
		tb_name.setGravity(Gravity.CENTER);
		
		ll.addView(tb_icon);
		ll.addView(tb_name);
		return ll;
	}
	
	public class viewHolder {
		private ImageView app_icon = null;
		private TextView app_name = null;
		
		public viewHolder(Context context){
			app_icon = new ImageView(context);
			app_name = new TextView(context);
		}
	}
	

	public void setTextColor(int color){
		textColor = color;
	}
	
	
}