package com.xdja.combox.keyboard;

import android.content.Context;
import android.text.Editable;
import android.text.InputType;
import android.text.Selection;
import android.text.method.PasswordTransformationMethod;
import android.view.View;
import android.view.View.OnFocusChangeListener;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageButton;

public class EditInput{

	private static EditText editText;
	private static long timeOnTouchDown = 0;
	private static long timeOnTouchUp = 0;
	/*
	 * 在InputPanel的btn_ok中响应，实现EditText值的传递与设定
	 */
	public static void setEdit(String resultString) {
		editText.setText(resultString);
		Editable etext = editText.getText(); 
		int position = etext.length(); 
		Selection.setSelection(etext, position);
		editText.setFocusable(true);
		editText.requestFocus();
	}
	/**
	 * 设置对应的输入面板，可为"number","letter","province"; 预留passwd，尝试设置密码框
	 * 
	 * @param EditText
	 *            , Context, defaultPanel, String passwd
	 */
	public static void inputSetting(final EditText Edit,
			final Context ctxContext, final String defaultPanel,
			final Boolean passwd,final String text) {
		Edit.setInputType(InputType.TYPE_NULL);
		Edit.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				InputMethodManager imm = (InputMethodManager) ctxContext
						.getSystemService(Context.INPUT_METHOD_SERVICE);
				imm.hideSoftInputFromWindow(((EditText) v).getWindowToken(), 0);
				editText = Edit;
				String inputsString = "" + Edit.getText().toString().replace(" ", "");// 传递当前值
				InputSoftKeyBoard.InitInputSoftKeyBoard(ctxContext,Edit,defaultPanel, passwd,text);
			}
		});
		if (passwd) {
			Edit.setTransformationMethod(PasswordTransformationMethod.getInstance());
		}
		Edit.setOnFocusChangeListener(new OnFocusChangeListener() {			
			public void onFocusChange(View v, boolean hasFocus) {
				// TODO Auto-generated method stub
				if(hasFocus==true)
				{
				editText = Edit;
				String inputsString = "" + Edit.getText().toString().replace(" ", "");// 传递当前值
				InputSoftKeyBoard.InitInputSoftKeyBoard(ctxContext,Edit,defaultPanel, passwd,text);
				}
			}
		});
		/*Edit.setOnTouchListener(new OnTouchListener() {
                public boolean onTouch(View arg0, MotionEvent arg1) {
                
				switch (arg1.getAction()) {
				case MotionEvent.ACTION_DOWN:
					timeOnTouchDown = System.currentTimeMillis();
					break;
				case MotionEvent.ACTION_MOVE:
					break;
				case MotionEvent.ACTION_UP:
					timeOnTouchUp = System.currentTimeMillis();
					// 如果弹起和按下的时间间隔不到1秒认为是点击事件，弹出输入面板
					if (timeOnTouchUp - timeOnTouchDown <2000) {
						editText = Edit;
						String inputsString = "" + Edit.getText().toString().replace(" ", "");// 传递当前值
						InputSoftKeyBoard.InitInputSoftKeyBoard(ctxContext,Edit,defaultPanel, passwd,text);
						return true;
					}
					break;
				default:
					break;
				}
				return false;
			}
		});*/
	}
	
	public static void inputSettingButton(final EditText Edit,
			final Context ctxContext, final String defaultPanel,
			final Boolean passwd,final String text, final ImageButton btn) {
//		Edit.setInputType(InputType.TYPE_NULL);
		Edit.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				InputMethodManager imm = (InputMethodManager) ctxContext
						.getSystemService(Context.INPUT_METHOD_SERVICE);
				imm.hideSoftInputFromWindow(((EditText) v).getWindowToken(), 0);
				editText = Edit;
				String inputsString = "" + Edit.getText().toString().replace(" ", "");// 传递当前值
				InputSoftKeyBoard.InitInputSoftKeyBoard(ctxContext,Edit,defaultPanel, passwd,text);
			}
		});
		if (passwd) {
			Edit.setTransformationMethod(PasswordTransformationMethod.getInstance());
		}
		//屏蔽掉系统弹出的菜单-upd by hjk at 20121011 11:31
//		Edit.setOnFocusChangeListener(new OnFocusChangeListener() {			
//			public void onFocusChange(View v, boolean hasFocus) {
//				// TODO Auto-generated method stub
//				if(hasFocus==true)
//				{
//				editText = Edit;
//				String inputsString = "" + Edit.getText().toString().replace(" ", "");// 传递当前值
//				InputSoftKeyBoard.InitInputSoftKeyBoard(ctxContext,Edit,defaultPanel, passwd,text);				
//				}
//			}
//		});
		
		//添加ImageButton事件监听 - add by hjk at 20121011 11:31
		if(btn!=null){
			btn.setOnClickListener(new View.OnClickListener() {
				public void onClick(View v) {
					InputMethodManager imm = (InputMethodManager) ctxContext
							.getSystemService(Context.INPUT_METHOD_SERVICE);
					imm.hideSoftInputFromWindow(((EditText) Edit).getWindowToken(), 0);
					editText = Edit;
					InputSoftKeyBoard.InitInputSoftKeyBoard(ctxContext,Edit,defaultPanel, passwd,text);
				}
			});
		}
		
	}


	public static boolean isEditTextChinese(final EditText editT) {
		String temp = editT.getText().toString();
		if (temp.length() > 0) {
			for (int i = 0; i < temp.length(); i++) {
				if (!isChinese(temp.charAt(i))) {
					return false;
				}
			}
			return true;
		} else {
			return false;
		}
	}

	public static boolean isChinese(char c) {
		Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
		if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS
				|| ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS
				|| ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A
				|| ub == Character.UnicodeBlock.GENERAL_PUNCTUATION
				|| ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION
				|| ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
			return true;
		}
		return false;
	}

}
