package com.xdja.combox.listview;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;

import com.xdja.combox.listview.XDSingleCheckEvent;
import com.xdja.combox.listview.XDSingleCheckListener;
import com.xdja.combox.utils.DensityUtil;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

/**
 * 功能说明：XDListViewAdpater 是 数据列表显示控件
 * 
 * 数据列表(XDListViewAdpater)显示控件 的构造方法有：
 * public XDListViewAdpater(Context context,List<Map<String,String>> list,int type)
 * public XDListViewAdpater(Context context,List<Map<String,String>> list,int type,int color)
 * 
 *  参数说明：
 *    第一个参数： context       为上下文句柄
 *    第二个参数：  List<Map<String,String>>  为显示数据
 *    第三个参数： type         为显示列表的样式：  0 为圆角    1 为方角
 *    第四个参数： color        为显示列表 Item 中的分割线颜色 
 * 
 * 如果使用三个参数的构造方法  显示列表的Item 分割线有默认的颜色
 * 
 * 特别说明：如果分辨率大于 320*480 需要设置 windowWidth属性
 * 
 * 
 */

public class XDListViewAdpater extends BaseAdapter {

	private Context context;
//	private List<Map<String, String>> list; // 解析数据的数据源
	private String[][] data;
	private int type = 0; // 显示ListView 类型 0：圆角 1：方角
	private int color; // 显示ListView的Item的分割线 ， 圆角的分割线暂时不需要设置，保留。
	private int key_TextSize; // 设置Map 里边的Ｋｅｙ的Ｔｅｘｔ　字体大小
	private int key_TextColor; // 设置Map 里边Key 的Text颜色
	private int value_TextSize; // 设置Map 里边的 Value 的Ｔｅｘｔ　字体大小
	private int value_TextColor; // 设置Map 里边Value的Text颜色
	private int partition_background; // 设置分割线的颜色
	private int windowWidth; // 手机屏幕上分辨率的宽度
	private int bottomMargin; // 设置下边距的距离
	private int topMargin; // 设置上边距的距离
	private int leftMargin; // 设置左边距的距离
	private int rightMargin; // 设置右边距的距离
	private Boolean checkMulti = true; // 是否允许多选
	private Boolean displayCb = false; // 是否显示CheckBox
	private Drawable[] buttonDrawable = null; // 设置CheckBox的选择器
	private Drawable[] bg_Drawable = null; // 设置圆角方角的背景选择器
	private CheckBox cb1;
	private int selectedIndex = -1;
	private int CheckBox_width = 0;
	private int CheckBox_height = 0;
	private HashMap<Integer, Boolean> checkSate = new HashMap<Integer, Boolean>(); // 存放复选按钮的状态
	private CheckBox currentCb = null; // 当前复选按钮的索引

	public Drawable[] getButtonDrawable() {
		return buttonDrawable;
	}

	public void setButtonDrawable(Drawable[] buttonDrawable) {
		this.buttonDrawable = buttonDrawable;
	}

	public Drawable[] getBg_Drawable() {
		return bg_Drawable;
	}

	public void setBg_Drawable(Drawable[] bg_Drawable) {
		this.bg_Drawable = bg_Drawable;
	}


	public int getCheckBox_width() {
		return CheckBox_width;
	}

	public void setCheckBox_width(int checkBox_width) {
		CheckBox_width = checkBox_width;
	}

	public int getCheckBox_height() {
		return CheckBox_height;
	}

	public void setCheckBox_height(int checkBox_height) {
		CheckBox_height = checkBox_height;
	}

	public Boolean getCheckMulti() {
		return checkMulti;
	}

	public void setCheckMulti(Boolean checkMulti) {
		this.checkMulti = checkMulti;
	}

	public Boolean getDisplayCb() {
		return displayCb;
	}

	public void setDisplayCb(Boolean displayCb) {
		this.displayCb = displayCb;
	}


	// 设置Key的颜色值
	public int getKey_TextColor() {
		return key_TextColor;
	}

	// 得到Key的颜色值
	public void setKey_TextColor(int key_TextColor) {
		this.key_TextColor = key_TextColor;
	}

	// 设置Value的颜色值
	public int getValue_TextColor() {
		return value_TextColor;
	}

	// 得到Value的颜色值
	public void setValue_TextColor(int value_TextColor) {
		this.value_TextColor = value_TextColor;
	}

	// 设置分割线的颜色
	public int getPartition_background() {
		return partition_background;
	}

	// 得到分割线的颜色
	public void setPartition_background(int partition_background) {
		this.partition_background = partition_background;
	}

	// 得到底部的外边距
	public int getBottomMargin() {
		return bottomMargin;
	}

	// 设置底部的外边距
	public void setBottomMargin(int bottomMargin) {
		this.bottomMargin = bottomMargin;
	}

	// 得到头部的外边距
	public int getTopMargin() {
		return topMargin;
	}

	// 设置头部的外边距
	public void setTopMargin(int topMargin) {
		this.topMargin = topMargin;
	}

	// 得到左边的外边距
	public int getLeftMargin() {
		return leftMargin;
	}

	// 设置左边的外边距
	public void setLeftMargin(int leftMargin) {
		this.leftMargin = leftMargin;
	}

	// 得到右边的外边距
	public int getRightMargin() {
		return rightMargin;
	}

	// 设置右边的外边距
	public void setRightMargin(int rightMargin) {
		this.rightMargin = rightMargin;
	}

	public int getWindowWidth() {
		return windowWidth;
	}

	// 设置手机屏幕的宽度
	public void setWindowWidth(int windowWidth) {
		this.windowWidth = windowWidth;
	}

	// 得到Text Key的 尺寸
	public int getKey_TextSize() {
		return key_TextSize;
	}

	// 设置Text Key 的 尺寸
	public void setKey_TextSize(int key_TextSize) {
		this.key_TextSize = key_TextSize;
	}

	// 得到Text Key的 尺寸
	public int getValue_TextSize() {
		return value_TextSize;
	}

	// 设置Text Key 的 尺寸
	public void setValue_TextSize(int value_TextSize) {
		this.value_TextSize = value_TextSize;
	}

	// 得到复选按钮状态的集合
	public HashMap<Integer, Boolean> getCheckBoxState() {
		return checkSate;
	}

	public XDListViewAdpater(Context context, String[][] data,
			int type) {
		this.context = context;
		this.data = data;
		this.type = type;
		for (int i = 1; i <= data.length - 1; i++) {
			checkSate.put(i - 1, false);
		}
	}

	public XDListViewAdpater(Context context, String[][] data,
			int type, int color) {
		this.context = context;
		this.data = data;
		this.type = type;
		this.color = color;
		for (int i = 1; i <= data.length - 1; i++) {
			checkSate.put(i - 1, false);
		}
	}

	public int getCount() {
		if (data != null) {
			return data.length - 1;
		}
		return 0;
	}

	@Override
	public Object getItem(int position) {
		return null;
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	private LinearLayout ly;
//	private Iterator<String> iterator;
	private TableLayout tableLayout;
	private TableRow tRow;
	private TextView tView_key;
	private View line_v;
	private TextView tView_value;
	private View line_h;

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		// final int p = position;
		CheckBox cB;
		ViewHolder holder = null;

		// if (convertView != null) {
		// if (displayCb) {
		// cB = (CheckBox) convertView.getTag();
		// cB.setId(position);
		// convertView.setTag(cB);
		// cB.setChecked(checkSate.get(position));
		// }
		// return convertView;
		// }

		// 获取Map的值
//		Map<String, String> map = list.get(position);
//		Set<String> set = map.keySet();
//		iterator = set.iterator();
		if (convertView == null) {
			holder = new ViewHolder();
			holder.tView_key = new TextView[data[0].length];
			holder.tView_value = new TextView[data[0].length];
			ly = new LinearLayout(context);
			ly.setLayoutParams(new ListView.LayoutParams(
					LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT));
			ly.setOrientation(LinearLayout.HORIZONTAL);
			ly.setDescendantFocusability(LinearLayout.FOCUS_BLOCK_DESCENDANTS);

			tableLayout = new TableLayout(context);
			tableLayout.setOrientation(TableLayout.VERTICAL);
			tableLayout.setLayoutParams(new LinearLayout.LayoutParams(
					LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT));
			tableLayout.setColumnShrinkable(2, true);
		}
		// 循环遍历 Map的值 ,填充ListView
//		for (int i = 1; i < data.length; i++) {
			int index = -1;
			int pos = 0;
			for(int j = 0; j < data[0].length; j++) {
				String key = data[0][j];
				String value = data[position + 1][j];
//				Log.e("==========key=", key + "====");
//				Log.e("==========key=", value + "====");
				
				if (convertView == null) {
					TableRow.LayoutParams tlp = new TableRow.LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
					tlp.weight = 1;
					tRow = new TableRow(context);
	
					tRow.setLayoutParams(new TableLayout.LayoutParams(
							LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT));
					tRow.setOrientation(TableRow.HORIZONTAL);
	
					// 显示Map里边的 Key
					// holder.tView_key = new TextView(context);
					TextView mTextView_key = new TextView(context);
					TextView mTextView_value = new TextView(context);
	
					mTextView_key.setPadding(10, 5, 5, 5); // 设置文本的内间距
					mTextView_key.setTextColor(key_TextColor()); // 设置文本的颜色
					mTextView_key.setMaxWidth(formatIntVlaue(setWindowWidth()
							+ "dp"));
	
					mTextView_key.setLayoutParams(new TableRow.LayoutParams(
							formatIntVlaue(setWindowWidth() + "dp"),
							LayoutParams.WRAP_CONTENT));
					mTextView_key.setSingleLine(false);
	
					if (getKey_TextSize() != 0) { // 设置字体大小，如果设置的有值则使用设置的值，否则的话
													// 用系统默认值
						mTextView_key
								.setTextSize(formatFloatVlaue(getKey_TextSize()
										+ "sp"));
	
					}
	
					// if (type == 0) { 如果显示类型为圆角， 设置圆角的背景色，现在这个功能暂时保留
					// tView_key.setBackgroundColor(0xFFedf3f8);
					// }
					mTextView_key.setText(key);
					tRow.addView(mTextView_key);
					holder.tView_key[pos] = mTextView_key;
					// holder.tView_key.setPadding(10, 5, 5, 5); // 设置文本的内间距
					// holder.tView_key.setTextColor(key_TextColor()); // 设置文本的颜色
					// holder.tView_key.setMaxWidth(formatIntVlaue(setWindowWidth()
					// + "dp"));
					//
					// holder.tView_key.setLayoutParams(new TableRow.LayoutParams(
					// formatIntVlaue(setWindowWidth() + "dp"),
					// LayoutParams.WRAP_CONTENT));
					// holder.tView_key.setSingleLine(false);
					//
					// if (getKey_TextSize() != 0) { // 设置字体大小，如果设置的有值则使用设置的值，否则的话
					// 用系统默认值
					// holder.tView_key
					// .setTextSize(formatFloatVlaue(getKey_TextSize() + "sp"));
					//
					// }
					//
					// // if (type == 0) { 如果显示类型为圆角， 设置圆角的背景色，现在这个功能暂时保留
					// // tView_key.setBackgroundColor(0xFFedf3f8);
					// // }
					// holder.tView_key.setText(key);
					// tRow.addView(holder.tView_key);
	
					// 显示Key 和 Value的分割线
					line_v = new View(context);
					line_v.setBackgroundColor(partition_background()); // 设置分割线的颜色
					line_v.setLayoutParams(new TableRow.LayoutParams(1,
							LayoutParams.FILL_PARENT));
					tRow.addView(line_v);
	
					// 显示Map里边的Value
					mTextView_value.setTextColor(value_TextColor());
					mTextView_value.setSingleLine(false);
					
					mTextView_value.setLayoutParams(tlp);
					mTextView_value.setText(value);
					mTextView_value.setPadding(10, 5, 0, 5);
					tRow.addView(mTextView_value);
					holder.tView_value[pos] = mTextView_value;
					// holder.tView_value = new TextView(context);
					// holder.tView_value.setTextColor(value_TextColor());
					// holder.tView_value.setSingleLine(false);
					// holder.tView_value.setLayoutParams(new TableRow.LayoutParams(
					// LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT));
					// holder.tView_value.setText(value);
					// holder.tView_value.setPadding(10, 5, 0, 5);
					// tRow.addView(holder.tView_value);
	
					if (index == -1 && displayCb) { // 显示CheckBox 复选按钮 ，只让CheckBox
													// 显示在第一列
						index = 0;
						cB = new CheckBox(context);
						cB.setLayoutParams(new TableRow.LayoutParams(
								CheckBox_width == 0 ? DensityUtil
										.dp2px(context, 45) : CheckBox_width,
								CheckBox_height == 0 ? DensityUtil.dp2px(context,
										45) : CheckBox_height));
//						cB.setButtonDrawable(new checkBoxSelector(context)
//								.setBg(buttonDrawable == null ? setCheckBoxDrawables()
//										: buttonDrawable));
						tRow.addView(cB);
	
						cB.setOnClickListener(new View.OnClickListener() {
	
							public void onClick(View v) {
								cb1 = (CheckBox) v;
								final int p = cb1.getId();
								if (checkMulti) { // 多选
									if (cb1.isChecked()) {
										checkSate.put(p, true);
									} else {
										checkSate.put(p, false);
									}
								} else { // 单选
									if (cb1.isChecked()) { // 选中
										if (currentCb != null) {
											currentCb.setChecked(false);
										}
										cb1.setChecked(true);
	
										for (int i = 0; i < checkSate.size(); i++) {
											if (i != p) {
												checkSate.put(i, false);
											}
										}
	
										checkSate.put(p, true);// 设置当前CheckBox被选中
										// checkSate.put(p1, false);
										// //设置之前CheckBox被取消
										currentCb = cb1;
										selectedIndex = p;
										XDSingleCheckEvent event = new XDSingleCheckEvent(
												context);
										event.setPosition(p);
										activateEvent(event);
									} else// 取消
									{
										selectedIndex = -1;
										checkSate.put(p, false);
										currentCb = null;
									}
								}
							}
						});
						holder.mBox = cB;
						cB.setId(position);
						cB.setChecked(checkSate.get(position));
					}
					tableLayout.addView(tRow);
					if (getValue_TextSize() != 0) { // 设置字体大小，如果设置的有值则使用设置的值，否则的话
													// 用系统默认值
						mTextView_value
								.setTextSize(formatFloatVlaue(getValue_TextSize()
										+ "sp"));
					}
	
					// 显示ListView Item 的分割线
					if (j < data[0].length - 1) {
						line_h = new View(context);
						line_h.setBackgroundColor(partition_background()); // 设置分割线的颜色
						line_h.setLayoutParams(new TableLayout.LayoutParams(
								new LayoutParams(LayoutParams.FILL_PARENT, 1)));
						tableLayout.addView(line_h);
					} else {
						if (position != getCount() - 1) {
							if (type == 0) {
								View line_end = new View(context);
								if (color != 0) {
									line_end.setBackgroundColor(color);
								} else {
									line_end.setBackgroundColor(0xFFa6c8e4); // 方角Item
																				// 分割线颜色
								}
								line_end.setLayoutParams(new TableLayout.LayoutParams(
										new LayoutParams(LayoutParams.FILL_PARENT,
												5)));
								tableLayout.addView(line_end);
							}
						}
					}
				} else {
					holder = (ViewHolder) convertView.getTag();
					holder.tView_key[pos].setText(key);
					holder.tView_value[pos].setText(value);
					if (displayCb) {
						holder.mBox.setId(position);
						holder.mBox.setChecked(checkSate.get(position));
					}
					convertView.setTag(holder);
				}
				pos ++;
			}
//		}
		if (convertView == null) {
			ly.addView(tableLayout);
			if (type == 0) {
				ly.setBackgroundDrawable(new Selector(context)
						.setBg(bg_Drawable == null ? setSquareDrawables()
								: bg_Drawable));
			} else {
				ly.setBackgroundDrawable(new Selector(context)
						.setBg(bg_Drawable == null ? setRoundDrawables()
								: bg_Drawable));
				// if (color != 0) {
				// ly_w.setBackgroundColor(color); 功能暂时保留
				// } else {
				// ly_w.setBackgroundColor(0xff2f4486); // /圆角 的颜色
				// }
			}
			// ly.setTag(position, holder);
			ly.setTag(holder);
			convertView = ly;
		}
		return convertView;
	}

	public static class ViewHolder {
		public TextView[] tView_key;
		public TextView[] tView_value;
		public CheckBox mBox;
	}

	/**
	 * 返回当前选中的位置 (只对单选有效)
	 * 
	 * @return
	 */
	public int getSelectedIndex() {
		return this.selectedIndex;
	}

	// 构建状态选择器

	private class Selector extends View {

		public Selector(Context context) {
			super(context);
		}

		public StateListDrawable setBg(Drawable[] drawables) {
			StateListDrawable bg = new StateListDrawable();
			bg.addState(View.SELECTED_STATE_SET, drawables[1]); // 获取焦点的时候
			bg.addState(new int[] { android.R.attr.state_pressed,
					android.R.attr.state_enabled }, drawables[2]); // 点击的时候
			bg.addState(new int[] { android.R.attr.state_window_focused },
					drawables[0]); // 窗口获取焦点的时候
			bg.addState(new int[] {}, drawables[0]);
			return bg;
		}
	}

	// 构建CheckBox状态选择器

	private class checkBoxSelector extends View {

		public checkBoxSelector(Context context) {
			super(context);
		}

		public StateListDrawable setBg(Drawable[] drawables) {
			StateListDrawable bg = new StateListDrawable();
			bg.addState(new int[] { android.R.attr.state_checked },
					drawables[0]); // 点击的时候
			// bg.addState(new int[] {android.R.attr.state_checkable},
			// drawables[1]);
			bg.addState(new int[] { android.R.attr.state_enabled },
					drawables[1]);
			return bg;
		}
	}

	// 得到assets目录的 9.png 资源
	private Drawable getDrawable(String str) {
		InputStream is = this.getClass().getClassLoader()
				.getResourceAsStream("assets/" + str);
		Drawable dra = Drawable.createFromStream(is, "9.png");
		return dra;
	}

	// 设置一个圆角的 事件触发效果
	private Drawable[] setRoundDrawables() {
		Drawable[] dra = { getDrawable("XDListViewAdpater_r_bg1.9.png"),
				getDrawable("XDListViewAdpater_r_bg2.9.png"),
				getDrawable("XDListViewAdpater_r_bg3.9.png"), };
		return dra;
	}

	// 设置一个CheckBox的事件触发效果

	private Drawable[] setCheckBoxDrawables() {
		Drawable[] dra = {
				getDrawable("XDListViewAdpater_checkbox_select_press.png"),
				getDrawable("XDListViewAdpater_checkbox_unselect_press.png"), };
		return dra;
	}

	// 设置一个方角的 事件触发效果
	private Drawable[] setSquareDrawables() {
		Drawable[] dra = { getDrawable("XDListViewAdpater_f_bg1.9.png"),
				getDrawable("XDListViewAdpater_f_bg2.9.png"),
				getDrawable("XDListViewAdpater_f_bg3.9.png"), };
		return dra;
	}

	// 设置手机分辨率 Width的值，从而控制 TableRow中 kay 的比例
	private int setWindowWidth() {
		if (windowWidth != 0) {
			return windowWidth;
		} else {
			// 默认用的 320*480的分辨率
			return 75;
		}
	}

	// 设置Key 的颜色，判断是否有值，没有的话用默认的颜色值
	private int key_TextColor() {
		if (key_TextColor != 0) {
			return key_TextColor;
		} else {
			return 0xff373434;
		}
	}

	// 设置Value的颜色，判断是否有值，没有的话用默认的颜色值
	private int value_TextColor() {
		if (value_TextColor != 0) {
			return value_TextColor;
		} else {
			return 0xff000000;
		}
	}

	// 设置分割线的颜色，判断是否有值，没有的话用默认的颜色值
	private int partition_background() {
		if (partition_background != 0) {
			return partition_background;
		} else {
			return 0xFFa2a2a2;
		}
	}

	/**
	 * 格式化xml布局文件中传入的设置的值
	 * 
	 * @param val
	 *            传入的字符串
	 * @return 格式化得到的int 类型 单位 为 dp 的值
	 */

	private int formatIntVlaue(String val) {
		int value = -1;
		if (val.endsWith("dp")) {
			val = val.substring(0, val.length() - 2);
			try {
				value = Integer.parseInt(val);
				value = DensityUtil.dp2px(context, (float) value);
//				Log.v("pxValue end With dp", value + "");
			} catch (NumberFormatException ex) {
//				Log.e("NumberFormatException", val + "无法转换为整数");
			}
		} else {
			if (val.endsWith("px")) {
				val = val.substring(0, val.length() - 2);
			}
			try {
				value = Integer.parseInt(val);
//				Log.v("pxValue", value + "");
			} catch (NumberFormatException ex) {
//				Log.e("NumberFormatException", val + "无法转换为整数");
//				Log.v("pxValue", value + "");
			}
		}
		return value;
	}

	/**
	 * 格式化xml布局文件中传入的字体大小设置的值
	 * 
	 * @param val
	 *            传入的字符串
	 * @return 格式化得到的float类型值
	 */
	private float formatFloatVlaue(String val) {
		boolean isFormat = true;
		float value = (float) 14.0;
		if (val.endsWith("sp")) {
			val = val.substring(0, val.length() - 2);
		}
		try {
			value = Float.parseFloat(val);
		} catch (NumberFormatException e) {
			isFormat = false;
		}
		if (!isFormat) {
			try {
				value = (float) Integer.parseInt(val);
			} catch (NumberFormatException ex) {
//				Log.e("NumberFormatException", val + "²»ÄÜ±»×ª»¯ÎªfloatÀàÐÍ");
			}
		}
		return value;
	}

	/******************************** 新增单击事件监听暴露 **************************/
	/****************** 开始 **************************/
	private Vector vectorListeners1 = new Vector();

	/* 注册监听者 */
	public synchronized void addXDSingleCheckListener(
			XDSingleCheckListener lisenter) {
		vectorListeners1.addElement(lisenter);
	}

	/* 注销监听者 */
	public synchronized void removeXDSingleCheckListener(
			XDSingleCheckListener lisenter) {
		vectorListeners1.removeElement(lisenter);
	}

	/* 触发事件 */
	private void activateEvent(XDSingleCheckEvent event) {
		Vector tempVector = null;
		XDSingleCheckEvent myEvent = event;
		synchronized (context) {
			tempVector = (Vector) vectorListeners1.clone();
			for (int i = 0; i < tempVector.size(); i++) {
				XDSingleCheckListener lisenter = (XDSingleCheckListener) tempVector
						.elementAt(i);
				lisenter.OnEventActivied(myEvent);// 触发事件
			}
		}
	}
	/****************************** 结束 ****************************/

}
