package com.xdja.combox.menu;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import android.app.AlertDialog;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.Resources.NotFoundException;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.Display;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.LinearLayout.LayoutParams;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
/**
 * 菜单控件（可显示气泡）
 * @author fjd
 *
 */
public class XDMenuDialog extends AlertDialog {
	protected XDMenuDialog(Context context, boolean cancelable,
			OnCancelListener cancelListener) {
		super(context, cancelable, cancelListener);
		this.nContext = context;
		mGridView = new GridView(context);
	}
	/*
	 * 构造函数
	 */
	public XDMenuDialog(Context context){
		this(context,true,null);
	}

	private GridView mGridView = null;
	private Context nContext = null;
	/*
	 * 控件id号
	 */
	private int item_img = 1;
	private int item_textview = 2;
	private int item_text = 3;
	private int item_menu = 4;
	
	private List<String> text = null;//菜单文本集合
	private List<Bitmap> icon = null;//菜单图片资源id集合
	private List<String> number = null;//菜单上气泡显示数字字符集合
	private LinearLayout llayout = null;
	private RelativeLayout rlayout = null;
	private ImageView mImageView = null;
	private TextView mTextView = null;
	private TextView mText = null;
	WindowManager.LayoutParams lp; 
	public void showMenu(){
		 
		 setView(mGridView);
	        lp = this.getWindow().getAttributes();
	        WindowManager  wm = (WindowManager)nContext.getSystemService(Context.WINDOW_SERVICE);
			Display display = wm.getDefaultDisplay();
			/*
			 * 动态控制窗体的大小
			 * */
			if (display.getHeight() > display.getWidth()) {  
				//lp.width = (int) (display.getWidth() * 0.65);
				lp.width = display.getWidth();
				Log.i("lpwith", lp.width+"---"+display.getHeight());
			} else {
				lp.width = (int) (display.getWidth() * 0.5);
				Log.i("lpwith", lp.width+"");
			}
			lp.gravity = Gravity.LEFT | Gravity.BOTTOM;
			/*
			 * 以屏幕左上角为原点，设置x、y初始值
			 * */
			lp.x = 0;
			lp.y = 0;
			getWindow().setAttributes(lp);
			this.show();
	}
	/**
	 * 根据传入的数据源初始化菜单
	 * @param context 窗体句柄
	 * @param text	菜单显示文本集合
	 * @param resList 菜单显示图片id号集合
	 * @param number 菜单显示气泡上显示数字集合
	 */
	public void initialMenuData(Context context,List<String> text,List<Integer> resList,List<String> number){
		setMenuText(text);
		setMenuIcon(resList);
		setMenuNum(number);
		initialMenu(context);
	}
	/**
	 * 初始化菜单控件
	 * @param context 
	 */
	public void initialMenu(Context context) {
		/*
		 * 判断数据源合法性，大小必须相同
		 */
		if (text.size() == icon.size() && icon.size() == number.size()&&text.size()!=0) {
			GirdViewAdapter madapter = new GirdViewAdapter(nContext, text,
					icon, number);
			mGridView.setAdapter(madapter);
			/*
			 * 根据显示最大列数对GridView进行设置
			 */
			if(this.maxColumnCount>=text.size()){
				mGridView.setNumColumns(text.size());
			}else{
				mGridView.setNumColumns(this.maxColumnCount);
			}
			madapter.notifyDataSetChanged();
		} else {
			Toast.makeText(context, "数据源有错误，请检查", Toast.LENGTH_SHORT).show();
			return;
		}
	}

	
	// 每行显示的最大列数
	private int maxColumnCount = 4;

	/**
	 * 设置菜单显示文本的集合
	 * 
	 * @param text
	 *            文本集合
	 */
	public void setMenuText(List<String> text) {
		this.text = text;
	}

	/**
	 * 设置菜单显示图标的集合
	 * 
	 * @param resList
	 *            图标资源号集合
	 */
	public void setMenuIcon(List<Integer> resList) {
		if (resList.size() > 0) {
			icon = new ArrayList<Bitmap>();
			Bitmap bm = null;
			for (int i = 0; i < resList.size(); i++) {
				bm = getResourceBitmap(resList.get(i));
				if(bm != null){
					icon.add(bm);
				}
			}
		}
	}
	/**
	 *根据资源id号 从资源中得到图片
	 * @param id
	 * @return
	 */
	public Bitmap getResourceBitmap(int id) {
		Bitmap bmp = null;
		try{
			Resources res = nContext.getResources();
			bmp = BitmapFactory.decodeResource(res, id);
		}catch(NotFoundException e){
			Log.e("SourceNotFound", "id为"+id+"的资源未找到");
		}
		return bmp;
	}

	/**
	 * 菜单上的气泡内数字的集合
	 * 
	 * @param number
	 *            数字的字符串集合
	 */
	public void setMenuNum(List<String> number) {
		this.number = number;
	}

	/**
	 * 获取每行显示的最大列数
	 * 
	 * @return 当前设置的最大列数
	 */
	public int getMaxColumnCount() {
		return maxColumnCount;
	}

	/**
	 * 设置每行显示的最大列数
	 * 
	 * @param maxColumnCount
	 *            将要设置的最大列数
	 */
	public void setMaxColumnCount(int maxColumnCount) {
		this.maxColumnCount = maxColumnCount;
	}
	public void setOnItemClickListener(OnItemClickListener l){
		this.mGridView.setOnItemClickListener(l);
	}
	/**
	 * 适配器类（内部类）
	 * 
	 * @author fjd
	 * 
	 */
	public class GirdViewAdapter extends BaseAdapter {
		private Context mContext;
		private List<String> text = null;
		private List<Bitmap> icon = null;
		private List<String> numberstr = null;

		/**
		 * GridViewAdapter的构造函数
		 * 
		 * @param context
		 *            数据上下文
		 * @param _text
		 *            菜单显示的文本集合
		 * @param _icon
		 *            菜单显示的图标集合
		 * @param _number
		 *            菜单显示的气泡内容集合
		 */
		public GirdViewAdapter(Context context, List<String> _text,
				List<Bitmap> _icon, List<String> _number) {
			if (_text.size() == _icon.size() && _icon.size() == _number.size()) {
			mContext = context;
			text = _text;
			icon = _icon;
			numberstr = _number;
			}else {
				Toast.makeText(context, "数据源有错误，请检查", Toast.LENGTH_SHORT).show();
				return;
			}
		}

		public int getCount() {
			return text.size();
		}

		public Object getItem(int position) {
			return position;
		}

		public long getItemId(int position) {
			return position;
		}

		@Override
		public View getView(int position, View convertView, ViewGroup parent) {
			LinearLayout lly = initialMenuItem(mContext);
			mImageView.setImageBitmap(icon.get(position));
			/*
			 * 如果气泡上显示的数字为0，那么这个气泡不显示
			 */
			if(numberstr.get(position).equals("0")){
				mTextView.setVisibility(View.GONE);
			}else{
			mTextView.setText(numberstr.get(position));
			}
			mText.setText(text.get(position).toString());
			return lly;
		}
	}

	/**
	 * 初始化菜单项显示模板
	 * @param context 窗体句柄
	 * @return
	 */
	private LinearLayout initialMenuItem(Context context) {
		/*
		 * 构建模板布局
		 */
		llayout = new LinearLayout(context);
		llayout.setOrientation(1);
		llayout.setPadding(10, 10, 10, 10);
		llayout.setGravity(Gravity.CENTER_HORIZONTAL);
		rlayout = new RelativeLayout(context);
		rlayout.setLayoutParams(new LinearLayout.LayoutParams(LayoutParams.FILL_PARENT,
				LayoutParams.WRAP_CONTENT));
		rlayout.setGravity(Gravity.CENTER);
		rlayout.setId(item_menu);
		/*
		 * 显示图片
		 */
		mImageView = new ImageView(context);
		mImageView.setAdjustViewBounds(true);
		LayoutParams imglayoutParams = new LayoutParams(
				LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
		mImageView.setId(item_img);
		rlayout.addView(mImageView, imglayoutParams);
		/*
		 * 气泡
		 */
		mTextView = new TextView(context);
		mTextView.setBackgroundDrawable(getImageFromAssetsFile(context,"assets/xdmenudialog_redround.png"));
		mTextView.setGravity(Gravity.CENTER);
		RelativeLayout.LayoutParams mtextviewlayoutParams = new RelativeLayout.LayoutParams(
				20, 20);
		mtextviewlayoutParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
		mtextviewlayoutParams.addRule(RelativeLayout.ALIGN_RIGHT, item_img);
		mTextView.setId(item_textview);
		rlayout.addView(mTextView, mtextviewlayoutParams);
		llayout.addView(rlayout);
		ViewGroup.MarginLayoutParams mp = (ViewGroup.MarginLayoutParams)mTextView.getLayoutParams();
		mp.rightMargin=-10;
		/*
		 * 显示文本
		 */
		mText = new TextView(context);
		mText.setGravity(Gravity.CENTER);
		LayoutParams mtextlayoutParams = new LayoutParams(
				LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
		mText.setId(item_text);
		llayout.addView(mText, mtextlayoutParams);
		return llayout;
	}
	/**
	 * 获取assets文件夹中得图片
	 * 
	 * @param context
	 *            窗体句柄
	 * @param fileName
	 *            文件路径名
	 * @return 获取到得drawable
	 */
	private static Drawable getImageFromAssetsFile(Context context,
			String fileName) {
		InputStream stream;
		Drawable drawable = null;
		try {
			stream = context.getClass().getClassLoader()
					.getResourceAsStream(fileName);
			drawable = Drawable.createFromStream(stream, "");
		} catch (Exception e) {

		}
		return drawable;
	}
}
