package com.xdja.combox.photo;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Environment;
import android.preference.PreferenceManager.OnActivityResultListener;
import android.provider.MediaStore;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ImageView.ScaleType;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.combox.utils.DensityUtil;

/**
 * 照片显示控件
 * 
 * @author hjk
 */
public class XDPhotoBox extends RelativeLayout implements
		OnActivityResultListener {

	private ImageView PhotoButton; // 拍照按钮

	private ImageView DelClickButton; // 删除按钮

	private ImageView PreClickButton; // 前翻按钮

	private ImageView NextClickButton; // 后翻按钮

	private ImageView photo; // 照片

	private Bitmap curPhoto; // 当前选择的照片

	private int curPhotoNum = -1; // 照片序号

	private TextView textView; // 已拍照片提示

	private Context mContext; // 上下文环境

	private Vector<Bitmap> photoBitMaps = new Vector<Bitmap>(); // 照片的集合

	private LinearLayout rll; // 封装照片的线性布局

	private LinearLayout tblll; // 封装按钮的最外层线性布局

	private TableLayout tbl; // 直接封装按钮的内层表格布局

	private Boolean isTakephotoShow = true; // 是否显示照相按钮

	private Boolean isDeletShow = true; // 是否显示删除照片按钮

	private int reqCode = -1; // 拍照请求代码-按时间随机生成

	private int tempId = -1; // 用于生成和存放照片显示控件的id号

	private int imageWidth = 100; // 照片宽度
	private int imageHeight = 100; // 照片高度

	private int btnId = -1; // 按钮组所在的布局ID
	private String sdcardPath = "";
	private int buttonWidth = -2; // 下部按钮的宽度 默认自适应
	private int buttonHeight = -2; // 下部按钮的高度 默认自适应
	private int photoWidth = 480; // 实际照片分辨率宽度
	private int photoHeight = 320; // 实际照片分辨率高度
	private int maxNumber = 5; // 最多拍照数
	
	
	public View currentView = null;

	// 属性字典集合
	private HashMap<String, Integer> attrsMap = null;

	public XDPhotoBox(Context context) {
		super(context);
		// TODO Auto-generated constructor stub
		mContext = context;
		init();
		InitPhoto();
	}

	public XDPhotoBox(Context context, AttributeSet attrs) {
		super(context, attrs);
		mContext = context;
		initialAttrMap(context);
		analysisAttrs(attrsMap, attrs);
		init();
		InitPhoto();
	}

	/**
	 * 初始化属性字典
	 * 
	 * @param context
	 */
	private void initialAttrMap(Context context) {
		// 初始化属性字典
		attrsMap = new HashMap<String, Integer>();
		attrsMap.put("image_width", 0); // 照片宽度
		attrsMap.put("image_height", 1); // 照片高度
		attrsMap.put("box_width", 2); // 整体控件显示宽度
		attrsMap.put("box_height", 3); // 整体控件显示高度
		attrsMap.put("button_width", 4); // 下部按钮显示宽度
		attrsMap.put("button_height", 5); // 下部按钮显示高度
	}

	/**
	 * 格式化xml布局文件中传入的宽度大小值为整数
	 * 
	 * @param val
	 *            传入的字符串
	 * @return 得到的整数结果
	 */
	private int formatIntVlaue(String val) {
		int value = -1;
		if (val.endsWith("dp")) {
			val = val.substring(0, val.length() - 2);
			try {
				value = Integer.parseInt(val);
				value = DensityUtil.dp2px(mContext, (float) value);
				Log.v("pxValue", value + "");
			} catch (NumberFormatException ex) {
				Log.e("NumberFormatException", val + "无法转换为整数");
			}
		} else {
			if (val.endsWith("px")) {
				val = val.substring(0, val.length() - 2);
			}
			try {
				value = Integer.parseInt(val);
				Log.v("pxValue", value + "");
			} catch (NumberFormatException ex) {
				Log.e("NumberFormatException", val + "无法转换为整数");
				Log.v("pxValue", value + "");
			}
		}
		return value;
	}

	/**
	 * 解析xml布局传递的属性参数
	 * 
	 * @param attrsMap
	 *            属性字典
	 * @param attrs
	 *            属性集合
	 */
	private void analysisAttrs(HashMap<String, Integer> attrsMap,
			AttributeSet attrs) {
		int attrId = -1;
		if (attrs != null) {
			int attrsCount = attrs.getAttributeCount();
			// 计算手机分辨率
			DisplayMetrics dm = new DisplayMetrics();
			((Activity) mContext).getWindowManager().getDefaultDisplay()
					.getMetrics(dm);
			int width = dm.widthPixels; // 当前屏幕宽度
			int height = dm.heightPixels; // 当前屏幕高度
			for (int i = 0; i < attrsCount; i++) {
				if (attrsMap.containsKey(attrs.getAttributeName(i))) {
					attrId = attrsMap.get(attrs.getAttributeName(i));
					switch (attrId) {
					case 0:
						imageWidth = formatIntVlaue(attrs.getAttributeValue(i));
						break;
					case 1:
						imageHeight = formatIntVlaue(attrs.getAttributeValue(i));
						break;
					case 2:
						int w = formatIntVlaue(attrs.getAttributeValue(i));
						int h = (int) (w * 1.25f);
						if (h < height) {
							setSize(w, h);
						} else {
							setSize(w, -2);
						}
						break;
					case 3:
						int h1 = formatIntVlaue(attrs.getAttributeValue(i));
						int w1 = (int) (h1 * 0.8f);
						if (w1 < width) {
							setSize(w1, h1);
						} else {
							setSize(-1, h1);
						}
						break;
					case 4:
						int w4 = formatIntVlaue(attrs.getAttributeValue(i));
						buttonWidth = w4;

						break;
					case 5:
						int h4 = formatIntVlaue(attrs.getAttributeValue(i));
						buttonHeight = h4;
						break;
					default:
						break;
					}
				}
			}
		}
	}

	public RelativeLayout create() {
		return this;
	}

	/** 初始化对象 */
	private void init() {

		sdcardPath = Environment.getExternalStorageDirectory() + "/test.jpg";
		Log.i("path", sdcardPath);

		// 生成存放照片的线性布局
		rll = new LinearLayout(mContext);

		// 设置照片显示控件的外层LinearLayout样式
		LinearLayout.LayoutParams llp = new LinearLayout.LayoutParams(-1, -2);
		rll.setLayoutParams(llp);

		// 根据时间字符串格式生成一个整型int数,用于充当照片布局LinearLayout的ID,供设置相对布局使用
		tempId = Integer.parseInt((new SimpleDateFormat("HHmmss"))
				.format(new Date()));
		btnId = Integer.parseInt((new SimpleDateFormat("mmss"))
				.format(new Date()));
		rll.setId(tempId);

		// 生成存放按钮组的布局
		tblll = new LinearLayout(mContext);
		textView = new TextView(mContext);
		textView.setText("0 / 0");
		textView.setGravity(Gravity.CENTER_HORIZONTAL);
		tblll.setId(btnId);

		tbl = new TableLayout(mContext);

		// 生成显示照片的画板
		photo = new ImageView(mContext);
		Drawable defaultBgImage = getDrawableFromAssets(mContext,
				"xdphotobox_defaultimg.png"); // 默认背景图
		photo.setBackgroundDrawable(defaultBgImage);
		photo.setMinimumHeight(5);
		photo.setMinimumWidth(5);
		photo.setScaleType(ScaleType.FIT_XY);
		android.widget.LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
				imageWidth, imageHeight);
		photo.setLayoutParams(params);

		// 添加画板到线性布局容器
		rll.addView(photo, imageWidth, imageHeight);
		rll.setGravity(Gravity.CENTER_HORIZONTAL);

		// 添加照片布局到当前相对布局中
		this.addView(rll);

		// 初始化按钮控件
		PhotoButton = new ImageView(mContext);
		DelClickButton = new ImageView(mContext);
		PreClickButton = new ImageView(mContext);
		NextClickButton = new ImageView(mContext);
		
		//设置按钮背景setBackgroundWithStateListDrawable(drawables_round)
//		Drawable[] drawables_round=null; 
//		drawables_round = new Drawable[2];
//		drawables_round[0] = getImageFromAssetsFile1(mContext,
//				"assets/xdedittextbutton_input_normal.9.png");
//		drawables_round[1] = getImageFromAssetsFile1(mContext,
//				"assets/xdedittextbutton_input_fouce.9.png");
//
//		PhotoButton.setBackgroundDrawable(setBackgroundWithStateListDrawable(drawables_round));
//		DelClickButton.setBackgroundDrawable(setBackgroundWithStateListDrawable(drawables_round));
//		PreClickButton.setBackgroundDrawable(setBackgroundWithStateListDrawable(drawables_round));
//		NextClickButton.setBackgroundDrawable(setBackgroundWithStateListDrawable(drawables_round));
		
		// 设置左右间距
		setPaddingForButton(5);

		// 按钮触摸事件监听,按下和松开时的动作,对按钮亮度和灰度进行修改
		OnTouchListener otl = new OnTouchListener() {

			@Override
			public boolean onTouch(View v, MotionEvent event) {
				// TODO Auto-generated method stub
				currentView = v;
				int action = event.getAction(); // 动作
				if (action == MotionEvent.ACTION_DOWN) {
					ColorMatrix cm = new ColorMatrix();
					// cm.setSaturation(0.0f); //使ImageView变灰
					cm.setScale(0.6f, 0.6f, 0.6f, 0.8f);
					ColorMatrixColorFilter cf = new ColorMatrixColorFilter(cm);
					((ImageView) v).setColorFilter(cf);
				}
//				else{
//					((ImageView) v).clearColorFilter();
//				}
				if (action == MotionEvent.ACTION_UP || action == MotionEvent.ACTION_OUTSIDE) {
					((ImageView) v).clearColorFilter();
				}
				return false;
			}
			
		};
		/*OnLongClickListener olcl = new OnLongClickListener() {
			
			@Override
			public boolean onLongClick(View v) {
				// TODO Auto-generated method stub
				ColorMatrix cm = new ColorMatrix();
				// cm.setSaturation(0.0f); //使ImageView变灰
				cm.setScale(0.6f, 0.6f, 0.6f, 0.8f);
				ColorMatrixColorFilter cf = new ColorMatrixColorFilter(cm);
				((ImageView) v).setColorFilter(cf);
				return false;
			}
		};*/
		PhotoButton.setOnTouchListener(otl);
		DelClickButton.setOnTouchListener(otl);
		PreClickButton.setOnTouchListener(otl);
		NextClickButton.setOnTouchListener(otl);
		
//		DelClickButton.setOnLongClickListener(olcl);

		// 设置默认的按钮图片
		// Drawable d1 = getDrawableFromAssets(mContext,
		// "xdphotobox_take.9.png"); // 拍照按钮
		// Drawable d2 = getDrawableFromAssets(mContext,
		// "xdphotobox_pre.9.png"); // 前翻按钮
		// Drawable d3 = getDrawableFromAssets(mContext,
		// "xdphotobox_next.9.png"); // 下翻按钮
		// Drawable d4 = getDrawableFromAssets(mContext,
		// "xdphotobox_del.9.png"); // 删除按钮
		Drawable d1 = getImageFromAssetsFile(mContext,
				"assets/xdphotobox_take.9.png"); // 拍照按钮
		Drawable d2 = getImageFromAssetsFile(mContext,
				"assets/xdphotobox_pre.9.png"); // 前翻按钮
		Drawable d3 = getImageFromAssetsFile(mContext,
				"assets/xdphotobox_next.9.png"); // 下翻按钮
		Drawable d4 = getImageFromAssetsFile(mContext,
				"assets/xdphotobox_del.9.png"); // 删除按钮

		//设置按钮图片
		setImageButton(d1, d2, d3, d4);
		

		PreClickButton.setEnabled(false);
		setButtonGray(PreClickButton);

		NextClickButton.setEnabled(false);
		setButtonGray(NextClickButton);

		if (!isTakephotoShow) {
			PhotoButton.setVisibility(View.GONE);
		}

		if (!isDeletShow) {
			DelClickButton.setVisibility(View.GONE);
		}

		// 设置添加按钮的TableRow的样式
		ViewGroup.LayoutParams tbr_params = new ViewGroup.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);

		TableRow tbr = new TableRow(mContext);
		tbr.setLayoutParams(tbr_params);
		tbr.addView(PhotoButton, buttonWidth, buttonHeight);
		tbr.addView(PreClickButton, buttonWidth, buttonHeight);
		tbr.addView(NextClickButton, buttonWidth, buttonHeight);
		tbr.addView(DelClickButton, buttonWidth, buttonHeight);

		// 设置TableRow的排列格式
		tbr.setGravity(Gravity.CENTER_HORIZONTAL);
		tbl.addView(tbr);

		// 设置放置按钮的TableLayout的宽高和居中样式
		TableLayout.LayoutParams tblp = new TableLayout.LayoutParams(-1, -2);
		tbl.setLayoutParams(tblp);
		tbl.setGravity(Gravity.CENTER_HORIZONTAL);

		// 设置按钮最外层LinearLayout添加到本RelativeLayout时所要应用的样式
		RelativeLayout.LayoutParams mtextlayoutParams = new RelativeLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
		mtextlayoutParams.addRule(RelativeLayout.BELOW, tempId);

		// 设置按钮最外层LinearLayout的宽高
		LinearLayout.LayoutParams tblllp = new LinearLayout.LayoutParams(-1, -2);
		tblll.setLayoutParams(tblllp);

		tblll.setGravity(Gravity.CENTER_HORIZONTAL);
		tblll.addView(tbl);

		// 按照给定的约束规则添加布局到当前相对布局中
		this.addView(tblll, mtextlayoutParams);

		// 设置按钮下方所要显示的页码信息
		RelativeLayout.LayoutParams tvParams = new RelativeLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
		tvParams.addRule(RelativeLayout.BELOW, btnId);
		this.addView(textView, tvParams);

	}

	/**
	 * 初始化按钮控件
	 */
	private void InitPhoto() {

		// 拍照按钮监听事件
		PhotoButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

				String status = Environment.getExternalStorageState();
				if (status.equals(Environment.MEDIA_MOUNTED)) {
					if (photoBitMaps.size() < maxNumber) {
						try {
							reqCode = Integer.parseInt((new SimpleDateFormat(
									"HHmmss")).format(new Date()));

							Intent intent = new Intent(
									"android.media.action.IMAGE_CAPTURE");
							intent.putExtra(MediaStore.EXTRA_OUTPUT,
									Uri.fromFile(new File(sdcardPath)));
							((Activity) mContext).startActivityForResult(
									intent, reqCode);
							// ((Activity)
							// mContext).startActivityForResult(intent,
							// Activity.DEFAULT_KEYS_DIALER);

						} catch (Exception e) {
							e.printStackTrace();
						}
					} else {
						Toast.makeText(mContext,
								"已达照片拍照上限,程序设置最多可拍 " + maxNumber + " 张!",
								Toast.LENGTH_SHORT).show();
					}
				} else {
					Toast.makeText(mContext, "无sd卡", Toast.LENGTH_SHORT).show();
				}

			}
		});

		// 删除按钮事件监听
		DelClickButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				if (curPhotoNum == -1) {
					return;
				}
				AlertDialog dlg = new AlertDialog.Builder(mContext)
				.setTitle("提示")
				.setMessage("是否删除当前照片？")
				.setPositiveButton("是",
						new DialogInterface.OnClickListener() {
							public void onClick(DialogInterface dlg,
									int which) {
								
								deletPhoto(curPhotoNum); // 删除
								curPhotoNum--;
								if (curPhotoNum < 0) { // 如果删除的照片是第一张

									// PreClickButton.setEnabled(false); //将上翻按钮不可用
									// setButtonGray(PreClickButton); //置灰上翻按钮
									int size = photoBitMaps.size();
									if (size == 0) { // 如果照片列表中已无照片
										curPhoto = null;
										photo.setImageBitmap(curPhoto);
										NextClickButton.setEnabled(false);
										setButtonGray(NextClickButton);
									} else { // 如果照片列表还有照片
										curPhotoNum = 0;
										curPhoto = photoBitMaps.get(0);
										photo.setImageBitmap(curPhoto);
										if (size == 1) { // 如果只剩一张照片的话,需要把后翻按钮同时置灰
											NextClickButton.setEnabled(false);
											setButtonGray(NextClickButton);
										}
									}
								} else { // 如果删除的照片不是第一张
									curPhoto = photoBitMaps.get(curPhotoNum);
									photo.setImageBitmap(curPhoto);
									if (curPhotoNum == 0) { // 如果已前移到第一张图片的位置
										PreClickButton.setEnabled(false); // 将上翻按钮不可用
										setButtonGray(PreClickButton); // 置灰上翻按钮
									}
								}
								updateTvNum();
							}
						})
				.setNegativeButton("否",
						new DialogInterface.OnClickListener() {
							public void onClick(DialogInterface dlg,
									int which) {
								dlg.dismiss();
							}
						}).show();
				
				/*
				 * if (curPhotoNum == -1) { return; } //
				 * 当当前照片序号在0-size之间时,先删除掉maps当中的数据 if (curPhotoNum <
				 * photoBitMaps.size() && curPhotoNum != -1) {
				 * deletPhoto(curPhotoNum); // 删除 } //
				 * 当当前照片序号大于0时,设置下一张照片,并将序号递减1 if (curPhotoNum > 0) {
				 * photo.setImageBitmap(photoBitMaps.get(curPhotoNum - 1));
				 * curPhotoNum--; } // 当删除的是第一张图片并且maps当中还存在有其它照片时 if
				 * (curPhotoNum == 0 && photoBitMaps.size() > 0) {
				 * photo.setImageBitmap(photoBitMaps.get(0)); curPhotoNum = 0; }
				 * // 当删除了所有的相片,则清除按钮和照片设置 if (photoBitMaps.size() == 0) {
				 * 
				 * curPhoto = null; photo.setImageBitmap(curPhoto);
				 * PreClickButton.setEnabled(false);
				 * NextClickButton.setEnabled(false);
				 * setButtonGray(PreClickButton);
				 * setButtonGray(NextClickButton); return; } //
				 * 当删除的只剩一张照片时,将按钮设置为不可用 if (photoBitMaps.size() == 1) {
				 * PreClickButton.setEnabled(false);
				 * NextClickButton.setEnabled(false);
				 * setButtonGray(PreClickButton);
				 * setButtonGray(NextClickButton); return; }
				 */
			}
		});

		// 前翻按钮事件监听
		PreClickButton.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				preImage();
			}
		});

		// 后翻按钮事件监听
		NextClickButton.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				nextImage();
			}
		});
	}

	/**
	 * 获取相机照相后照片数据
	 * 
	 * @return 相机返回的Bitmap对象
	 * @throws IOException
	 */
	private Bitmap getTakePhoto() throws IOException {

		// 读取SD卡上已存储的test.jpg,转化为输入流
		File getPhoto = new File(sdcardPath);
		if (getPhoto.exists()) {
			InputStream is = new FileInputStream(getPhoto);
			byte[] buffer = new byte[1024];
			int len = -1;
			ByteArrayOutputStream outStream = new ByteArrayOutputStream();
			while ((len = is.read(buffer)) != -1) {
				outStream.write(buffer, 0, len);
			}

			// 将输入流转化为字节输出流并进一步转化为照片
			byte[] data = outStream.toByteArray();
			outStream.close();
			is.close();
			BitmapFactory.Options opt = new BitmapFactory.Options();
			opt.inJustDecodeBounds = true;
			getPhoto.delete();

			return BitmapFactory.decodeByteArray(data, 0, data.length/* ,opt */);
		} else {
			return null;
		}
	}

	/**
	 * 删除某个图片列表某个位置图片
	 * 
	 * @param index
	 */
	private void deletPhoto(int index) {
		photoBitMaps.remove(index);
	}

	/**
	 * 显示上一张图片
	 */
	private void preImage() {
		curPhotoNum--;
		Log.i("next", curPhotoNum + "");
		if (curPhotoNum == 0) {
			PreClickButton.setEnabled(false);
			setButtonGray(PreClickButton);
		}

		if (curPhotoNum < photoBitMaps.size() - 1) {
			NextClickButton.setEnabled(true);
			NextClickButton.clearColorFilter();
		}
		curPhoto = photoBitMaps.get(curPhotoNum);
		photo.setImageBitmap(photoBitMaps.get(curPhotoNum));
		updateTvNum();
	}

	/**
	 * 显示下一张图片
	 */
	private void nextImage() {
		curPhotoNum++;
		Log.i("next", curPhotoNum + "");

		if (curPhotoNum > 0) {
			PreClickButton.setEnabled(true);
			PreClickButton.clearColorFilter();
		}

		if (curPhotoNum < photoBitMaps.size() - 1) {
			NextClickButton.setEnabled(true);
			NextClickButton.clearColorFilter();
		} else {
			NextClickButton.setEnabled(false);
			setButtonGray(NextClickButton);
		}

		curPhoto = photoBitMaps.get(curPhotoNum);
		photo.setImageBitmap(photoBitMaps.get(curPhotoNum));
		updateTvNum();
	}

	/**
	 * 设置当前显示图片序号
	 * 
	 * @param intex
	 */
	private void setCurrentIndex() {
		curPhotoNum = photoBitMaps.size() - 1;
		if (photoBitMaps.size() > 1) {

			if (curPhotoNum > 0) {
				PreClickButton.setEnabled(true);
				PreClickButton.clearColorFilter();
			}
			NextClickButton.setEnabled(false);
			setButtonGray(NextClickButton);
		}
	}

	/**
	 * 设置相机按钮显示状态
	 * 
	 * @param state
	 *            true-显示 false-不显示
	 */
	public void setTakePhotoVisible(Boolean state) {

		if (state) {
			PhotoButton.setVisibility(View.VISIBLE);
		} else {
			PhotoButton.setVisibility(View.GONE);

		}
		isTakephotoShow = state;
	}

	/**
	 * 设置删除按钮显示状态
	 * 
	 * @param state
	 *            true-显示 false-不显示
	 */
	public void setDeleteVisible(Boolean state) {

		if (state) {
			DelClickButton.setVisibility(View.VISIBLE);
		} else {
			DelClickButton.setVisibility(View.GONE);

		}
		isDeletShow = state;
	}

	/**
	 * 设置控件显示图片列表
	 * 
	 * @param pics
	 */
	public void setPhotoImage(List<Bitmap> pics) {
		if (pics != null) {
			if (pics.size() > 0) {
				photoBitMaps.clear();
				for (Bitmap pic : pics) {
					photoBitMaps.add(pic);
				}
				photo.setImageBitmap(photoBitMaps.get(0));
				curPhoto = photoBitMaps.get(0);
				curPhotoNum = 0;
				updateTvNum();
				PreClickButton.setEnabled(false);
				setButtonGray(PreClickButton);
				NextClickButton.setEnabled(false);
				setButtonGray(NextClickButton);
				if (pics.size() > 1) {
					NextClickButton.setEnabled(true);
					NextClickButton.clearColorFilter();
				}
			}
		}
	}

	/**
	 * 获取当前控件保留的图片列表
	 * 
	 * @return
	 */
	public List<Bitmap> getPhotoImage() {
		List<Bitmap> temp = new ArrayList<Bitmap>();
		for (Bitmap pic : photoBitMaps) {
			temp.add(pic);
		}
		return temp;
	}

	/**
	 * 设置几个按钮的显示图标参数依次是（照相，向前，向后，删除按钮）
	 * 
	 * @param takeButImg
	 * @param PreButImg
	 * @param nextButImg
	 * @param delButImg
	 */
	public void setImageButton(Drawable takeButImg, Drawable PreButImg,
			Drawable nextButImg, Drawable delButImg) {
		PhotoButton.setImageDrawable(takeButImg);
		DelClickButton.setImageDrawable(delButImg);
		PreClickButton.setImageDrawable(PreButImg);
		NextClickButton.setImageDrawable(nextButImg);

	}

	/**
	 * 根据上下文和文件名获取到图片(Drawable)
	 * 
	 * @param cx
	 *            上下文
	 * @param imgName
	 *            图片名称
	 * @return Drawable类型的图片
	 */
	private Drawable getDrawableFromAssets(Context cx, String imgName) {
		InputStream is = null;
		try {
			is = cx.getResources().getAssets().open(imgName);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Bitmap bitmap = BitmapFactory.decodeStream(is);
		BitmapDrawable bd = new BitmapDrawable(bitmap);
		return bd;
	}

	/**
	 * 获取assets文件夹中得图片
	 * 
	 * @param context
	 *            窗体句柄
	 * @param fileName
	 *            文件路径名
	 * @return 获取到得drawable
	 */
	private static Drawable getImageFromAssetsFile(Context context,
			String fileName) {
		InputStream stream;
		Drawable drawable = null;
		try {
			stream = context.getClass().getClassLoader()
					.getResourceAsStream(fileName);
			drawable = Drawable.createFromStream(stream, "");
		} catch (Exception e) {

		}
		return drawable;
	}

	/**
	 * 处理获取到的照片数据并显示
	 */
	private void setPhoto() {
		try {
			/**
			 * 获取相机照相后照片数据
			 */
			Bitmap pic = getBitmapzise(photoWidth, photoHeight);
			// Bitmap pic = getTakePhoto();

			if (pic != null) {

				// 添加至照片集合
				photoBitMaps.add(pic);

				// 设置当前显示照片序号
				setCurrentIndex();

				// 设置当前显示的照片
				photo.setImageBitmap(pic);

				// 更新页码
				updateTvNum();

			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	/**
	 * 对调用系统拍照返回来的数据进行处理和显示
	 */
	@Override
	public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
		// TODO Auto-generated method stub
		if (requestCode == reqCode) {
			if (resultCode == Activity.RESULT_OK) {
				setPhoto();
				// getBitmapzise(640,480);
			}
		}
		return true;
	}

	/**
	 * 设置照片显示控件的显示大小
	 * 
	 * @param w
	 *            宽度
	 * @param h
	 *            高度
	 */
	public void setPhotoSize(int w, int h) {
		this.imageWidth = w;
		this.imageHeight = h;
		android.widget.LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
				imageWidth, imageHeight);
		photo.setLayoutParams(params);
	}

	/**
	 * 以屏幕分辨率为基准,按照所给定的宽度和高度的比例来设置照片大小
	 * 
	 * @param wRate
	 *            宽度比例 0<wRate<1
	 * @param hRate
	 *            高度比例 0<hRate<1
	 */
	public void setPhotoSizeByRate(float wRate, float hRate) {
		if (wRate > 1 || hRate > 1 || wRate < 0 || hRate < 0) {
			return;
		}

		// 计算手机分辨率
		DisplayMetrics dm = new DisplayMetrics();
		((Activity) mContext).getWindowManager().getDefaultDisplay()
				.getMetrics(dm);
		int width = dm.widthPixels; // 当前屏幕宽度
		int height = dm.heightPixels; // 当前屏幕高度

		// 按比例计算出宽和高
		this.imageWidth = (int) (width * wRate);
		this.imageHeight = (int) (height * hRate);

		// 设置照片大小
		android.widget.LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
				imageWidth, imageHeight);
		photo.setLayoutParams(params);

	}

	/**
	 * 设置控件的宽高
	 * 
	 * @param w
	 *            宽度 其中-1:整个屏幕宽度 -2:自适应
	 * @param h
	 *            高度 其中-1:整个屏幕宽度 -2:自适应
	 */
	public void setSize(int w, int h) {

		RelativeLayout.LayoutParams mtextlayoutParams = new RelativeLayout.LayoutParams(
				w, h);
		this.setLayoutParams(mtextlayoutParams);
	}

	/**
	 * 将给定的ImageView置灰
	 * 
	 * @param iv
	 *            需要操作的ImageView按钮
	 */
	private void setButtonGray(ImageView iv) {
		if (iv != null) {
			// Matrix ma = new Matrix();
			// ma.setScale(1.5f, 1); //x轴1.5倍,y轴1倍
			ColorMatrix cm = new ColorMatrix();
			cm.setSaturation(0.0f); // 使ImageView变灰
			// cm.setScale(0.6f, 0.6f, 0.6f, 0.8f); //调整按钮的灰度级别
			ColorMatrixColorFilter cf = new ColorMatrixColorFilter(cm);
			iv.setColorFilter(cf);
		}
	}

	/**
	 * 为按钮设置间距
	 * 
	 * @param paddingW
	 *            宽度
	 */
	public void setPaddingForButton(int paddingW) {
		PhotoButton.setPadding(paddingW, 0, paddingW, 0);
		DelClickButton.setPadding(paddingW, 0, paddingW, 0);
		PreClickButton.setPadding(paddingW, 0, paddingW, 0);
		NextClickButton.setPadding(paddingW, 0, paddingW, 0);
	}

	/**
	 * 设置默认的图片背景
	 * 
	 * @param d
	 *            要设置的照片
	 */
	public void setDefaultBg(Drawable d) {
		photo.setBackgroundDrawable(d);
	}

	/**
	 * 更新页码显示
	 */
	private void updateTvNum() {
		textView.setText(curPhotoNum + 1 + " / " + photoBitMaps.size());
	}

	/**
	 * 设置页码显示页是否显示
	 * 
	 * @param display
	 *            true-显示 false-隐藏
	 */
	public void setNoteVisible(boolean display) {
		if (display) {
			textView.setVisibility(View.VISIBLE);
		} else {
			textView.setVisibility(View.GONE);
		}
	}

	/**
	 * 获取当前所显示的照片对象(Bitmap类型)
	 * 
	 * @return 当没有拍照直接调用此方法时,返回null
	 */
	public Bitmap getCurrentBitmap() {
		if(photoBitMaps.size()<1 || curPhotoNum == -1){
			return null;
		}
		return photoBitMaps.get(curPhotoNum);
	}

	/**
	 * 备用方法,指定分辨率的照片
	 * 
	 * @return 拍照获取到的Bitmap对象
	 */
	private Bitmap getBitmapzise(int sizew, int sizeh) {
		BitmapFactory.Options o = new BitmapFactory.Options();
		o.inJustDecodeBounds = true;

		Bitmap bitmap = BitmapFactory.decodeFile(sdcardPath, o);
		int height = o.outHeight;
		int width = o.outWidth;

		o.inSampleSize = 1;

		o.inJustDecodeBounds = false;
		bitmap = BitmapFactory.decodeFile(sdcardPath, o);

		// sizew = 640;
		// sizeh = 480;

		float scaleWidth = ((float) sizew) / width;
		float scaleHeight = ((float) sizeh) / height;
		Matrix matrix = new Matrix();
		matrix.postRotate(90);
		matrix.postScale(scaleWidth, scaleHeight);
		Bitmap resizedBitmap = Bitmap.createBitmap(bitmap, 0, 0, width, height,
				matrix, true);
		return resizedBitmap;
	}

	/**
	 * 按照所给的分辨率设置实际相片的大小(如480*320默认)
	 * 
	 * @param sizew
	 *            宽度
	 * @param sizeh
	 *            高度
	 */
	public void setPhotoBitmap(int sizew, int sizeh) {
		photoWidth = sizew;
		photoHeight = sizeh;
	}
	
	/**
	 * 设置最多可拍照张数
	 * @param num 数值
	 */
	public void setMaxPhotosNumber(int num){
		maxNumber = num;
	}
	
	/**
	 * 构建控件的状态组背景
	 * 
	 * @param drawables
	 *            用到的drawable数组
	 * @return 状态组背景
	 */
	private StateListDrawable setBackgroundWithStateListDrawable(
			Drawable[] drawables) {
		StateListDrawable bg = new StateListDrawable();
		bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[1]);
		bg.addState(View.ENABLED_STATE_SET, drawables[0]);
		bg.addState(View.FOCUSED_STATE_SET, drawables[1]);
		bg.addState(View.EMPTY_STATE_SET, drawables[0]);
		return bg;
	}
	
	/**
	 * 获取assets文件夹中得图片
	 * 
	 * @param context
	 *            窗体句柄
	 * @param fileName
	 *            文件路径名
	 * @return 获取到得drawable
	 */
	private Drawable getImageFromAssetsFile1(Context context,
			String fileName) {
		InputStream stream;
		Drawable drawable = null;
		try {
			stream = context.getClass().getClassLoader()
					.getResourceAsStream(fileName);
			drawable = Drawable.createFromStream(stream, "");
		} catch (Exception e) {

		}
		return drawable;
	}

}