package com.xdja.combox.tabhost;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.DisplayMetrics;
import android.view.View;

import com.xdja.combox.utils.DensityUtil;

public class JumpPoint extends View {
	/**当前白点的位置*/
	private int newwhitelocation=0;
	private Context context;
	/**当前屏幕的宽度*/
	private int screenW=0;
	/**小点之间的间距*/
	private float  space=0.0f;
	/**小点的半径*/
	private float radius=0.0f;
	/**小点的个数*/
	private int Pointnumber=-1;
	public JumpPoint(Context context,int size,int _radius) {
		super(context);
		this.context=context;
		DisplayMetrics dm = new DisplayMetrics();
		((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(dm);
		screenW = dm.widthPixels;// 获取分辨率宽度
		radius=_radius;
		space=(float) ((screenW)/(size+4));
		Pointnumber=size; 
	}
	@Override
	protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
		// TODO Auto-generated method stub
		super.onMeasure(widthMeasureSpec, heightMeasureSpec);
	}
	@Override
	protected void onDraw(Canvas canvas) {
		// TODO Auto-generated method stub
		super.onDraw(canvas); 
		   Paint WhitePaint = new Paint();
	   		/* 设置取消锯齿效果 */
	   		WhitePaint.setAntiAlias(true);
	   		WhitePaint.setColor(0xe5ffffff);
	   		Paint GaryPaint = new Paint();
	   		/* 设置取消锯齿效果 */
	   		GaryPaint.setAntiAlias(true);
	   		GaryPaint.setColor(0xccffffff);
	   		
	   		
	   		Paint blackPaint = new Paint();
	   		/* 设置取消锯齿效果 */
	   		blackPaint.setAntiAlias(true);
	   		blackPaint.setColor(0xff000000);
	   		blackPaint.setTextSize(DensityUtil.sp2px(16, context));
	   		for(int i=0;i<Pointnumber;i++)
	   		{
	   			if(newwhitelocation==i)
	   			{
	   				canvas.drawCircle((float) (space*2.5+space*newwhitelocation),(float)(radius*2), (float) (radius*1.8), WhitePaint);
	   				float textwidth=blackPaint.measureText(String.valueOf(i));
	   				canvas.drawText(String.valueOf(i), (space*(float)2.5+space*newwhitelocation)-textwidth/2, radius*(float)3, blackPaint);
	   			}else{
	   				canvas.drawCircle((float) (space*2.5+space*i),(float)(radius*2.2), radius, GaryPaint);
	   			}
	   		}
	}
	public void setPageState(int arg0) {
		// TODO Auto-generated method stub
		newwhitelocation=arg0;
		postInvalidate();
	}	
}
