package com.xdja.combox.treeview;

import java.util.ArrayList;

/**
 * 树形控件数据源中节点元素类
 * @author hhz
 *
 */
public class TreeElementBean {
	private String id;						//节点Id
	private String nodeName ;				//节点名称
	private boolean hasParent; 				//是否有父节点
	private boolean hasChild ;				//是否有子节点
	private String upNodeId;				//上一级节点Id
	private boolean expanded;				//展开还是折叠
	private int level;						//节点所处层级
	private ArrayList<TreeElementBean> childNodes = new ArrayList<TreeElementBean>(); //所拥有的子节点 

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getUpNodeId() {
		return upNodeId;
	}

	public void setUpNodeId(String upNodeId) {
		this.upNodeId = upNodeId;
	}

	public String getNodeName() {
		return nodeName;
	}

	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}

	public boolean isHasParent() {
		return hasParent;
	}

	public void setHasParent(boolean hasParent) {
		this.hasParent = hasParent;
	}

	public boolean isHasChild() {
		return hasChild;
	}

	public void setHasChild(boolean hasChild) {
		this.hasChild = hasChild;
	}

	public boolean isExpanded() {
		return expanded;
	}

	public void setExpanded(boolean expanded) {
		this.expanded = expanded;
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		this.level = level;
	}
	
	public ArrayList<TreeElementBean> getChildNodes() {
		return childNodes;
	}

	public void setChildNodes(ArrayList<TreeElementBean> childNodes) {
		this.childNodes = childNodes;
	}
	
	public void addChild(TreeElementBean childNode) {
        this.hasChild = true;
        this.childNodes.add(childNode);
   }


	public TreeElementBean(String id, String nodeName,
			boolean hasParent, boolean hasChild, String upNodeId, int level,
			boolean expanded) {
		super();
		this.id = id;
		this.nodeName = nodeName;
		this.hasParent = hasParent;
		this.hasChild = hasChild;
		this.upNodeId = upNodeId;
		this.level = level;
		this.expanded = expanded;
	}
}
