/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.button;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import java.io.IOException;
import java.io.InputStream;

public class XDButton
extends Button {
    private Drawable mDrawable;
    private int type;
    private Drawable[] drawables_round = new Drawable[3];
    private Drawable[] drawables_square;
    private StateListDrawable mStateListDrawable;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.setBackgroundByType();
    }

    public Drawable getmDrawable() {
        return this.mDrawable;
    }

    public void setmDrawable(Drawable mDrawable) {
        this.mDrawable = mDrawable;
        this.setBackgroundByType();
    }

    public void setmDrawable(int resouceId) {
        this.mDrawable = this.getResources().getDrawable(resouceId);
        this.setBackgroundByType();
    }

    public XDButton(Context context) {
        this(context, null);
    }

    public XDButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.drawables_round[0] = this.get9ImageFromAssetsFile(context, "xdbutton_round_pressed.9.png");
        this.drawables_round[1] = this.get9ImageFromAssetsFile(context, "xdbutton_round.9.png");
        this.drawables_square = new Drawable[3];
        this.drawables_square[0] = this.get9ImageFromAssetsFile(context, "xdbutton_square_pressed.9.png");
        this.drawables_square[1] = this.get9ImageFromAssetsFile(context, "xdbutton_square.9.png");
        if (attrs != null) {
            for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                int resourceId;
                if ("type".equals(attrs.getAttributeName(i))) {
                    this.type = Integer.parseInt(attrs.getAttributeValue(i));
                    continue;
                }
                if (!"background".equals(attrs.getAttributeName(i)) || (resourceId = attrs.getAttributeResourceValue(i, 0)) <= 0) continue;
                this.mDrawable = this.getResources().getDrawable(resourceId);
            }
        }
        this.setBackgroundByType();
    }

    private void setBackgroundByType() {
        switch (this.type) {
            case 0: {
                this.mStateListDrawable = this.setBg(this.drawables_square);
                break;
            }
            case 1: {
                this.mStateListDrawable = this.setBg(this.drawables_round);
                break;
            }
        }
        if (this.mDrawable == null) {
            this.setBackgroundDrawable((Drawable)this.mStateListDrawable);
        } else {
            this.setBackgroundDrawable(this.mDrawable);
        }
        this.setPadding(10, 5, 10, 5);
    }

    private NinePatchDrawable get9ImageFromAssetsFile(Context context, String FileName) {
        try {
            InputStream stream = context.getAssets().open(FileName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
            byte[] chunk = bitmap.getNinePatchChunk();
            boolean result = NinePatch.isNinePatchChunk((byte[])chunk);
            NinePatchDrawable patchy = null;
            if (result) {
                patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
            }
            return patchy;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private StateListDrawable setBg(Drawable[] drawables) {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(View.PRESSED_ENABLED_STATE_SET, drawables[0]);
        bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[0]);
        bg.addState(View.ENABLED_STATE_SET, drawables[1]);
        bg.addState(View.FOCUSED_STATE_SET, drawables[0]);
        bg.addState(View.EMPTY_STATE_SET, drawables[1]);
        return bg;
    }
}

