/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.datetime;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TabHost;
import android.widget.TabWidget;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextSwitcher;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.ViewSwitcher;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class XDDateDialog
extends AlertDialog
implements View.OnClickListener {
    private Context mcontext = null;
    public static final int SHOW_Date = 0;
    public static final int SHOW_Time = 1;
    public static final int SHOW_Time_Date = 2;
    private int DateDialogShowStyle = 2;
    private RelativeLayout datelayout = null;
    private RelativeLayout timelayout = null;
    private Bitmap icon = null;
    private TextSwitcher title = null;
    private String Date = "";
    private String Time = "";
    private String Date_Time = "";
    private String second = null;
    private EditText edittext = null;
    private int Year = 0;
    private int Month = 0;
    private int Day = 0;
    private int Hour = 0;
    private int Minute = 0;
    private int Second = 0;
    private Boolean isDateFormat = false;

    public XDDateDialog(Context context, int ShowStyle, EditText _editText, String _second) {
        super(context);
        this.mcontext = context;
        this.DateDialogShowStyle = ShowStyle;
        this.edittext = _editText;
        this.second = _second;
        if (this.checkEditTextTag().booleanValue()) {
            if (!this.checkDateFormat().booleanValue()) {
                this.isDateFormat = true;
            }
        } else {
            this.isDateFormat = true;
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (2 == this.DateDialogShowStyle) {
            this.icon = this.getBitmap("xddatetime_clock.png");
            this.setContentView((View)this.InitLayout());
        } else {
            this.setContentView((View)this.setTimeorDateLayout());
        }
    }

    public String getTag() {
        String temStr = this.Date_Time.replace(" ", "");
        temStr = temStr.replace(":", "");
        temStr = temStr.replace("/", "");
        return temStr;
    }

    public String getText() {
        return this.Date_Time;
    }

    private Boolean checkEditTextTag() {
        if (!this.edittext.getText().toString().trim().equals("") && this.edittext.getTag() == null) {
            return false;
        }
        return true;
    }

    private Boolean checkDateFormat() {
        SimpleDateFormat sdf = null;
        switch (this.DateDialogShowStyle) {
            case 0: {
                sdf = new SimpleDateFormat("yyyyMMdd");
                break;
            }
            case 1: {
                if (this.second == null) {
                    sdf = new SimpleDateFormat("HHmm");
                    break;
                }
                sdf = new SimpleDateFormat("HHmmss");
                break;
            }
            case 2: {
                if (this.second == null) {
                    sdf = new SimpleDateFormat("yyyyMMddHHmm");
                    break;
                }
                sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                break;
            }
        }
        if (this.edittext.getTag() == null) {
            return true;
        }
        int res = this.checkDateFormatAndValite(sdf, this.edittext.getTag().toString().trim());
        if (res == 1) {
            return true;
        }
        return false;
    }

    private TabHost InitLayout() {
        final TabHost m_TabHost = new TabHost(this.mcontext);
        m_TabHost.setId(0x1020012);
        LinearLayout.LayoutParams m_table = new LinearLayout.LayoutParams(-1, -1);
        m_TabHost.setLayoutParams((ViewGroup.LayoutParams)m_table);
        ColorDrawable dw = new ColorDrawable(Color.argb((int)120, (int)0, (int)0, (int)0));
        m_TabHost.setBackgroundDrawable((Drawable)dw);
        LinearLayout m_layout = new LinearLayout(this.mcontext);
        m_layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        m_layout.setOrientation(1);
        m_layout.addView((View)this.creatTitleView());
        FrameLayout content = new FrameLayout(this.mcontext);
        content.setId(0x1020011);
        LinearLayout.LayoutParams contentlp = new LinearLayout.LayoutParams(-1, -1);
        contentlp.weight = 1.0f;
        content.setLayoutParams((ViewGroup.LayoutParams)contentlp);
        content.addView((View)this.DateLayout());
        content.addView((View)this.TimeLayout());
        final TabWidget m_tabWidget = new TabWidget(this.mcontext);
        m_tabWidget.setId(16908307);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -2);
        m_tabWidget.setLayoutParams((ViewGroup.LayoutParams)lp);
        m_tabWidget.setStripEnabled(false);
        HorizontalScrollView m_horizontalscroll = new HorizontalScrollView(this.mcontext);
        LinearLayout.LayoutParams horizontalscroll_layoutParams = new LinearLayout.LayoutParams(-1, -2);
        horizontalscroll_layoutParams.weight = 0.0f;
        m_horizontalscroll.setLayoutParams((ViewGroup.LayoutParams)horizontalscroll_layoutParams);
        m_horizontalscroll.setVerticalScrollBarEnabled(true);
        m_horizontalscroll.addView((View)m_tabWidget);
        m_layout.addView((View)m_horizontalscroll);
        m_layout.addView((View)content);
        m_layout.addView((View)this.setButton());
        m_TabHost.addView((View)m_layout);
        m_TabHost.setup();
        TabHost.TabSpec tab1 = m_TabHost.newTabSpec("0");
        tab1.setIndicator(this.createTabView("\u65e5\u671f"));
        tab1.setContent(this.datelayout.getId());
        m_TabHost.addTab(tab1);
        TabHost.TabSpec tab2 = m_TabHost.newTabSpec("1");
        tab2.setIndicator(this.createTabView("\u65f6\u95f4"));
        tab2.setContent(this.timelayout.getId());
        m_TabHost.addTab(tab2);
        m_TabHost.setCurrentTab(0);
        this.setSelect(m_tabWidget, 0);
        DisplayMetrics dm = new DisplayMetrics();
        ((Activity)this.mcontext).getWindowManager().getDefaultDisplay().getMetrics(dm);
        int screenWidth = dm.widthPixels;
        int weight = screenWidth / 7 * 6;
        this.setDialogWidth(weight);
        for (int i = 0; i < 2; ++i) {
            m_tabWidget.getChildTabViewAt(i).setMinimumWidth(weight / 2);
        }
        m_TabHost.setOnTabChangedListener(new TabHost.OnTabChangeListener(){

            public void onTabChanged(String tabId) {
                XDDateDialog.this.setSelect(m_tabWidget, m_TabHost.getCurrentTab());
            }
        });
        return m_TabHost;
    }

    private void setSelect(TabWidget mtabWidget, int selectab) {
        View vvv = mtabWidget.getChildTabViewAt(0);
        View vv = mtabWidget.getChildTabViewAt(1);
        if (selectab == 0) {
            vvv.setBackgroundDrawable(this.getDrawable("tabselect.png"));
            vv.setBackgroundDrawable(this.getDrawable("tabunselect.png"));
        } else {
            vvv.setBackgroundDrawable(this.getDrawable("tabunselect.png"));
            vv.setBackgroundDrawable(this.getDrawable("tabselect.png"));
        }
    }

    private void setDialogWidth(int Weight) {
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        lp.width = Weight;
        this.getWindow().setAttributes(lp);
    }

    private LinearLayout creatTitleView() {
        LinearLayout m_layout = new LinearLayout(this.mcontext);
        m_layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        m_layout.setOrientation(0);
        m_layout.setPadding(5, 8, 0, 8);
        ImageView image = new ImageView(this.mcontext);
        image.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        image.setImageBitmap(this.icon);
        m_layout.addView((View)image);
        this.title = new TextSwitcher(this.mcontext);
        this.title.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.title.setFactory(new ViewSwitcher.ViewFactory(){

            public View makeView() {
                TextView t = new TextView(XDDateDialog.this.mcontext);
                t.setTextColor(-1);
                t.setTextSize(20.0f);
                return t;
            }
        });
        Animation in = AnimationUtils.loadAnimation((Context)this.mcontext, (int)0x10A0000);
        Animation out = AnimationUtils.loadAnimation((Context)this.mcontext, (int)0x10A0001);
        this.title.setPadding(5, 0, 0, 0);
        this.title.setInAnimation(in);
        this.title.setOutAnimation(out);
        m_layout.addView((View)this.title);
        return m_layout;
    }

    private View createTabView(String text) {
        LinearLayout mLinearLayout = new LinearLayout(this.mcontext);
        mLinearLayout.setGravity(17);
        mLinearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        mLinearLayout.setOrientation(1);
        mLinearLayout.setGravity(17);
        TextView mtext = new TextView(this.mcontext);
        mtext.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        mtext.setTextSize(18.0f);
        mtext.setTextColor(-1);
        mtext.setText((CharSequence)text);
        mtext.setPadding(0, 5, 0, 5);
        mLinearLayout.addView((View)mtext);
        mLinearLayout.setBaselineAligned(true);
        return mLinearLayout;
    }

    private LinearLayout setTimeorDateLayout() {
        DisplayMetrics dm = new DisplayMetrics();
        ((Activity)this.mcontext).getWindowManager().getDefaultDisplay().getMetrics(dm);
        int screenWidth = dm.widthPixels;
        int weight = screenWidth / 7 * 6;
        this.setDialogWidth(weight);
        LinearLayout m_layout = new LinearLayout(this.mcontext);
        m_layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        m_layout.setOrientation(1);
        if (this.DateDialogShowStyle == 1) {
            this.icon = this.getBitmap("xddatetime_clock.png");
            m_layout.addView((View)this.creatTitleView());
            m_layout.addView((View)this.TimeLayout());
            m_layout.addView((View)this.setButton());
        }
        if (this.DateDialogShowStyle == 0) {
            this.icon = this.getBitmap("xddatetime_clock.png");
            m_layout.addView((View)this.creatTitleView());
            m_layout.addView((View)this.DateLayout());
            m_layout.addView((View)this.setButton());
        }
        ColorDrawable dw = new ColorDrawable(Color.argb((int)120, (int)0, (int)0, (int)0));
        m_layout.setBackgroundDrawable((Drawable)dw);
        return m_layout;
    }

    private RelativeLayout DateLayout() {
        this.datelayout = new RelativeLayout(this.mcontext);
        RelativeLayout.LayoutParams datelayoutparams = null;
        if (this.DateDialogShowStyle != 0) {
            datelayoutparams = new RelativeLayout.LayoutParams(-1, -1);
            this.datelayout.setLayoutParams((ViewGroup.LayoutParams)datelayoutparams);
        } else {
            datelayoutparams = new RelativeLayout.LayoutParams(-1, -2);
            this.datelayout.setLayoutParams((ViewGroup.LayoutParams)datelayoutparams);
        }
        DatePicker datepicker = new DatePicker(this.mcontext);
        float scale = this.mcontext.getResources().getDisplayMetrics().density;
        int size = (int)(100.0f * scale + 0.5f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(size, -2);
        int sdk_version = Integer.parseInt(Build.VERSION.SDK);
        if (sdk_version >= 14) {
            ((ViewGroup)((ViewGroup)datepicker.getChildAt(0)).getChildAt(0)).getChildAt(1).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        RelativeLayout.LayoutParams datepickerlayoutparams = new RelativeLayout.LayoutParams(-2, -2);
        datepickerlayoutparams.addRule(13);
        datepicker.setLayoutParams((ViewGroup.LayoutParams)datepickerlayoutparams);
        this.datelayout.setId(11);
        if (this.edittext.getText().toString().replace(" ", "").equals("") || this.isDateFormat.booleanValue()) {
            Calendar c = Calendar.getInstance();
            this.Year = c.get(1);
            this.Month = c.get(2) + 1;
            this.Day = c.get(5);
            this.Date = this.Year + "/" + (this.Month < 10 ? "0" + this.Month : Integer.valueOf(this.Month)) + "/" + (this.Day < 10 ? "0" + this.Day : Integer.valueOf(this.Day));
        } else if (this.edittext.getTag().toString().length() >= 8) {
            try {
                this.Year = Integer.valueOf(this.edittext.getTag().toString().substring(0, 4));
                this.Month = Integer.valueOf(this.edittext.getTag().toString().substring(4, 6));
                this.Day = Integer.valueOf(this.edittext.getTag().toString().substring(6, 8));
            }
            catch (Exception e) {
                e.printStackTrace();
                Calendar c = Calendar.getInstance();
                this.Year = c.get(1);
                this.Month = c.get(2) + 1;
                this.Day = c.get(5);
                this.Date = this.Year + "/" + (this.Month < 10 ? "0" + this.Month : Integer.valueOf(this.Month)) + "/" + (this.Day < 10 ? "0" + this.Day : Integer.valueOf(this.Day));
            }
            this.Date = this.Year + "/" + (this.Month < 10 ? "0" + this.Month : Integer.valueOf(this.Month)) + "/" + (this.Day < 10 ? "0" + this.Day : Integer.valueOf(this.Day));
        }
        if (this.DateDialogShowStyle == 0) {
            this.Date_Time = this.Date;
            this.title.setText((CharSequence)this.Date_Time);
        }
        datepicker.init(this.Year, this.Month - 1, this.Day, new DatePicker.OnDateChangedListener(){

            public void onDateChanged(DatePicker arg0, int year, int month, int day) {
                XDDateDialog.this.Date = year + "/" + (month < 9 ? "0" + (month + 1) : Integer.valueOf(month + 1)) + "/" + (day < 10 ? "0" + day : Integer.valueOf(day));
                XDDateDialog.this.Date_Time = XDDateDialog.this.Date + " " + XDDateDialog.this.Time;
                XDDateDialog.this.title.setText((CharSequence)XDDateDialog.this.Date_Time);
            }
        });
        datepicker.setId(101);
        this.datelayout.addView((View)datepicker);
        if (this.DateDialogShowStyle != 0) {
            this.datelayout.setVisibility(4);
        }
        return this.datelayout;
    }

    private RelativeLayout TimeLayout() {
        this.timelayout = new RelativeLayout(this.mcontext);
        RelativeLayout.LayoutParams timelayoutparams = null;
        timelayoutparams = this.DateDialogShowStyle != 1 ? new RelativeLayout.LayoutParams(-1, -1) : new RelativeLayout.LayoutParams(-1, -2);
        this.timelayout.setLayoutParams((ViewGroup.LayoutParams)timelayoutparams);
        Calendar c = Calendar.getInstance();
        if (this.edittext.getText().toString().replace(" ", "").equals("") || this.isDateFormat.booleanValue()) {
            this.Hour = c.get(11);
            this.Minute = c.get(12);
        } else {
            try {
                if (this.edittext.getTag().toString().length() <= 6) {
                    this.Hour = Integer.valueOf(this.edittext.getTag().toString().substring(0, 2));
                    this.Minute = Integer.valueOf(this.edittext.getTag().toString().substring(2, 4));
                } else {
                    this.Hour = Integer.valueOf(this.edittext.getTag().toString().substring(8, 10));
                    this.Minute = Integer.valueOf(this.edittext.getTag().toString().substring(10, 12));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.Hour = c.get(10);
                this.Minute = c.get(12);
            }
        }
        String temp = "";
        if (this.second == null) {
            this.Time = "" + (this.Hour <= 9 ? "0" + this.Hour : Integer.valueOf(this.Hour)) + ":" + (this.Minute <= 9 ? "0" + this.Minute : Integer.valueOf(this.Minute));
        } else if (this.second.equals("")) {
            this.Time = "" + (this.Hour <= 9 ? "0" + this.Hour : Integer.valueOf(this.Hour)) + ":" + (this.Minute <= 9 ? "0" + this.Minute : Integer.valueOf(this.Minute)) + ":" + (c.get(13) <= 9 ? "0" + c.get(13) : Integer.valueOf(c.get(13)));
            temp = String.valueOf(c.get(13) <= 9 ? "0" + c.get(13) : Integer.valueOf(c.get(13)));
        } else {
            this.Time = "" + (this.Hour <= 9 ? "0" + this.Hour : Integer.valueOf(this.Hour)) + ":" + (this.Minute <= 9 ? "0" + this.Minute : Integer.valueOf(this.Minute)) + ":" + (this.Second <= 9 ? "0" + this.Second : Integer.valueOf(this.Second));
            temp = String.valueOf(this.Second <= 9 ? "0" + this.Second : Integer.valueOf(this.Second));
        }
        final String secondvalue = temp;
        this.Date_Time = this.Date + " " + this.Time;
        if (this.DateDialogShowStyle == 1) {
            this.title.setText((CharSequence)this.Date_Time);
        }
        if (this.DateDialogShowStyle == 2) {
            this.title.setText((CharSequence)this.Date_Time);
        }
        TimePicker timepicker = new TimePicker(this.mcontext);
        RelativeLayout.LayoutParams tiempickerlayoutparams = new RelativeLayout.LayoutParams(-2, -2);
        tiempickerlayoutparams.addRule(13);
        timepicker.setLayoutParams((ViewGroup.LayoutParams)tiempickerlayoutparams);
        timepicker.setIs24HourView(Boolean.valueOf(true));
        timepicker.setCurrentHour(Integer.valueOf(this.Hour));
        timepicker.setCurrentMinute(Integer.valueOf(this.Minute));
        timepicker.setOnTimeChangedListener(new TimePicker.OnTimeChangedListener(){

            public void onTimeChanged(TimePicker arg0, int hour, int minute) {
                if (XDDateDialog.this.second == null) {
                    XDDateDialog.this.Time = "" + (hour <= 9 ? "0" + hour : Integer.valueOf(hour)) + ":" + (minute <= 9 ? "0" + minute : Integer.valueOf(minute));
                } else {
                    XDDateDialog.this.Time = "" + (hour <= 9 ? "0" + hour : Integer.valueOf(hour)) + ":" + (minute <= 9 ? "0" + minute : Integer.valueOf(minute)) + ":" + secondvalue;
                }
                XDDateDialog.this.Date_Time = XDDateDialog.this.Date + " " + XDDateDialog.this.Time;
                XDDateDialog.this.title.setText((CharSequence)XDDateDialog.this.Date_Time);
            }
        });
        this.timelayout.setId(10);
        this.timelayout.addView((View)timepicker);
        if (this.DateDialogShowStyle != 1) {
            this.timelayout.setVisibility(4);
        }
        return this.timelayout;
    }

    private NinePatchDrawable get9ImageFromAssetsFile(String FileName) {
        try {
            InputStream stream = this.mcontext.getAssets().open(FileName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
            byte[] chunk = bitmap.getNinePatchChunk();
            boolean result = NinePatch.isNinePatchChunk((byte[])chunk);
            NinePatchDrawable patchy = null;
            if (result) {
                patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
            }
            return patchy;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Bitmap getBitmap(String FileName) {
        Bitmap bitmap;
        try {
            InputStream stream = this.mcontext.getAssets().open(FileName);
            bitmap = BitmapFactory.decodeStream((InputStream)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return bitmap;
    }

    private Drawable getDrawable(String FileName) {
        Drawable drawable;
        try {
            InputStream stream = this.mcontext.getAssets().open(FileName);
            drawable = Drawable.createFromStream((InputStream)stream, (String)FileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return drawable;
    }

    private TableLayout setButton() {
        String[] message = new String[]{"\u786e\u8ba4", "\u6e05\u7a7a", "\u53d6\u6d88"};
        TableLayout mtablelayout = new TableLayout(this.mcontext);
        mtablelayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        mtablelayout.setId(1);
        mtablelayout.setOrientation(1);
        mtablelayout.setShrinkAllColumns(true);
        mtablelayout.setStretchAllColumns(true);
        TableRow mtableraw = new TableRow(this.mcontext);
        mtableraw.setLayoutParams((ViewGroup.LayoutParams)new TableLayout.LayoutParams(-1, -2));
        mtableraw.setOrientation(0);
        mtableraw.setGravity(80);
        for (int i = 0; i < message.length; ++i) {
            Button button = new Button(this.mcontext);
            button.setId(i);
            button.setTextSize(18.0f);
            button.setLayoutParams((ViewGroup.LayoutParams)new TableRow.LayoutParams(-2, -2));
            button.setText((CharSequence)message[i]);
            mtableraw.addView((View)button);
            button.setOnClickListener((View.OnClickListener)this);
        }
        mtablelayout.addView((View)mtableraw);
        return mtablelayout;
    }

    public void onClick(View v) {
        switch (v.getId()) {
            case 0: {
                this.edittext.setText((CharSequence)this.getText());
                this.edittext.setTag((Object)this.getTag());
                this.edittext.setFocusable(true);
                this.edittext.requestFocus();
                this.dismiss();
                break;
            }
            case 1: {
                this.edittext.setText((CharSequence)"");
                this.edittext.setTag((Object)"");
                this.edittext.setFocusable(true);
                this.edittext.requestFocus();
                this.dismiss();
                break;
            }
            case 2: {
                this.edittext.setFocusable(true);
                this.edittext.requestFocus();
                this.dismiss();
            }
        }
    }

    private int checkDateFormatAndValite(SimpleDateFormat format, String temp) {
        try {
            Date ndate = format.parse(temp);
            String str = format.format(ndate);
            System.out.println(ndate);
            System.out.println(str);
            if (str.equals(temp)) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

