/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.datetime;

import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.DatePicker;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TimePicker;
import com.xdja.combox.datetime.XDDateDialog;
import com.xdja.combox.inputbutton.XDEditText;
import com.xdja.combox.inputbutton.XDEditTextButton;
import com.xdja.combox.utils.DensityUtil;
import java.io.InputStream;
import java.util.Calendar;

public class XDDateTimeText
extends LinearLayout {
    private int TextShowType = 0;
    private String dateFormatStr = null;
    private String dateFormat = null;
    private int buttonShowStyle = 0;
    private String textView_text = null;
    private int textView_showStyle = 0;
    private int textView_textColor = 0;
    private String textView_textSize = "";
    private String textView_width = "";
    private int editText_background = 0;
    private boolean textView_visiable;
    private int ImageButton_background = 0;
    private Context mContext = null;
    private Calendar c;
    private int m_year;
    private int m_month;
    private int m_day;
    private int m_hour;
    private int m_minute;
    private XDEditTextButton xdetb = null;
    private int layoutHeight = -1;
    private DatePickerDialog.OnDateSetListener dateListener = new DatePickerDialog.OnDateSetListener(){

        public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
            XDDateTimeText.this.m_year = year;
            XDDateTimeText.this.m_month = monthOfYear;
            XDDateTimeText.this.m_day = dayOfMonth;
            if (XDDateTimeText.this.dateFormatStr != null && XDDateTimeText.this.dateFormatStr.equals("yyyy-MM-dd")) {
                XDDateTimeText.this.setText(year + "-" + (monthOfYear < 9 ? "0" + (monthOfYear + 1) : Integer.valueOf(monthOfYear + 1)) + "-" + (dayOfMonth < 10 ? "0" + dayOfMonth : Integer.valueOf(dayOfMonth)));
            } else if (XDDateTimeText.this.dateFormatStr != null && XDDateTimeText.this.dateFormatStr.equals("yyyy/MM/dd")) {
                XDDateTimeText.this.setText(year + "/" + (monthOfYear < 9 ? "0" + (monthOfYear + 1) : Integer.valueOf(monthOfYear + 1)) + "/" + (dayOfMonth < 10 ? "0" + dayOfMonth : Integer.valueOf(dayOfMonth)));
            } else if (XDDateTimeText.this.dateFormatStr != null && XDDateTimeText.this.dateFormatStr.equals("yyyyMMdd")) {
                XDDateTimeText.this.setText(year + "" + (monthOfYear < 9 ? "0" + (monthOfYear + 1) : Integer.valueOf(monthOfYear + 1)) + (dayOfMonth < 10 ? "0" + dayOfMonth : Integer.valueOf(dayOfMonth)));
            } else if (XDDateTimeText.this.dateFormatStr != null && XDDateTimeText.this.dateFormatStr.equals("yyMMdd")) {
                year = Integer.parseInt(("" + year).substring(2));
                XDDateTimeText.this.setText(year + "" + (monthOfYear < 9 ? "0" + (monthOfYear + 1) : Integer.valueOf(monthOfYear + 1)) + (dayOfMonth < 10 ? "0" + dayOfMonth : Integer.valueOf(dayOfMonth)));
            } else {
                XDDateTimeText.this.setText(year + "-" + (monthOfYear + 1) + "-" + dayOfMonth);
            }
        }
    };
    private TimePickerDialog.OnTimeSetListener timeListener = new TimePickerDialog.OnTimeSetListener(){

        public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
            XDDateTimeText.this.m_hour = hourOfDay;
            XDDateTimeText.this.m_minute = minute;
            if (XDDateTimeText.this.dateFormatStr != null && XDDateTimeText.this.dateFormatStr.equals("HH:mm:ss")) {
                int m_second = Calendar.getInstance().get(13);
                XDDateTimeText.this.setText("" + (XDDateTimeText.this.m_hour < 10 ? "0" + XDDateTimeText.this.m_hour : Integer.valueOf(XDDateTimeText.this.m_hour)) + ":" + (XDDateTimeText.this.m_minute < 10 ? "0" + XDDateTimeText.this.m_minute : Integer.valueOf(XDDateTimeText.this.m_minute)) + ":" + (m_second < 10 ? "0" + m_second : Integer.valueOf(m_second)));
            } else if (XDDateTimeText.this.dateFormatStr != null && XDDateTimeText.this.dateFormatStr.equals("HH:mm")) {
                XDDateTimeText.this.setText("" + (XDDateTimeText.this.m_hour < 10 ? "0" + XDDateTimeText.this.m_hour : Integer.valueOf(XDDateTimeText.this.m_hour)) + ":" + (XDDateTimeText.this.m_minute < 10 ? "0" + XDDateTimeText.this.m_minute : Integer.valueOf(XDDateTimeText.this.m_minute)));
            } else {
                XDDateTimeText.this.setText("" + XDDateTimeText.this.m_hour + ":" + XDDateTimeText.this.m_minute);
            }
        }
    };

    public XDDateTimeText(Context context) {
        super(context);
        this.mContext = context;
    }

    public XDDateTimeText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.xdetb = new XDEditTextButton(context, 1);
        if (attrs != null) {
            int attrsCount = attrs.getAttributeCount();
            for (int i = 0; i < attrsCount; ++i) {
                if (attrs.getAttributeName(i).equals("TextShowType")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.TextShowType = Integer.parseInt(attrs.getAttributeValue(i));
                    continue;
                }
                if (attrs.getAttributeName(i).equals("dateFormatStr")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.dateFormatStr = attrs.getAttributeValue(i);
                    continue;
                }
                if (attrs.getAttributeName(i).equals("dateFormat")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.dateFormat = attrs.getAttributeValue(i);
                    continue;
                }
                if (attrs.getAttributeName(i).equals("textView_text")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.textView_text = attrs.getAttributeValue(i);
                    continue;
                }
                if (attrs.getAttributeName(i).equals("buttonShowStyle")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.buttonShowStyle = Integer.parseInt(attrs.getAttributeValue(i));
                    continue;
                }
                if (attrs.getAttributeName(i).equals("textView_showStyle")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.textView_showStyle = Integer.parseInt(attrs.getAttributeValue(i));
                    continue;
                }
                if (attrs.getAttributeName(i).equals("textView_textColor")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.textView_textColor = attrs.getAttributeResourceValue(i, -1);
                    continue;
                }
                if (attrs.getAttributeName(i).equals("editText_background")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.editText_background = attrs.getAttributeResourceValue(i, -1);
                    continue;
                }
                if (attrs.getAttributeName(i).equals("textView_textSize")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.textView_textSize = attrs.getAttributeValue(i);
                    continue;
                }
                if (attrs.getAttributeName(i).equals("textView_width")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.textView_width = attrs.getAttributeValue(i);
                    continue;
                }
                if (attrs.getAttributeName(i).equals("textView_visiable")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.textView_visiable = attrs.getAttributeBooleanValue(i, false);
                    continue;
                }
                if (attrs.getAttributeName(i).equals("image")) {
                    if (attrs.getAttributeValue(i) == null) continue;
                    this.ImageButton_background = attrs.getAttributeResourceValue(i, -1);
                    continue;
                }
                if (!attrs.getAttributeName(i).equals("layout_height")) continue;
                this.layoutHeight = this.formatIntVlaue(attrs.getAttributeValue(i));
            }
        }
        this.createPlus(context);
        this.initDate();
    }

    private void createPlus(final Context context) {
        this.setTextViewAttrs(this.xdetb);
        this.xdetb.setEditText_enable(false);
        this.xdetb.setEditText_digits("0123456789/:-");
        this.xdetb.setEditText_enable(false);
        this.xdetb.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.xdetb.setButton_OnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XDDateTimeText.this.buildDateOrTimeDialog(context);
            }
        });
        this.xdetb.setControlSize(-1, this.layoutHeight);
        this.addView((View)this.xdetb, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
    }

    private void buildDateOrTimeDialog(Context context) {
        Log.i((String)"type", (String)("Type       =   " + this.dateFormat));
        if (this.dateFormat == null || this.dateFormat.equals("date")) {
            new XDDateDialog(context, 0, this.xdetb.getEditText(), null).show();
        } else if (this.dateFormat != null && this.dateFormat.equals("time")) {
            new XDDateDialog(context, 1, this.xdetb.getEditText(), "").show();
        } else if (this.dateFormat != null && this.dateFormat.equals("date_time")) {
            new XDDateDialog(context, 2, this.xdetb.getEditText(), "00").show();
        }
    }

    private void initDate() {
        this.c = Calendar.getInstance();
        this.m_year = this.c.get(1);
        this.m_month = this.c.get(2);
        this.m_day = this.c.get(5);
        this.m_hour = this.c.get(10);
        this.m_minute = this.c.get(12);
    }

    public String getText() {
        Editable str = this.xdetb.getEditText_text();
        return str.toString();
    }

    public void setText(String str) {
        this.xdetb.setEditText_text(str);
    }

    private Drawable getDrawable(Context context) {
        InputStream is = null;
        is = this.dateFormat != null && this.dateFormat.equals("time") ? context.getClass().getClassLoader().getResourceAsStream("assets/xddatetime_clock.png") : context.getClass().getClassLoader().getResourceAsStream("assets/xddatetime_clock.png");
        Drawable dra = Drawable.createFromStream((InputStream)is, (String)"9.png");
        return dra;
    }

    private void setTextViewAttrs(XDEditTextButton xdetb) {
        xdetb.setTextView_visiable(this.textView_visiable);
        if (this.textView_textSize != null && !this.textView_textSize.equals("")) {
            xdetb.setTextView_textSize(this.formatFloatVlaue(this.textView_textSize));
        }
        if (this.textView_textColor > 0) {
            xdetb.setTextView_textColor(this.textView_textColor);
        }
        switch (this.TextShowType) {
            case 0: {
                xdetb.setDisplayType(0);
                break;
            }
            case 1: {
                xdetb.setDisplayType(1);
            }
        }
        switch (this.buttonShowStyle) {
            case 0: {
                xdetb.setLayoutType(0);
                break;
            }
            case 1: {
                xdetb.setLayoutType(1);
            }
        }
        switch (this.textView_showStyle) {
            case 0: {
                xdetb.setInnerLayoutType(0);
                break;
            }
            case 1: {
                xdetb.setInnerLayoutType(1);
                break;
            }
        }
        if (this.textView_text != null) {
            xdetb.setTextView_text(this.textView_text);
        }
        if (this.textView_width != null && !this.textView_width.equals("")) {
            xdetb.setTextView_width(this.formatIntVlaue(this.textView_width + ""));
        }
        if (this.editText_background != 0) {
            xdetb.setEditText_background(this.editText_background);
        }
        if (this.ImageButton_background != 0) {
            xdetb.setImageButton_image(this.ImageButton_background);
        } else {
            xdetb.setImageButton_image(this.getDrawable(this.mContext));
        }
    }

    public XDEditText getEditText() {
        return this.xdetb.getEditText();
    }

    public ImageButton getImageButton() {
        return this.xdetb.getImageButton();
    }

    private int formatIntVlaue(String val) {
        int value = -1;
        if (val.equals("wrap_content")) {
            value = -2;
        } else if (val.equals("fill_parent")) {
            value = -1;
        } else if (val.endsWith("dp") || val.endsWith("dip")) {
            if (val.endsWith("dp")) {
                val = val.substring(0, val.length() - 2);
            } else if (val.endsWith("dip")) {
                val = val.substring(0, val.length() - 5);
            }
            try {
                value = Integer.parseInt(val);
                value = DensityUtil.dp2px(this.mContext, value);
                Log.v((String)"pxValue", (String)(value + ""));
            }
            catch (NumberFormatException ex) {
                Log.e((String)"NumberFormatException", (String)(val + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u6570"));
            }
        } else {
            if (val.endsWith("px")) {
                val = val.substring(0, val.length() - 2);
            }
            try {
                value = Integer.parseInt(val);
                Log.v((String)"pxValue", (String)(value + ""));
            }
            catch (NumberFormatException ex) {
                Log.e((String)"NumberFormatException", (String)(val + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u6570"));
                Log.v((String)"pxValue", (String)(value + ""));
            }
        }
        return value;
    }

    private float formatFloatVlaue(String val) {
        boolean isFormat = true;
        float value = 14.0f;
        if (val.endsWith("sp")) {
            val = val.substring(0, val.length() - 2);
        }
        try {
            value = Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            isFormat = false;
        }
        if (!isFormat) {
            try {
                value = Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                Log.e((String)"NumberFormatException", (String)(val + "\u4e0d\u80fd\u88ab\u8f6c\u5316\u4e3afloat\u7c7b\u578b"));
            }
        }
        return value;
    }
}

