/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.inputbutton;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import java.io.InputStream;

public class XDEditText
extends EditText {
    private int displayType = 1;
    private Drawable[] drawables_round = null;
    private Drawable[] drawables_square = null;
    private Context mContext = null;

    public int getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(int displayType) {
        this.displayType = displayType;
        this.setBackgroundByType();
    }

    public XDEditText(Context context) {
        this(context, null);
    }

    public XDEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.setSingleLine(true);
        this.initialControl(context, attrs);
    }

    private void initialControl(Context context, AttributeSet attrs) {
        String displayTypeStr = null;
        if (attrs != null) {
            int attrsCount = attrs.getAttributeCount();
            for (int i = 0; i < attrsCount; ++i) {
                if (!attrs.getAttributeName(i).equals("displaytype")) continue;
                displayTypeStr = attrs.getAttributeValue(i);
            }
        }
        if (displayTypeStr != null) {
            if (displayTypeStr.equals("0")) {
                this.displayType = 0;
            } else if (displayTypeStr.equals("1")) {
                this.displayType = 1;
            } else {
                Log.e((String)"erro", (String)"\u663e\u793a\u7c7b\u578b\u4ee3\u7801\u4e0d\u5408\u6cd5");
            }
            this.setBackgroundByType();
        }
    }

    private void setBackgroundByType() {
        switch (this.displayType) {
            case 0: {
                this.initialBackgroundByType(0);
                this.setBackgroundDrawable((Drawable)this.setBackgroundWithStateListDrawable(this.drawables_square));
                break;
            }
            case 1: {
                this.initialBackgroundByType(1);
                this.setBackgroundDrawable((Drawable)this.setBackgroundWithStateListDrawable(this.drawables_round));
                break;
            }
        }
    }

    private void initialBackgroundByType(int type) {
        if (type == 1) {
            if (this.drawables_round == null) {
                this.drawables_round = new Drawable[2];
                this.drawables_round[0] = this.getImageFromAssetsFile(this.mContext, "assets/xdedittextbutton_input_normal.9.png");
                this.drawables_round[1] = this.getImageFromAssetsFile(this.mContext, "assets/xdedittextbutton_input_fouce.9.png");
            }
        } else if (this.drawables_square == null) {
            this.drawables_square = new Drawable[2];
            this.drawables_square[0] = this.getImageFromAssetsFile(this.mContext, "assets/xdedittextbutton_input2_normal.9.png");
            this.drawables_square[1] = this.getImageFromAssetsFile(this.mContext, "assets/xdedittextbutton_input2_fouce.9.png");
        }
    }

    private StateListDrawable setBackgroundWithStateListDrawable(Drawable[] drawables) {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[1]);
        bg.addState(View.ENABLED_STATE_SET, drawables[0]);
        bg.addState(View.FOCUSED_STATE_SET, drawables[1]);
        bg.addState(View.EMPTY_STATE_SET, drawables[0]);
        return bg;
    }

    private Drawable getImageFromAssetsFile(Context context, String fileName) {
        Drawable drawable2 = null;
        try {
            InputStream stream = context.getClass().getClassLoader().getResourceAsStream(fileName);
            drawable2 = Drawable.createFromStream((InputStream)stream, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return drawable2;
    }
}

