/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.inputbutton;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.xdja.combox.inputbutton.XDEditText;
import com.xdja.combox.inputbutton.XDEditTextView;
import com.xdja.combox.utils.DensityUtil;
import java.io.InputStream;
import java.util.HashMap;

public class XDEditTextButton
extends RelativeLayout {
    private Context mContext = null;
    private int layoutWidth = -1;
    private int layoutHeight = -2;
    private int textviewWidth = -2;
    private int layoutType = 1;
    private int displayType = 1;
    private HashMap<String, Integer> attrsMap = null;
    private XDEditTextView mEditTextView = null;
    private ImageButton mButton = null;
    LinearLayout ll = null;
    private Drawable[] draws = null;

    public XDEditTextButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mEditTextView = new XDEditTextView(context, 1);
        this.mButton = new ImageButton(context);
        this.mButton.setPadding(2, 2, 2, 2);
        this.mButton.setAdjustViewBounds(false);
        this.mButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.initialAttrMap(context);
        this.analysisAttrs(this.attrsMap, attrs);
        this.intialControl(context);
    }

    private void initialAttrMap(Context context) {
        this.attrsMap = new HashMap();
        this.attrsMap.put("displaytype", 0);
        this.attrsMap.put("edittext_background", 1);
        this.attrsMap.put("textview_background", 2);
        this.attrsMap.put("textview_textcolor", 3);
        this.attrsMap.put("edittext_textcolor", 4);
        this.attrsMap.put("edittext_textsize", 5);
        this.attrsMap.put("textview_textsize", 6);
        this.attrsMap.put("textview_text", 7);
        this.attrsMap.put("edittext_text", 8);
        this.attrsMap.put("textview_visiable", 9);
        this.attrsMap.put("layouttype", 10);
        this.attrsMap.put("edittext_enable", 12);
        this.attrsMap.put("edittext_digits", 13);
        this.attrsMap.put("edittext_maxlength", 14);
        this.attrsMap.put("innerlayouttype", 15);
        this.attrsMap.put("image", 16);
        this.attrsMap.put("button_background", 17);
        this.attrsMap.put("textview_width", 18);
        this.attrsMap.put("layout_widht", 19);
        this.attrsMap.put("layout_height", 20);
    }

    private void analysisAttrs(HashMap<String, Integer> attrsMap, AttributeSet attrs) {
        int attrId = -1;
        if (attrs != null) {
            int attrsCount = attrs.getAttributeCount();
            block22: for (int i = 0; i < attrsCount; ++i) {
                if (!attrsMap.containsKey(attrs.getAttributeName(i))) continue;
                attrId = attrsMap.get(attrs.getAttributeName(i));
                switch (attrId) {
                    case 0: {
                        this.setBackgroundByType(attrs.getAttributeValue(i));
                        continue block22;
                    }
                    case 1: {
                        this.setEditText_background(attrs.getAttributeResourceValue(i, -1));
                        continue block22;
                    }
                    case 2: {
                        this.setTextView_background(attrs.getAttributeResourceValue(i, -1));
                        continue block22;
                    }
                    case 3: {
                        this.setTextView_textColor(attrs.getAttributeResourceValue(i, -1));
                        continue block22;
                    }
                    case 4: {
                        this.setEditText_textColor(attrs.getAttributeResourceValue(i, -1));
                        continue block22;
                    }
                    case 5: {
                        this.setEditText_textSize(this.formatFloatVlaue(attrs.getAttributeValue(i)));
                        continue block22;
                    }
                    case 6: {
                        this.setTextView_textSize(this.formatFloatVlaue(attrs.getAttributeValue(i)));
                        continue block22;
                    }
                    case 7: {
                        this.setTextView_text(attrs.getAttributeValue(i));
                        continue block22;
                    }
                    case 8: {
                        this.setEditText_text(attrs.getAttributeValue(i));
                        continue block22;
                    }
                    case 9: {
                        this.setTextView_visiable(attrs.getAttributeBooleanValue(i, true));
                        continue block22;
                    }
                    case 10: {
                        this.layoutType = attrs.getAttributeIntValue(i, 1);
                        continue block22;
                    }
                    case 12: {
                        this.setEditText_enable(attrs.getAttributeBooleanValue(i, true));
                        continue block22;
                    }
                    case 13: {
                        this.setEditText_digits(attrs.getAttributeValue(i));
                        continue block22;
                    }
                    case 14: {
                        this.setEditTextMaxLength(attrs.getAttributeIntValue(i, 100));
                        continue block22;
                    }
                    case 15: {
                        this.mEditTextView.setLayoutType(attrs.getAttributeIntValue(i, -1));
                        continue block22;
                    }
                    case 16: {
                        this.setImageButton_image(attrs.getAttributeResourceValue(i, -1));
                        continue block22;
                    }
                    case 17: {
                        this.setButton_background(attrs.getAttributeResourceValue(i, -1));
                        continue block22;
                    }
                    case 18: {
                        this.textviewWidth = this.formatIntVlaue(attrs.getAttributeValue(i));
                        this.mEditTextView.setTextView_width(this.textviewWidth);
                        continue block22;
                    }
                    case 19: {
                        this.layoutWidth = this.formatIntVlaue(attrs.getAttributeValue(i));
                        continue block22;
                    }
                    case 20: {
                        this.layoutHeight = this.formatIntVlaue(attrs.getAttributeValue(i));
                        continue block22;
                    }
                }
            }
        }
    }

    public void setControlSize(int width, int height) {
        this.layoutHeight = height;
        this.layoutWidth = width;
        this.intialControl(this.mContext);
    }

    private void intialControl(Context context) {
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.layoutWidth, this.layoutHeight));
        this.removeAllViews();
        this.setPadding(0, 0, 0, 0);
        this.setGravity(16);
        if (this.layoutType == 0) {
            if (this.ll != null && this.ll.getChildCount() > 0) {
                this.ll.removeAllViews();
            }
            this.ll = new LinearLayout(context);
            this.ll.setOrientation(0);
            this.ll.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.layoutHeight));
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, this.layoutHeight);
            lp.weight = 1.0f;
            this.mEditTextView.setControlSize(-1, this.layoutHeight);
            this.ll.addView((View)this.mEditTextView, (ViewGroup.LayoutParams)lp);
            LinearLayout.LayoutParams lp1 = new LinearLayout.LayoutParams(this.layoutHeight, this.layoutHeight);
            this.ll.addView((View)this.mButton, (ViewGroup.LayoutParams)lp1);
            this.addView((View)this.ll);
        } else if (this.layoutType == 1) {
            this.mEditTextView.setControlSize(-1, this.layoutHeight);
            RelativeLayout.LayoutParams edittextViewLayoutParams = new RelativeLayout.LayoutParams(-1, this.layoutHeight);
            this.addView((View)this.mEditTextView, (ViewGroup.LayoutParams)edittextViewLayoutParams);
            RelativeLayout.LayoutParams buttonLayoutParams = new RelativeLayout.LayoutParams(this.layoutHeight, this.layoutHeight);
            buttonLayoutParams.addRule(11);
            this.addView((View)this.mButton, (ViewGroup.LayoutParams)buttonLayoutParams);
        }
    }

    public int getVersion(Context context) {
        return Build.VERSION.SDK_INT;
    }

    private float formatFloatVlaue(String val) {
        boolean isFormat = true;
        float value = 14.0f;
        if (val.endsWith("sp")) {
            val = val.substring(0, val.length() - 2);
        }
        try {
            value = Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            isFormat = false;
        }
        if (!isFormat) {
            try {
                value = Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                Log.e((String)"NumberFormatException", (String)(val + "\u4e0d\u80fd\u88ab\u8f6c\u5316\u4e3afloat\u7c7b\u578b"));
            }
        }
        return value;
    }

    private int formatIntVlaue(String val) {
        int value = -1;
        if (val.equals("wrap_content")) {
            value = -2;
        } else if (val.equals("fill_parent")) {
            value = -1;
        } else if (val.endsWith("dp") || val.endsWith("dip")) {
            if (val.endsWith("dp")) {
                val = val.substring(0, val.length() - 2);
            } else if (val.endsWith("dip")) {
                val = val.substring(0, val.length() - 5);
            }
            try {
                value = Integer.parseInt(val);
                value = DensityUtil.dp2px(this.mContext, value);
                Log.v((String)"pxValue", (String)(value + ""));
            }
            catch (NumberFormatException ex) {
                Log.e((String)"NumberFormatException", (String)(val + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u6570"));
            }
        } else {
            if (val.endsWith("px")) {
                val = val.substring(0, val.length() - 2);
            }
            try {
                value = Integer.parseInt(val);
                Log.v((String)"pxValue", (String)(value + ""));
            }
            catch (NumberFormatException ex) {
                Log.e((String)"NumberFormatException", (String)(val + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u6570"));
                Log.v((String)"pxValue", (String)(value + ""));
            }
        }
        return value;
    }

    private void setBackgroundByType(String typeStr) {
        if (typeStr != null) {
            if (typeStr.equals("0")) {
                this.displayType = 0;
            } else if (typeStr.equals("1")) {
                this.displayType = 1;
            }
        }
        this.setDisplayType(this.displayType);
    }

    private static Drawable getImageFromAssetsFile(Context context, String fileName) {
        Drawable drawable2 = null;
        try {
            InputStream stream = context.getClass().getClassLoader().getResourceAsStream(fileName);
            drawable2 = Drawable.createFromStream((InputStream)stream, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return drawable2;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int bottom) {
        super.onLayout(changed, l, t, r, bottom);
        if (this.layoutType == 1) {
            this.mEditTextView.setEditText_PaddingRight(this.layoutHeight);
        }
    }

    public void setInnerLayoutType(int type) {
        this.mEditTextView.setLayoutType(type);
    }

    public void setEditTextMaxLength(int maxLength) {
        this.mEditTextView.setEditText_maxLength(maxLength);
    }

    public XDEditTextButton(Context context, int displayType) {
        this(context, null);
        this.setDisplayType(displayType);
    }

    public void setButton_background(int resid) {
        if (resid > 0) {
            this.mButton.setBackgroundResource(resid);
        }
    }

    public int getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(int layoutType) {
        this.layoutType = layoutType;
        this.intialControl(this.mContext);
    }

    public void setTextView_visiable(boolean visiable) {
        this.mEditTextView.setTextView_visiable(visiable);
    }

    public Editable getEditText_text() {
        return this.mEditTextView.getEditText_text();
    }

    public void setEditText_text(String mEditText_text) {
        this.mEditTextView.setEditText_text(mEditText_text);
    }

    public CharSequence getTextView_text() {
        return this.mEditTextView.getTextView_text();
    }

    public void setTextView_text(String mTextView_text) {
        this.mEditTextView.setTextView_text(mTextView_text);
    }

    public float getTextView_textSize() {
        return this.mEditTextView.getTextView_textSize();
    }

    public void setTextView_textSize(float mTextView_textSize) {
        this.mEditTextView.setTextView_textSize(mTextView_textSize);
    }

    public float getEditText_textSize() {
        return this.mEditTextView.getEditText_textSize();
    }

    public void setEditText_textSize(float mEditText_textSize) {
        this.mEditTextView.setEditText_textSize(mEditText_textSize);
    }

    public void setEditText_textColor(int mEditText_textColor) {
        this.mEditTextView.setEditText_textColor(mEditText_textColor);
    }

    public void setTextView_textColor(int resourceId) {
        boolean isFormat = true;
        if (resourceId > 0) {
            try {
                this.mEditTextView.setTextView_textColor(this.getContext().getResources().getColor(resourceId));
            }
            catch (Exception ex) {
                isFormat = false;
            }
        }
        if (!isFormat) {
            try {
                this.setTextView_textColor(resourceId);
            }
            catch (Exception e) {
                Log.e((String)"\u9519\u8bef\u7684\u989c\u8272\u503c", (String)(resourceId + "\u4e3a\u9519\u8bef\u7684\u989c\u8272\u503c"));
            }
        }
    }

    public Drawable getTextView_background() {
        return this.mEditTextView.getTextView_background();
    }

    public void setTextView_background(int resid) {
        this.mEditTextView.setTextView_background(resid);
    }

    public Drawable getEditText_background() {
        return this.mEditTextView.getEditText_background();
    }

    public void setEditText_background(int resid) {
        this.mEditTextView.setEditText_background(resid);
    }

    public int getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(int type) {
        this.displayType = type;
        this.mEditTextView.setDisplayType(type);
        if (this.draws == null) {
            this.draws = new Drawable[2];
        }
        if (type == 1) {
            this.draws[0] = XDEditTextButton.getImageFromAssetsFile(this.mContext, "assets/xdedittextbutton_btn_img.9.png");
            this.draws[1] = XDEditTextButton.getImageFromAssetsFile(this.mContext, "assets/xdedittextbutton_btn_img_pressed.9.png");
            this.mButton.setBackgroundDrawable((Drawable)this.setBackgroundWithStateListDrawable(this.draws));
        } else if (type == 0) {
            this.draws[0] = XDEditTextButton.getImageFromAssetsFile(this.mContext, "assets/xdedittextbutton_btn2_img.9.png");
            this.draws[1] = XDEditTextButton.getImageFromAssetsFile(this.mContext, "assets/xdedittextbutton_btn2_img_pressed.9.png");
            this.mButton.setBackgroundDrawable((Drawable)this.setBackgroundWithStateListDrawable(this.draws));
        }
    }

    private StateListDrawable setBackgroundWithStateListDrawable(Drawable[] drawables) {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(View.PRESSED_ENABLED_STATE_SET, drawables[1]);
        bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[1]);
        bg.addState(View.ENABLED_STATE_SET, drawables[0]);
        bg.addState(View.FOCUSED_STATE_SET, drawables[1]);
        bg.addState(View.EMPTY_STATE_SET, drawables[0]);
        return bg;
    }

    public void setEditText_enable(boolean enable) {
        this.mEditTextView.setEditText_enable(enable);
    }

    public void setEditText_digits(String digits) {
        this.mEditTextView.setEditText_digits(digits);
    }

    public void setEditText_maxLength(int maxLength) {
        this.mEditTextView.setEditText_maxLength(maxLength);
    }

    public void setImageButton_image(Bitmap bm) {
        this.mButton.setImageBitmap(bm);
    }

    public void setImageButton_image(Drawable drawable2) {
        this.mButton.setImageDrawable(drawable2);
    }

    public void setImageButton_image(int resId) {
        this.mButton.setImageResource(resId);
        this.mButton.setPadding(2, 2, 2, 2);
    }

    public void setTextView_width(int width) {
        this.mEditTextView.setTextView_width(width);
    }

    public XDEditText getEditText() {
        return this.mEditTextView.getEditText();
    }

    public ImageButton getImageButton() {
        return this.mButton;
    }

    public void addEditText_TextChangedListener(TextWatcher watcher) {
        this.mEditTextView.addEditText_TextChangedListener(watcher);
    }

    public void setEditText_OnClickListener(View.OnClickListener l) {
        this.mEditTextView.setEditText_OnClickListener(l);
    }

    public void setEditText_OnTouchListener(View.OnTouchListener l) {
        this.mEditTextView.setEditText_OnTouchListener(l);
    }

    public void setEditText_OnLongClickListener(View.OnLongClickListener l) {
        this.mEditTextView.setEditText_OnLongClickListener(l);
    }

    public void setEditText_OnCreateContextMenuListener(View.OnCreateContextMenuListener l) {
        this.mEditTextView.setEditText_OnCreateContextMenuListener(l);
    }

    public void setEditText_OnFocusChangeListener(View.OnFocusChangeListener l) {
        this.mEditTextView.setEditText_OnFocusChangeListener(l);
    }

    public void setEditText_OnKeyListener(View.OnKeyListener l) {
        this.mEditTextView.setEditText_OnKeyListener(l);
    }

    public void setButton_OnClickListener(View.OnClickListener l) {
        this.mButton.setOnClickListener(l);
    }
}

