/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.menu;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class XDMenuDialog
extends AlertDialog {
    private GridView mGridView = null;
    private Context nContext = null;
    private int item_img = 1;
    private int item_textview = 2;
    private int item_text = 3;
    private int item_menu = 4;
    private List<String> text = null;
    private List<Bitmap> icon = null;
    private List<String> number = null;
    private LinearLayout llayout = null;
    private RelativeLayout rlayout = null;
    private ImageView mImageView = null;
    private TextView mTextView = null;
    private TextView mText = null;
    WindowManager.LayoutParams lp;
    private int maxColumnCount = 4;

    protected XDMenuDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        this.nContext = context;
        this.mGridView = new GridView(context);
    }

    public XDMenuDialog(Context context) {
        this(context, true, null);
    }

    public void showMenu() {
        this.setView((View)this.mGridView);
        this.lp = this.getWindow().getAttributes();
        WindowManager wm = (WindowManager)this.nContext.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        if (display.getHeight() > display.getWidth()) {
            this.lp.width = display.getWidth();
            Log.i((String)"lpwith", (String)(this.lp.width + "---" + display.getHeight()));
        } else {
            this.lp.width = (int)((double)display.getWidth() * 0.5);
            Log.i((String)"lpwith", (String)(this.lp.width + ""));
        }
        this.lp.gravity = 83;
        this.lp.x = 0;
        this.lp.y = 0;
        this.getWindow().setAttributes(this.lp);
        this.show();
    }

    public void initialMenuData(Context context, List<String> text, List<Integer> resList, List<String> number) {
        this.setMenuText(text);
        this.setMenuIcon(resList);
        this.setMenuNum(number);
        this.initialMenu(context);
    }

    public void initialMenu(Context context) {
        GirdViewAdapter madapter;
        if (this.text.size() == this.icon.size() && this.icon.size() == this.number.size() && this.text.size() != 0) {
            madapter = new GirdViewAdapter(this.nContext, this.text, this.icon, this.number);
            this.mGridView.setAdapter((ListAdapter)madapter);
            if (this.maxColumnCount >= this.text.size()) {
                this.mGridView.setNumColumns(this.text.size());
            } else {
                this.mGridView.setNumColumns(this.maxColumnCount);
            }
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u6570\u636e\u6e90\u6709\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (int)0).show();
            return;
        }
        madapter.notifyDataSetChanged();
    }

    public void setMenuText(List<String> text) {
        this.text = text;
    }

    public void setMenuIcon(List<Integer> resList) {
        if (resList.size() > 0) {
            this.icon = new ArrayList<Bitmap>();
            Bitmap bm = null;
            for (int i = 0; i < resList.size(); ++i) {
                bm = this.getResourceBitmap(resList.get(i));
                if (bm == null) continue;
                this.icon.add(bm);
            }
        }
    }

    public Bitmap getResourceBitmap(int id2) {
        Bitmap bmp = null;
        try {
            Resources res = this.nContext.getResources();
            bmp = BitmapFactory.decodeResource((Resources)res, (int)id2);
        }
        catch (Resources.NotFoundException e) {
            Log.e((String)"SourceNotFound", (String)("id\u4e3a" + id2 + "\u7684\u8d44\u6e90\u672a\u627e\u5230"));
        }
        return bmp;
    }

    public void setMenuNum(List<String> number) {
        this.number = number;
    }

    public int getMaxColumnCount() {
        return this.maxColumnCount;
    }

    public void setMaxColumnCount(int maxColumnCount) {
        this.maxColumnCount = maxColumnCount;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener l) {
        this.mGridView.setOnItemClickListener(l);
    }

    private LinearLayout initialMenuItem(Context context) {
        this.llayout = new LinearLayout(context);
        this.llayout.setOrientation(1);
        this.llayout.setPadding(10, 10, 10, 10);
        this.llayout.setGravity(1);
        this.rlayout = new RelativeLayout(context);
        this.rlayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.rlayout.setGravity(17);
        this.rlayout.setId(this.item_menu);
        this.mImageView = new ImageView(context);
        this.mImageView.setAdjustViewBounds(true);
        LinearLayout.LayoutParams imglayoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.mImageView.setId(this.item_img);
        this.rlayout.addView((View)this.mImageView, (ViewGroup.LayoutParams)imglayoutParams);
        this.mTextView = new TextView(context);
        this.mTextView.setBackgroundDrawable(XDMenuDialog.getImageFromAssetsFile(context, "assets/xdmenudialog_redround.png"));
        this.mTextView.setGravity(17);
        RelativeLayout.LayoutParams mtextviewlayoutParams = new RelativeLayout.LayoutParams(20, 20);
        mtextviewlayoutParams.addRule(10);
        mtextviewlayoutParams.addRule(7, this.item_img);
        this.mTextView.setId(this.item_textview);
        this.rlayout.addView((View)this.mTextView, (ViewGroup.LayoutParams)mtextviewlayoutParams);
        this.llayout.addView((View)this.rlayout);
        ViewGroup.MarginLayoutParams mp = (ViewGroup.MarginLayoutParams)this.mTextView.getLayoutParams();
        mp.rightMargin = -10;
        this.mText = new TextView(context);
        this.mText.setGravity(17);
        LinearLayout.LayoutParams mtextlayoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.mText.setId(this.item_text);
        this.llayout.addView((View)this.mText, (ViewGroup.LayoutParams)mtextlayoutParams);
        return this.llayout;
    }

    private static Drawable getImageFromAssetsFile(Context context, String fileName) {
        Drawable drawable2 = null;
        try {
            InputStream stream = context.getClass().getClassLoader().getResourceAsStream(fileName);
            drawable2 = Drawable.createFromStream((InputStream)stream, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return drawable2;
    }

    public class GirdViewAdapter
    extends BaseAdapter {
        private Context mContext;
        private List<String> text = null;
        private List<Bitmap> icon = null;
        private List<String> numberstr = null;

        public GirdViewAdapter(Context context, List<String> _text, List<Bitmap> _icon, List<String> _number) {
            if (_text.size() != _icon.size() || _icon.size() != _number.size()) {
                Toast.makeText((Context)context, (CharSequence)"\u6570\u636e\u6e90\u6709\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (int)0).show();
                return;
            }
            this.mContext = context;
            this.text = _text;
            this.icon = _icon;
            this.numberstr = _number;
        }

        public int getCount() {
            return this.text.size();
        }

        public Object getItem(int position) {
            return position;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            LinearLayout lly = XDMenuDialog.this.initialMenuItem(this.mContext);
            XDMenuDialog.this.mImageView.setImageBitmap(this.icon.get(position));
            if (this.numberstr.get(position).equals("0")) {
                XDMenuDialog.this.mTextView.setVisibility(8);
            } else {
                XDMenuDialog.this.mTextView.setText((CharSequence)this.numberstr.get(position));
            }
            XDMenuDialog.this.mText.setText((CharSequence)this.text.get(position).toString());
            return lly;
        }
    }
}

