/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.treeview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xdja.combox.treeview.OnLeafClickListener;
import com.xdja.combox.treeview.TreeElementBean;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class TreeViewAdapter
extends ArrayAdapter {
    private Bitmap collapse;
    private Bitmap expand;
    private Context context;
    private float mTextSize = -1.0f;
    private int mTextColor = -1;
    private ArrayList<TreeElementBean> rootEleList = new ArrayList();

    public Bitmap getCollapse() {
        return this.collapse;
    }

    public void setCollapse(Bitmap collapse) {
        this.collapse = collapse;
    }

    public Bitmap getExpand() {
        return this.expand;
    }

    public void setExpand(Bitmap expand) {
        this.expand = expand;
    }

    public float getmTextSize() {
        return this.mTextSize;
    }

    public void setmTextSize(float mTextSize) {
        this.mTextSize = mTextSize;
    }

    public int getmTextColor() {
        return this.mTextColor;
    }

    public void setmTextColor(int mTextColor) {
        this.mTextColor = mTextColor;
    }

    public TreeViewAdapter(Context context, int textViewResourceId, List<TreeElementBean> list) {
        super(context, textViewResourceId, list);
        for (TreeElementBean element : list) {
            int level = element.getLevel();
            if (level != 0) continue;
            this.rootEleList.add(element);
        }
        this.context = context;
        try {
            InputStream stream_collapse = context.getAssets().open("collapse.png");
            this.collapse = BitmapFactory.decodeStream((InputStream)stream_collapse);
            InputStream stream_expand = context.getAssets().open("expand.png");
            this.expand = BitmapFactory.decodeStream((InputStream)stream_expand);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getCount() {
        return this.rootEleList.size();
    }

    public Object getItem(int position) {
        return this.rootEleList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        LinearLayout ly = new LinearLayout(this.context);
        ly.setOrientation(0);
        ly.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        ly.setGravity(16);
        TextView text = new TextView(this.context);
        if (this.mTextColor != -1) {
            text.setTextColor(this.mTextColor);
        }
        if (this.mTextSize != -1.0f) {
            text.setTextSize(this.mTextSize);
        }
        text.setSingleLine(true);
        ImageView icon = new ImageView(this.context);
        LinearLayout.LayoutParams lyParams = new LinearLayout.LayoutParams(-2, -2);
        ly.addView((View)icon, (ViewGroup.LayoutParams)lyParams);
        ly.addView((View)text, (ViewGroup.LayoutParams)lyParams);
        ViewGroup.MarginLayoutParams mp = (ViewGroup.MarginLayoutParams)icon.getLayoutParams();
        mp.rightMargin = 6;
        int level = this.rootEleList.get(position).getLevel();
        icon.setPadding(15 * (level + 1), icon.getPaddingTop(), 0, icon.getPaddingBottom());
        text.setText((CharSequence)this.rootEleList.get(position).getNodeName());
        if (this.rootEleList.get(position).isHasChild() && !this.rootEleList.get(position).isExpanded()) {
            icon.setImageBitmap(this.collapse);
        } else if (this.rootEleList.get(position).isHasChild() && this.rootEleList.get(position).isExpanded()) {
            icon.setImageBitmap(this.expand);
        } else if (!this.rootEleList.get(position).isHasChild()) {
            icon.setImageBitmap(this.collapse);
            icon.setVisibility(4);
        }
        return ly;
    }

    public void onClick(int position, ArrayList<TreeElementBean> subNodeList, TreeViewAdapter treeViewAdapter, OnLeafClickListener onLeafClickListener) {
        if (subNodeList == null || treeViewAdapter == null) {
            return;
        }
        if (!this.rootEleList.get(position).isHasChild()) {
            if (onLeafClickListener == null) {
                return;
            }
            onLeafClickListener.setOnLeafClick();
        }
        if (this.rootEleList.get(position).isExpanded()) {
            this.rootEleList.get(position).setExpanded(false);
            TreeElementBean element = this.rootEleList.get(position);
            ArrayList<TreeElementBean> temp = new ArrayList<TreeElementBean>();
            for (int i = position + 1; i < this.rootEleList.size() && element.getLevel() < this.rootEleList.get(i).getLevel(); ++i) {
                temp.add(this.rootEleList.get(i));
            }
            this.rootEleList.removeAll(temp);
            treeViewAdapter.notifyDataSetChanged();
        } else {
            this.rootEleList.get(position).setExpanded(true);
            for (TreeElementBean element : subNodeList) {
                int j = 1;
                if (element.getUpNodeId() != this.rootEleList.get(position).getId()) continue;
                element.setExpanded(false);
                this.rootEleList.add(position + j, element);
                ++j;
            }
            treeViewAdapter.notifyDataSetChanged();
        }
    }
}

