/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwt.location;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.founder.location.FounderLocationClient;
import com.founder.location.FounderLocationClientOption;
import com.founder.location.FounderLocationListener;
import com.founder.location.entity.FounderLocation;
import com.xdja.jwt.location.LocationConfig;
import com.xdja.jwt.location.LocationConstant;
import com.xdja.jwt.location.data.XdjaLocation;
import com.xdja.jwt.location.thread.Platform;
import com.xdja.jwt.location.utils.ServiceUtil;
import com.xdja.jwt.location.utils.SharePrefUtil;
import com.xdja.publicclass.SocketManager;
import java.io.Serializable;

public class LocationUploadService
extends Service
implements FounderLocationListener {
    private static final String TAG = LocationUploadService.class.getName();
    private FounderLocationClient locationClient;
    private FounderLocationClientOption option;
    private XdjaLocation gpsLoaction;
    private int count = 0;
    private static final int LOOP_MESSAGE_TYPE_NORMAL = 0;
    private static final int LOOP_MESSAGE_TYPE_START = 1;
    private static final int LOOP_MESSAGE_TYPE_STOP = -1;
    private boolean isLoopStop = false;
    private LocationConfig config;
    private SocketManager socketManagerCMCC;
    private SocketManager socketManagerUNICOME;
    private Handler loopHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: 
                case 1: {
                    LocationUploadService.this.upload();
                    break;
                }
                case -1: {
                    LocationUploadService.this.stopSelf();
                    break;
                }
            }
        }
    };

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (null == intent || !intent.hasExtra("tag")) {
            return super.onStartCommand(intent, flags, startId);
        }
        String tag = intent.getStringExtra("tag");
        if ("start".equals(tag)) {
            if (this.locationClient == null) {
                if (this.getLocationConfig()) {
                    this.isLoopStop = false;
                    this.initLocationClient();
                    this.loopHandler.sendEmptyMessage(1);
                } else {
                    Log.e((String)TAG, (String)"start  --->  user id \u83b7\u53d6\u5931\u8d25");
                }
            }
        } else if ("stop".equals(tag)) {
            this.isLoopStop = true;
            this.loopHandler.sendEmptyMessage(-1);
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private void upload() {
        Platform.get().execute(new Runnable(){

            @Override
            public void run() {
                if (LocationUploadService.this.isLoopStop) {
                    return;
                }
                try {
                    String reqString = "";
                    if (LocationUploadService.this.gpsLoaction != null && LocationUploadService.this.gpsLoaction.getLongitude() > 0.0 && LocationUploadService.this.gpsLoaction.getLatitude() > 0.0) {
                        reqString = ServiceUtil.uploadGPSMsg(LocationUploadService.this.getApplicationContext(), LocationUploadService.this.gpsLoaction);
                    }
                    if (!TextUtils.isEmpty((CharSequence)reqString)) {
                        SocketManager cs;
                        if ("\u4e2d\u56fd\u79fb\u52a8".equals(ServiceUtil.getProvider(LocationUploadService.this.getApplicationContext()))) {
                            if (LocationUploadService.this.socketManagerCMCC == null) {
                                LocationUploadService.this.socketManagerCMCC = new SocketManager(0, LocationUploadService.this.config.getCMCCIp(), LocationUploadService.this.config.getCMCCPort());
                            }
                            cs = LocationUploadService.this.socketManagerCMCC;
                        } else {
                            if (LocationUploadService.this.socketManagerUNICOME == null) {
                                LocationUploadService.this.socketManagerUNICOME = new SocketManager(0, LocationUploadService.this.config.getUNICOMEIp(), LocationUploadService.this.config.getCMCCPort());
                            }
                            cs = LocationUploadService.this.socketManagerUNICOME;
                        }
                        String retMsg = cs.execute(reqString);
                        if (retMsg.substring(0, 2).equals("00")) {
                            String[] uploadInfo = retMsg.split("\\|");
                            String timeString = uploadInfo[1];
                            LocationUploadService.this.count++;
                            Intent intent = new Intent();
                            intent.setPackage(LocationUploadService.this.getPackageName());
                            intent.setAction("com.xdja.jwt.location.upload");
                            intent.putExtra("location_upload_count", LocationUploadService.this.count);
                            intent.putExtra("location_upload_time", uploadInfo[2]);
                            intent.putExtra("location_data", (Serializable)LocationUploadService.this.gpsLoaction);
                            LocationUploadService.this.sendBroadcast(intent);
                        } else {
                            Log.e((String)TAG, (String)("\u4e0a\u62a5\u5931\u8d25 ---> " + retMsg));
                        }
                        cs = null;
                        ServiceUtil.writeToSDCard(ServiceUtil.GPS_LOG_PATH, "sendMsg  =" + reqString + System.getProperty("line.separator") + "regMsg =" + retMsg, true);
                    } else {
                        Log.e((String)TAG, (String)"\u672a\u83b7\u53d6\u5230\u4f4d\u7f6e\u4fe1\u606f");
                        ServiceUtil.writeToSDCard(ServiceUtil.GPS_LOG_PATH, "\u672a\u83b7\u53d6\u5230\u4f4d\u7f6e\u4fe1\u606f", true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.e((String)TAG, (String)("Exception ---> " + e.toString()));
                }
                if (!LocationUploadService.this.isLoopStop) {
                    LocationUploadService.this.loopHandler.sendEmptyMessageDelayed(0, (long)LocationUploadService.this.config.getUploadLoopTime());
                }
            }
        });
    }

    private void initLocationClient() {
        this.locationClient = new FounderLocationClient(this.getApplicationContext());
        this.option = new FounderLocationClientOption();
        this.option.setLBSServerUrl("http://" + this.config.getLbsServerIp() + ":" + this.config.getLbsServerPort() + "/lbsServer/");
        this.option.setRectify(false);
        this.option.setScanSpan(3000);
        this.option.setShare(false);
        this.option.setSource(5);
        this.locationClient.setLocOption(this.option);
        this.locationClient.registerListener((FounderLocationListener)this);
        this.locationClient.start();
    }

    public void onReceiveLocation(FounderLocation founderLocation) {
        if (founderLocation == null) {
            this.gpsLoaction = null;
            return;
        }
        String locationtype = "";
        switch (founderLocation.getDescribe()) {
            case 10: 
            case 11: {
                this.gpsLoaction = null;
                return;
            }
            case 2: 
            case 12: {
                locationtype = "\u57fa\u7ad9\u5b9a\u4f4d";
                break;
            }
            case 0: {
                locationtype = "GPS\u5b9a\u4f4d";
                break;
            }
            case 1: {
                locationtype = "WIFI\u5b9a\u4f4d";
                break;
            }
            default: {
                locationtype = "";
                return;
            }
        }
        double lon = founderLocation.getLongitude();
        double lat = founderLocation.getLatitude();
        long locTime = founderLocation.getLocTime();
        float speed = founderLocation.getSpeed();
        double altitude = founderLocation.getElev();
        String addrDesc = founderLocation.getAddress();
        float bearing = founderLocation.getDir();
        if (this.gpsLoaction == null) {
            this.gpsLoaction = new XdjaLocation();
        }
        this.gpsLoaction.setLatitude(lat);
        this.gpsLoaction.setLongitude(lon);
        this.gpsLoaction.setTime(locTime);
        this.gpsLoaction.setSpeed(speed);
        this.gpsLoaction.setAltitude(altitude);
        this.gpsLoaction.setAddrDesc(addrDesc);
        this.gpsLoaction.setBearing(bearing);
        this.gpsLoaction.setLocationType(locationtype);
        ServiceUtil.writeToSDCard(ServiceUtil.LOCATION_LOG_PATH, "Describe: " + founderLocation.getDescribe() + " \u5b9a\u4f4d\u65b9\u5f0f:  " + locationtype + " lon: " + lon + " lat: " + lat + System.getProperty("line.separator"), true);
    }

    public void onDestroy() {
        super.onDestroy();
        this.recyleLocation();
        this.isLoopStop = true;
        this.gpsLoaction = null;
        this.socketManagerCMCC = null;
        this.socketManagerUNICOME = null;
    }

    private void recyleLocation() {
        if (this.locationClient != null) {
            this.locationClient.stop();
            this.locationClient.unRegisterListener((FounderLocationListener)this);
            this.locationClient = null;
            this.option = null;
        }
    }

    public static void startService() {
        Intent starter = new Intent(LocationConstant.getContext(), LocationUploadService.class);
        starter.putExtra("tag", "start");
        LocationConstant.getContext().startService(starter);
    }

    public static void stopService() {
        Intent stoper = new Intent(LocationConstant.getContext(), LocationUploadService.class);
        stoper.putExtra("tag", "stop");
        LocationConstant.getContext().startService(stoper);
    }

    public static void initLocationConfig(Context context, LocationConfig config) {
        if (context == null) {
            throw new IllegalArgumentException("context can't be NULL");
        }
        LocationConstant.initContext(context);
        if (config != null) {
            SharePrefUtil spUtil = SharePrefUtil.getSpUtil(context);
            if (TextUtils.isEmpty((CharSequence)config.getUserId())) {
                Log.e((String)TAG, (String)"initLocationConfig ---> \u6ca1\u6709\u7528\u6237ID\u662f\u4e0d\u884c\u7684^_^");
                return;
            }
            spUtil.saveString("user_id", config.getUserId());
            spUtil.saveInt("loop_upload_time", config.getUploadLoopTime());
            if (!TextUtils.isEmpty((CharSequence)config.getLbsServerIp())) {
                spUtil.saveString("lbs_server_ip", config.getLbsServerIp());
            }
            if (!TextUtils.isEmpty((CharSequence)config.getLbsServerPort())) {
                spUtil.saveString("lbs_server_port", config.getLbsServerPort());
            }
            if (!TextUtils.isEmpty((CharSequence)config.getCMCCIp())) {
                spUtil.saveString("cmcc_ip", config.getCMCCIp());
            }
            if (!TextUtils.isEmpty((CharSequence)config.getUNICOMEIp())) {
                spUtil.saveString("unicome_ip", config.getUNICOMEIp());
            }
            if (!TextUtils.isEmpty((CharSequence)config.getCMCCPort())) {
                spUtil.saveString("cmcc_port", config.getCMCCPort());
            }
            if (!TextUtils.isEmpty((CharSequence)config.getUNICOMEPort())) {
                spUtil.saveString("unicome_port", config.getUNICOMEPort());
            }
        }
    }

    private boolean getLocationConfig() {
        SharePrefUtil spUtil = SharePrefUtil.getSpUtil(this.getApplicationContext());
        if (TextUtils.isEmpty((CharSequence)spUtil.getString("user_id", ""))) {
            return false;
        }
        this.config = new LocationConfig();
        this.config.setUserId(spUtil.getString("user_id", ""));
        this.config.setUploadLoopTime(spUtil.getInt("loop_upload_time", this.config.getUploadLoopTime()));
        this.config.setLbsServerIp(spUtil.getString("lbs_server_ip", this.config.getLbsServerIp()));
        this.config.setLbsServerPort(spUtil.getString("lbs_server_port", this.config.getLbsServerPort()));
        this.config.setCMCCIp(spUtil.getString("cmcc_ip", this.config.getCMCCIp()));
        this.config.setCMCCPort(spUtil.getString("cmcc_port", this.config.getCMCCPort()));
        this.config.setUNICOMEIp(spUtil.getString("cmcc_port", this.config.getUNICOMEIp()));
        this.config.setUNICOMEPort(spUtil.getString("unicome_port", this.config.getUNICOMEPort()));
        return true;
    }
}

