/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwt.location.thread;

import android.os.Build;
import android.util.Log;
import com.xdja.jwt.location.thread.HandleThreadPool;
import java.util.concurrent.Executor;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    private Executor defaultExecutor = null;

    public static Platform get() {
        Log.v((String)"Platform", (String)PLATFORM.getClass().toString());
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new Platform();
    }

    public Executor defaultCallbackExecutor() {
        if (this.defaultExecutor == null) {
            this.defaultExecutor = new HandleThreadPool().getExecutor();
        }
        return this.defaultExecutor;
    }

    public Object execute(Runnable runnable) {
        this.defaultCallbackExecutor().execute(runnable);
        return null;
    }

    static class Android
    extends Platform {
        Android() {
        }

        @Override
        public Executor defaultCallbackExecutor() {
            return new HandleThreadPool().getExecutor();
        }
    }
}

