/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwt.location.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetUtil {
    public static boolean isWifi(Context mContext) {
        ConnectivityManager connectivityManager = (ConnectivityManager)mContext.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 1;
    }

    public static boolean isNetworkAvailable(Context context) {
        NetworkInfo[] info;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm != null && (info = cm.getAllNetworkInfo()) != null) {
            for (int i = 0; i < info.length; ++i) {
                if (info[i].getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean is3G(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkINfo = cm.getActiveNetworkInfo();
        return networkINfo != null && networkINfo.getType() == 0;
    }

    public static NetState isConnected(Context context) {
        NetState stateCode = NetState.NET_NO;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni != null && ni.isConnectedOrConnecting()) {
            block0 : switch (ni.getType()) {
                case 1: {
                    stateCode = NetState.NET_WIFI;
                    break;
                }
                case 0: {
                    switch (ni.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: {
                            stateCode = NetState.NET_2G;
                            break block0;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            stateCode = NetState.NET_3G;
                            break block0;
                        }
                        case 13: {
                            stateCode = NetState.NET_4G;
                            break block0;
                        }
                    }
                    stateCode = NetState.NET_UNKNOWN;
                    break;
                }
                default: {
                    stateCode = NetState.NET_UNKNOWN;
                }
            }
        }
        return stateCode;
    }

    public static enum NetState {
        NET_NO,
        NET_2G,
        NET_3G,
        NET_4G,
        NET_WIFI,
        NET_UNKNOWN;

    }
}

