/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwt.location.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.Log;
import com.xdja.jwt.location.data.CommunityLocation;
import com.xdja.jwt.location.data.XdjaLocation;
import com.xdja.jwt.location.utils.NetUtil;
import com.xdja.jwt.location.utils.SharePrefUtil;
import com.xdja.publicclass.VPNSocket;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class ServiceUtil {
    public static final String GPS_LOG_PATH = Environment.getExternalStorageDirectory().getPath() + "/ksch_GPSlog.txt";
    public static final String LOCATION_LOG_PATH = Environment.getExternalStorageDirectory().getPath() + "/location.txt";

    public static boolean isServiceRunning(Context mContext, String className) {
        boolean isRunning = false;
        ActivityManager activityManager = (ActivityManager)mContext.getSystemService("activity");
        List serviceList = activityManager.getRunningServices(100);
        if (serviceList.size() <= 0) {
            return false;
        }
        for (int i = 0; i < serviceList.size(); ++i) {
            Log.i((String)"RUN_SERVICE_TAG", (String)((ActivityManager.RunningServiceInfo)serviceList.get((int)i)).service.getClassName());
            if (!((ActivityManager.RunningServiceInfo)serviceList.get((int)i)).service.getClassName().equals(className)) continue;
            isRunning = true;
            break;
        }
        Log.i((String)"TAG", (String)("isRunning = " + isRunning));
        return isRunning;
    }

    public static String getNowDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        return sdf.format(date);
    }

    public static void writeToSDCard(String fileName, String data, boolean isappend) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(file, isappend);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                BufferedWriter bfw = new BufferedWriter(osw);
                if (isappend) {
                    data = "*************" + System.getProperty("line.separator") + ServiceUtil.getNowDateTime() + "  " + data + System.getProperty("line.separator");
                }
                bfw.write(data);
                bfw.flush();
                bfw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getProvider(Context context) {
        String provider = "\u672a\u77e5";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String IMSI = telephonyManager.getSubscriberId();
            Log.v((String)"tag", (String)("getProvider.IMSI:" + IMSI));
            if (IMSI == null) {
                if (5 == telephonyManager.getSimState()) {
                    String operator = telephonyManager.getSimOperator();
                    Log.v((String)"tag", (String)("getProvider.operator:" + operator));
                    if (operator != null) {
                        if (operator.equals("46000") || operator.equals("46002") || operator.equals("46007")) {
                            provider = "\u4e2d\u56fd\u79fb\u52a8";
                        } else if (operator.equals("46001")) {
                            provider = "\u4e2d\u56fd\u8054\u901a";
                        } else if (operator.equals("46003")) {
                            provider = "\u4e2d\u56fd\u7535\u4fe1";
                        }
                    }
                }
            } else if (IMSI.startsWith("46000") || IMSI.startsWith("46002") || IMSI.startsWith("46007")) {
                provider = "\u4e2d\u56fd\u79fb\u52a8";
            } else if (IMSI.startsWith("46001")) {
                provider = "\u4e2d\u56fd\u8054\u901a";
            } else if (IMSI.startsWith("46003")) {
                provider = "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return provider;
    }

    public static String uploadXqmsg(Context context, CommunityLocation location) {
        SharePrefUtil spUtil = SharePrefUtil.getSpUtil(context);
        StringBuffer msg = new StringBuffer();
        StringBuffer reqstr = new StringBuffer();
        msg.append("LOC###");
        msg.append(spUtil.getString("user_id", ""));
        msg.append("###");
        msg.append(location.sqh.trim());
        msg.append("###");
        msg.append(location.quid.trim());
        msg.append("###");
        msg.append(location.xhqd.trim());
        msg.append("###");
        msg.append(location.netType);
        msg.append("###");
        msg.append(ServiceUtil.getProvider(context));
        msg.append("!");
        reqstr.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        reqstr.append("<Root>");
        reqstr.append("<Version>20071115</Version>");
        reqstr.append("<ReqType>gps_logxxlr</ReqType>");
        reqstr.append("<Data>");
        reqstr.append("<c_jh>" + spUtil.getString("user_id", "") + "</c_jh>");
        reqstr.append("<c_gps></c_gps>");
        reqstr.append("<c_xqdw>" + msg.toString() + "</c_xqdw>");
        reqstr.append("</Data>");
        reqstr.append("</Root>");
        return reqstr.toString();
    }

    public static String uploadGPSMsg(Context context, XdjaLocation location) {
        SharePrefUtil spUtil = SharePrefUtil.getSpUtil(context);
        StringBuffer msg = new StringBuffer();
        StringBuffer reqstr = new StringBuffer();
        msg.append("MOB###");
        msg.append(spUtil.getString("user_id", ""));
        msg.append("###");
        msg.append(location.getLatitude());
        msg.append("###");
        msg.append(location.getLongitude());
        msg.append("###");
        msg.append(Math.round(location.getSpeed()));
        msg.append("###");
        msg.append(location.getBearing());
        msg.append("###");
        msg.append(Math.round(location.getAltitude()));
        msg.append("###");
        msg.append(ServiceUtil.unixTimestamp2Str(location.getTime()));
        msg.append("!");
        reqstr.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        reqstr.append("<Root>");
        reqstr.append("<Version>20071115</Version>");
        reqstr.append("<ReqType>gps_logxxlr</ReqType>");
        reqstr.append("<Data>");
        reqstr.append("<c_jh>" + spUtil.getString("user_id", "") + "</c_jh>");
        reqstr.append("<c_gps>" + msg.toString() + "</c_gps>");
        reqstr.append("<c_xqdw/>");
        reqstr.append("</Data>");
        reqstr.append("</Root>");
        return reqstr.toString();
    }

    public static void getSateClientState() {
        String state = null;
        String msg = null;
        int vpnstatelen = 0;
        byte[] vpnstate = new byte[100];
        VPNSocket vpnCS = new VPNSocket("127.0.0.1", 3001);
        try {
            int nres = vpnCS.connect();
            Log.e((String)"safeClient", (String)(nres + ""));
            Long ctime = System.currentTimeMillis();
            while (nres != 0) {
                if (System.currentTimeMillis() - ctime > 20000L) {
                    msg = "\u8fde\u63a5vpn\u670d\u52a1\u5931\u8d25\uff01";
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                nres = vpnCS.connect();
            }
            if (nres == 0) {
                vpnCS.sendData("GETSTATUS");
                vpnstatelen = vpnCS.recvData(vpnstate);
                state = new String(vpnstate, 0, vpnstatelen);
                if (state.startsWith("OK 20")) {
                    msg = "\u5b89\u5168\u6a21\u5757\u521d\u59cb\u5316\u4e2d...";
                } else if (state.startsWith("OK 30")) {
                    msg = "\u6b63\u5728\u8fdb\u884c\u5b89\u5168\u8ba4\u8bc1...";
                } else if (state.startsWith("OK 40")) {
                    msg = "\u7ec8\u7aef\u72b6\u6001\u4e0a\u62a5\u4e2d...";
                } else if (state.startsWith("OK 100")) {
                    msg = "\u5b89\u5168\u901a\u9053\u5df2\u7ecf\u5efa\u7acb";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ServiceUtil.writeToSDCard(GPS_LOG_PATH, "state = " + state + "----" + msg, true);
    }

    public static CommunityLocation getXqdw(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String cellID = "";
        GsmCellLocation gcl = (GsmCellLocation)telephonyManager.getCellLocation();
        CommunityLocation location = new CommunityLocation();
        if (null != gcl) {
            int i_cellId = gcl.getCid();
            switch (NetUtil.isConnected(context)) {
                case NET_UNKNOWN: 
                case NET_2G: 
                case NET_3G: {
                    int temp_3g = i_cellId % 65536;
                    cellID = String.valueOf(temp_3g);
                    location.netType = "3G";
                    break;
                }
                case NET_4G: {
                    int temp_4g = i_cellId / 256;
                    cellID = String.valueOf(temp_4g);
                    location.netType = "4G";
                    break;
                }
                default: {
                    location.netType = "";
                    Log.e((String)"\u672a\u77e5", (String)"\u672a\u77e5");
                }
            }
            int locationID = gcl.getLac();
            Log.w((String)"sqh", (String)cellID);
            location.sqh = cellID;
            location.quid = String.valueOf(locationID);
            Log.i((String)"quid", (String)location.quid);
            location.xhqd = "20";
        } else {
            location.sqh = "";
            location.quid = "";
            location.netType = "";
            location.xhqd = "";
        }
        return location;
    }

    public static String unixTimestamp2Str(long epoch) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+08:00"));
        Date theDate = new Date(epoch);
        return sdf.format(theDate);
    }
}

