/*
 * Decompiled with CFR 0.152.
 */
package com.founder.location.util;

import android.net.wifi.ScanResult;
import com.founder.location.FounderLocationException;
import com.founder.location.entity.BaseStation;
import com.founder.location.entity.FounderLocation;
import com.founder.location.util.TimeUtil;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ParamsUtil {
    public static String formatterWifiParams(List<ScanResult> aps, boolean isShare, boolean isRectify, String deviceId) throws FounderLocationException {
        JSONObject jo = new JSONObject();
        try {
            jo.put("deviceId", (Object)deviceId);
            jo.put("source", 1);
            jo.put("rectify", isRectify);
            jo.put("share", isShare);
            jo.put("time", (Object)TimeUtil.timeStamp2String(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
            JSONArray jArray = new JSONArray();
            for (int i2 = 0; i2 < aps.size(); ++i2) {
                JSONObject jObj = new JSONObject();
                jObj.put("mac", (Object)aps.get((int)i2).BSSID);
                jObj.put("ssid", (Object)aps.get((int)i2).SSID);
                jObj.put("hz", aps.get((int)i2).frequency);
                jObj.put("dbm", aps.get((int)i2).level);
                jArray.put((Object)jObj);
            }
            jo.put("data", (Object)jArray);
        }
        catch (Exception e2) {
            throw new FounderLocationException();
        }
        return jo.toString();
    }

    public static String formatterBSParams(List<BaseStation> bss, boolean isShare, boolean isRectify, String deviceId) throws FounderLocationException {
        JSONObject jo = new JSONObject();
        try {
            jo.put("deviceId", (Object)deviceId);
            jo.put("source", 2);
            jo.put("rectify", isRectify);
            jo.put("share", isShare);
            jo.put("time", (Object)TimeUtil.timeStamp2String(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
            JSONArray jArray = new JSONArray();
            for (int i2 = 0; i2 < bss.size(); ++i2) {
                JSONObject jObj = new JSONObject();
                jObj.put("mnc", bss.get(i2).getMnc());
                jObj.put("lac", bss.get(i2).getLac());
                jObj.put("cid", bss.get(i2).getCid());
                jObj.put("bsss", bss.get(i2).getBsss());
                jArray.put((Object)jObj);
            }
            jo.put("data", (Object)jArray);
        }
        catch (Exception e2) {
            throw new FounderLocationException();
        }
        return jo.toString();
    }

    public static String formatterGPSParams(FounderLocation location, boolean isShare, boolean isRectify, String deviceId) throws FounderLocationException {
        JSONObject jo = new JSONObject();
        try {
            jo.put("deviceId", (Object)deviceId);
            jo.put("source", 0);
            jo.put("rectify", isRectify);
            jo.put("share", isShare);
            jo.put("time", (Object)TimeUtil.timeStamp2String(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
            JSONObject jObj = new JSONObject();
            jObj.put("x", location.getLongitude());
            jObj.put("y", location.getLatitude());
            jObj.put("elev", (int)((short)location.getElev()));
            jObj.put("speed", (int)((short)location.getSpeed()));
            jObj.put("dir", (int)location.getDir());
            jo.put("data", (Object)jObj);
        }
        catch (Exception e2) {
            throw new FounderLocationException();
        }
        return jo.toString();
    }
}

