package com.xdja.jwt.location;

/**
 * DESCRIBE:定位上报配置
 * Created by jarlen on 2016/11/9.
 */

public class LocationConfig {

    /**
     * 用户ID(或警号)
     */
    private String userId;

    /**
     * 方正定位服务器IP
     */
    private String lbsServerIp = "127.0.0.1";

    /**
     * 方正定位服务器Port
     */
    private String lbsServerPort = "8097";

    /**
     * 中国移动上报服务器IP
     */
    private String mCMCCIp = "192.168.255.2";

    /**
     * 中国联通上报服务器IP
     */
    private String mUNICOMEIp = "172.28.0.2";

    /**
     * 中国移动上报服务器Port
     */
    private String mCMCCPort = "2009";

    /**
     * 中国联通上报服务器Port
     */
    private String mUNICOMEPort = "2009";

    /**
     * 循环上报时间间隔(默认5s)
     */
    private int mUploadLoopTime = 10000;

    /**
     * 设置用户ID(或警号)
     * @param userId
     */
    public LocationConfig setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * 获取用户ID(或警号)
     * @return
     */
    public String getUserId() {
        return userId;
    }

    /**
     * 设置方正定位服务器IP
     *
     * @param lbsServerIp
     * @return
     */
    public LocationConfig setLbsServerIp(String lbsServerIp) {
        this.lbsServerIp = lbsServerIp;
        return this;
    }

    /**
     * 设置方正定位服务器Port
     *
     * @param lbsServerPort
     * @return
     */
    public LocationConfig setLbsServerPort(String lbsServerPort) {
        this.lbsServerPort = lbsServerPort;
        return this;
    }

    /**
     * 设置中国移动上报服务器IP
     *
     * @param mCMCCIp
     * @return
     */
    public LocationConfig setCMCCIp(String mCMCCIp) {
        this.mCMCCIp = mCMCCIp;
        return this;
    }

    /**
     * 设置中国移动上报服务器Port
     *
     * @param mCMCCPORT
     * @return
     */
    public LocationConfig setCMCCPort(String mCMCCPORT) {
        this.mCMCCPort = mCMCCPORT;
        return this;
    }

    /**
     * 设置中国联通上报服务器IP
     *
     * @param mUNICOMEIp
     * @return
     */
    public LocationConfig setUNICOMEIp(String mUNICOMEIp) {
        this.mUNICOMEIp = mUNICOMEIp;
        return this;
    }

    /**
     * 设置中国联通上报服务器Port
     *
     * @param mUNICOMEPORT
     * @return
     */
    public LocationConfig setUNICOMEPort(String mUNICOMEPORT) {
        this.mUNICOMEPort = mUNICOMEPORT;
        return this;
    }

    /**
     * 设置循环上报时间间隔(默认5s)
     *
     * @param mUploadLoopTime
     * @return
     */
    public LocationConfig setUploadLoopTime(int mUploadLoopTime) {
        this.mUploadLoopTime = mUploadLoopTime;
        return this;
    }

    public int getUploadLoopTime() {
        return mUploadLoopTime;
    }

    public String getLbsServerIp() {
        return lbsServerIp;
    }

    public String getLbsServerPort() {
        return lbsServerPort;
    }

    public String getCMCCIp() {
        return mCMCCIp;
    }

    public String getCMCCPort() {
        return mCMCCPort;
    }

    public String getUNICOMEIp() {
        return mUNICOMEIp;
    }

    public String getUNICOMEPort() {
        return mUNICOMEPort;
    }
}
