package com.xdja.jwt.location.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.Log;

import com.xdja.jwt.location.data.CommunityLocation;
import com.xdja.jwt.location.data.XdjaLocation;
import com.xdja.publicclass.VPNSocket;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/**
 * 上报服务辅助类
 *
 * @author jarlen
 */
public class ServiceUtil {

    public static final String GPS_LOG_PATH = Environment.getExternalStorageDirectory().getPath() + "/ksch_GPSlog.txt";

    public static final String LOCATION_LOG_PATH = Environment.getExternalStorageDirectory().getPath() + "/location.txt";


    public static boolean isServiceRunning(Context mContext, String className) {
        boolean isRunning = false;
        ActivityManager activityManager = (ActivityManager) mContext.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningServiceInfo> serviceList = activityManager.getRunningServices(100);
        if (!(serviceList.size() > 0)) {
            return false;
        }
        for (int i = 0; i < serviceList.size(); i++) {
            Log.i("RUN_SERVICE_TAG", serviceList.get(i).service.getClassName());
            if (serviceList.get(i).service.getClassName().equals(className) == true) {
                isRunning = true;
                break;
            }
        }
        Log.i("TAG", "isRunning = " + isRunning);
        return isRunning;
    }

    public static String getNowDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        return sdf.format(date);
    }

    // 向SDCard写文件
    public static void writeToSDCard(String fileName, String data, boolean isappend) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(file, isappend);
                OutputStreamWriter osw = new OutputStreamWriter(fos, "UTF-8");
                BufferedWriter bfw = new BufferedWriter(osw);
                if (isappend) {
                    data = "*************" + System.getProperty("line.separator") + getNowDateTime() + "  " + data + System.getProperty("line.separator");
                }
                bfw.write(data);
                bfw.flush();
                bfw.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 获取运营商网络
     *
     * @return
     */
    public static String getProvider(Context context) {
        String provider = "未知";
        try {
            TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            String IMSI = telephonyManager.getSubscriberId();
            Log.v("tag", "getProvider.IMSI:" + IMSI);
            if (IMSI == null) {
                if (TelephonyManager.SIM_STATE_READY == telephonyManager.getSimState()) {
                    String operator = telephonyManager.getSimOperator();
                    Log.v("tag", "getProvider.operator:" + operator);
                    if (operator != null) {
                        if (operator.equals("46000") || operator.equals("46002") || operator.equals("46007")) {
                            provider = "中国移动";
                        } else if (operator.equals("46001")) {
                            provider = "中国联通";
                        } else if (operator.equals("46003")) {
                            provider = "中国电信";
                        }
                    }
                }
            } else {
                if (IMSI.startsWith("46000") || IMSI.startsWith("46002") || IMSI.startsWith("46007")) {
                    provider = "中国移动";
                } else if (IMSI.startsWith("46001")) {
                    provider = "中国联通";
                } else if (IMSI.startsWith("46003")) {
                    provider = "中国电信";
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return provider;
    }


    public static String uploadXqmsg(Context context, CommunityLocation location) {

        SharePrefUtil spUtil = SharePrefUtil.getSpUtil(context);
        StringBuffer msg = new StringBuffer();
        StringBuffer reqstr = new StringBuffer();
        msg.append("LOC###");
        msg.append(spUtil.getString("user_id", ""));
        msg.append("###");
        msg.append(location.sqh.trim());
        msg.append("###");
        msg.append(location.quid.trim());
        msg.append("###");
        msg.append(location.xhqd.trim());
        msg.append("###");// 网络制式
        msg.append(location.netType);
        msg.append("###");// 运营商名称
        msg.append(ServiceUtil.getProvider(context));
        msg.append("!");

        reqstr.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        reqstr.append("<Root>");
        reqstr.append("<Version>20071115</Version>");
        reqstr.append("<ReqType>gps_logxxlr</ReqType>");
        reqstr.append("<Data>");
        reqstr.append("<c_jh>" + spUtil.getString("user_id", "") + "</c_jh>");
        reqstr.append("<c_gps></c_gps>");
        reqstr.append("<c_xqdw>" + msg.toString() + "</c_xqdw>");
        reqstr.append("</Data>");
        reqstr.append("</Root>");
        return reqstr.toString();
    }

    public static String uploadGPSMsg(Context context, XdjaLocation location) {

        SharePrefUtil spUtil = SharePrefUtil.getSpUtil(context);
        StringBuffer msg = new StringBuffer();
        StringBuffer reqstr = new StringBuffer();
        msg.append("MOB###");
        // msg.append(IMEI);
        msg.append(spUtil.getString("user_id", ""));
        msg.append("###");
        msg.append(location.getLatitude());
        msg.append("###");
        msg.append(location.getLongitude());
        msg.append("###");
        msg.append(Math.round(location.getSpeed()));
        msg.append("###");
        msg.append(location.getBearing());
        msg.append("###");
        msg.append(Math.round(location.getAltitude()));
        msg.append("###");
        msg.append(ServiceUtil.unixTimestamp2Str(location.getTime()));
        msg.append("!");
        reqstr.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        reqstr.append("<Root>");
        reqstr.append("<Version>20071115</Version>");
        reqstr.append("<ReqType>gps_logxxlr</ReqType>");
        reqstr.append("<Data>");
        reqstr.append("<c_jh>" + spUtil.getString("user_id", "") + "</c_jh>");
        reqstr.append("<c_gps>" + msg.toString() + "</c_gps>");
        reqstr.append("<c_xqdw/>");
        reqstr.append("</Data>");
        reqstr.append("</Root>");
        return reqstr.toString();
    }


    public static void getSateClientState() {
        String state = null;
        String msg = null;
        int vpnstatelen = 0;
        byte[] vpnstate = new byte[100];
        VPNSocket vpnCS = new VPNSocket("127.0.0.1", 3001);
        try {
            int nres = vpnCS.connect();
            Log.e("safeClient", nres + "");
            Long ctime = System.currentTimeMillis();
            while (nres != 0) {
                if (System.currentTimeMillis() - ctime > 20000) {
                    msg = "连接vpn服务失败！";
                    break;
                }
                try {
                    Thread.sleep(1000);
                } catch (Exception ex) {
                }
                nres = vpnCS.connect();
            }
            if (nres == 0) {
                vpnCS.sendData("GETSTATUS");
                vpnstatelen = vpnCS.recvData(vpnstate);
                state = new String(vpnstate, 0, vpnstatelen);
                if (state.startsWith("OK 20")) {
                    msg = "安全模块初始化中...";
                } else if (state.startsWith("OK 30")) {
                    msg = "正在进行安全认证...";
                } else if (state.startsWith("OK 40")) {
                    msg = "终端状态上报中...";
                } else if (state.startsWith("OK 100")) {
                    msg = "安全通道已经建立";
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        ServiceUtil.writeToSDCard(ServiceUtil.GPS_LOG_PATH, "state = " + state + "----" + msg, true);
    }


    /**
     * 获取小区定位信息
     */
    public static CommunityLocation getXqdw(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        String cellID = "";
        int locationID;
        GsmCellLocation gcl = (GsmCellLocation) telephonyManager.getCellLocation();
        CommunityLocation location = new CommunityLocation();
        if (null != gcl) {
            int i_cellId = gcl.getCid();
            switch (NetUtil.isConnected(context)) {
                case NET_UNKNOWN:
                case NET_2G:
                case NET_3G:
                    int temp_3g = i_cellId % 65536;
                    cellID = String.valueOf(temp_3g);
                    location.netType = "3G";
                    break;
                case NET_4G:
                    int temp_4g = i_cellId / 256;
                    cellID = String.valueOf(temp_4g);
                    location.netType = "4G";
                    break;
                default:
                    location.netType = "";
                    Log.e("未知", "未知");
                    break;
            }
            locationID = gcl.getLac();
            Log.w("sqh", cellID);
            location.sqh = cellID;
            location.quid = String.valueOf(locationID);
            Log.i("quid", location.quid);
            location.xhqd = "20";
        } else {
            location.sqh = "";
            location.quid = "";
            location.netType = "";
            location.xhqd = "";
        }

        return location;
    }


    public static String unixTimestamp2Str(long epoch) {

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        sdf.setTimeZone(TimeZone.getTimeZone("GMT+08:00"));

        Date theDate = new Date(epoch);

        return (sdf.format(theDate));

    }

}
