package com.xdja.jwt.location.utils;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * SharePreferences操作工具类
 */
public class SharePrefUtil {
    private final static String SP_FOUNDER_NAME = "founderlocation";

    private SharedPreferences sp;
    private volatile static SharePrefUtil INSTANCE;

    public SharePrefUtil(Context context,String spName) {
        sp = context.getSharedPreferences(spName, Context.MODE_PRIVATE);
    }

    public static SharePrefUtil getSpUtil(Context ctx) {
        if (INSTANCE == null) {
            INSTANCE = new SharePrefUtil(ctx,SP_FOUNDER_NAME);
        }
        return INSTANCE;
    }

    /**
     * 保存布尔值
     *
     * @param key
     * @param value
     */
    public void saveBoolean(String key, boolean value) {
        sp.edit().putBoolean(key, value).commit();
    }

    /**
     * 保存字符串
     *
     * @param key
     * @param value
     */
    public void saveString(String key, String value) {
        sp.edit().putString(key, value).commit();

    }

    public void clear() {
        sp.edit().clear().commit();
    }

    public void removeItem(String key) {
        sp.edit().remove(key).commit();
    }

    /**
     * 保存long型
     *
     * @param key
     * @param value
     */
    public void saveLong(String key, long value) {
        sp.edit().putLong(key, value).commit();
    }

    /**
     * 保存int型
     *
     * @param key
     * @param value
     */
    public void saveInt(String key, int value) {
        sp.edit().putInt(key, value).commit();
    }

    /**
     * 保存float型
     *
     * @param key
     * @param value
     */
    public void saveFloat(String key, float value) {
        sp.edit().putFloat(key, value).commit();
    }

    /**
     * 获取字符值
     *
     * @param key
     * @param defValue
     * @return
     */
    public String getString(String key, String defValue) {
        return sp.getString(key, defValue);
    }

    /**
     * 获取int值
     *
     * @param key
     * @param defValue
     * @return
     */
    public int getInt(String key, int defValue) {
        return sp.getInt(key, defValue);
    }

    /**
     * 获取long值
     *
     * @param key
     * @param defValue
     * @return
     */
    public long getLong(String key, long defValue) {
        return sp.getLong(key, defValue);
    }

    /**
     * 获取float值
     *
     * @param key
     * @param defValue
     * @return
     */
    public float getFloat(String key, float defValue) {
        return sp.getFloat(key, defValue);
    }

    /**
     * 获取布尔值
     *
     * @param key
     * @param defValue
     * @return
     */
    public boolean getBoolean(String key, boolean defValue) {
        return sp.getBoolean(key, defValue);
    }


}
