package com.xdja.gprsconverter.convert;

import android.text.TextUtils;

import com.xdja.gprsconverter.extension.IsMainExtension;
import com.xdja.gprsconverter.protocol.EntryResponse;
import com.xdja.gprsconverter.protocol.EntryRequest;
import com.xdja.gprsconverter.resolver.EntryResponseResolver;

import org.xml.sax.EntityResolver;

/**
 * Created by Guojie on 2017/8/28.
 */

public class EntryProtocolConvert implements ConvertInterface<EntryRequest, EntryResponse> {

    @Override
    public String convertBean2XML(EntryRequest entryRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Root>");
        sb.append("<ReqType>" + entryRequest.getReqType() + "</ReqType>");
        sb.append("<SessionID>" + entryRequest.getSessionID() + "</SessionID>");
        if (TextUtils.isEmpty(entryRequest.getTransactionType())) {
            sb.append("<TransactionType>1</TransactionType>");
        } else {
            sb.append("<TransactionType>" + entryRequest.getTransactionType() + "</TransactionType>");
        }
        sb.append("<Tables>");
        if (entryRequest.getTableList() != null && entryRequest.getTableList().size() > 0) {
            for (EntryRequest.Table table : entryRequest.getTableList()) {
                sb.append("<Table>");
                sb.append("<Name>" + table.getTableName() + "</Name>");
                if (table.isMain()) {
                    sb.append("<IsMain>" + IsMainExtension.IS_MAIN + "</IsMain>");
                } else {
                    sb.append("<IsMain>" + IsMainExtension.NOT_MAIN + "</IsMain>");
                }
                if (table.getTableDataList() != null && table.getTableDataList().size() > 0) {
                    for (EntryRequest.TableData tableData : table.getTableDataList()) {
                        sb.append("<Row>");
                        sb.append("<Operate>" + tableData.getOperate() + "</Operate>");
                        if (!TextUtils.isEmpty(tableData.getCondition())) {
                            sb.append("<Condition><![CDATA[" + tableData.getCondition() + "]]></Condition>");
                        }
                        sb.append("<Data>");
                        if (tableData.getEntryDataList() != null && tableData.getEntryDataList().size() > 0) {
                            for (EntryRequest.EntryData entryData : tableData.getEntryDataList()) {
                                if (entryData.isSpecial()) {
                                    sb.append("<" + entryData.getKey() + "><![CDATA[");
                                    sb.append(entryData.getValue());
                                    sb.append("]]></" + entryData.getKey() + ">");
                                } else {
                                    sb.append("<" + entryData.getKey() + ">");
                                    sb.append(entryData.getValue());
                                    sb.append("</" + entryData.getKey() + ">");
                                }
                            }
                        }
                        sb.append("</Data>");
                        sb.append("</Row>");
                    }
                }
                sb.append("</Table>");
            }
        }
        sb.append("</Tables>");
        sb.append("</Root>");
        return sb.toString();
    }

    @Override
    public EntryResponse convertXML2Bean(String string) {
        return EntryResponseResolver.resolverFromXML(string);
    }
}
