package com.xdja.gprsconverter.convert;

import android.text.TextUtils;

import com.xdja.gprsconverter.extension.LoginExtension;
import com.xdja.gprsconverter.protocol.LoginRequest;
import com.xdja.gprsconverter.protocol.LoginResponse;
import com.xdja.gprsconverter.resolver.XMLResolver;

/**
 * Created by Guojie on 2017/8/31.
 */

public class LoginProtocolConvert implements ConvertInterface<LoginRequest, LoginResponse> {

    @Override
    public String convertBean2XML(LoginRequest loginRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Root>");
        sb.append("<ReqType>" + loginRequest.getReqType() + "</ReqType>");
        sb.append("<ValidateType>" + loginRequest.getValiDataType() + "</ValidateType>");
        sb.append("<ValidateValue><![CDATA[ " + loginRequest.getValiDataValue() + "]]>" + "</ValidateValue>");
        if (!TextUtils.isEmpty(loginRequest.getValiDataPass())) {
            sb.append("<ValidatePass>" + loginRequest.getValiDataPass() + "</ValidatePass>");
        } else {
            sb.append("<ValidatePass></ValidatePass>");
        }
        sb.append("<CurrentVersion>" + loginRequest.getCurrentVersion() + "</CurrentVersion>");
        sb.append("<ClientType>" + loginRequest.getClientType() + "</ClientType>");
        sb.append("<CardType>" + loginRequest.getCardType() + "</CardType>");
        sb.append("<IMSI>" + loginRequest.getImsi() + "</IMSI>");
        sb.append("<IMEI>" + loginRequest.getImei() + "</IMEI>");
        if (TextUtils.isEmpty(loginRequest.getIccid())) {
            sb.append("<ICCID>" + loginRequest.getIccid() + "</ICCID>");
        }
        if (TextUtils.isEmpty(loginRequest.getPver())) {
            sb.append("<Pver>20140501</Pver>");
        } else {
            sb.append("<Pver>" + loginRequest.getPver() + "</Pver>");
        }
        sb.append("</Root>");
        return sb.toString();
    }

    @Override
    public LoginResponse convertXML2Bean(String string) {
        XMLResolver xmlResolver = new XMLResolver(string);
        if (xmlResolver.getDoc() != null) {
            LoginResponse loginResponse = new LoginResponse();
            loginResponse.setPower(xmlResolver.getElementValue(LoginExtension.LoginField.POWER));
            loginResponse.setUnitsCoding(xmlResolver.getElementValue(LoginExtension.LoginField.UNITSCODING));
            loginResponse.setPoliceName(xmlResolver.getElementValue(LoginExtension.LoginField.POLICENAME));
            loginResponse.setUnitName(xmlResolver.getElementValue(LoginExtension.LoginField.UNITNAME));
            loginResponse.setMobileNo(xmlResolver.getElementValue(LoginExtension.LoginField.MOBILENO));
            loginResponse.setPoliceID(xmlResolver.getElementValue(LoginExtension.LoginField.POLICEID));
            loginResponse.setPoliceNo(xmlResolver.getElementValue(LoginExtension.LoginField.POLICENO));
            loginResponse.setIdCard(xmlResolver.getElementValue(LoginExtension.LoginField.IDCARD));
            loginResponse.setSessionID(xmlResolver.getElementValue(LoginExtension.LoginField.SESSIONID));
            loginResponse.setMonth3Pwd("0".equals(xmlResolver.getElementValue(LoginExtension.LoginField.MONTH3WPD)));
            loginResponse.setDateTime(xmlResolver.getElementValue(LoginExtension.LoginField.DATATIME));
            loginResponse.setLimits(xmlResolver.getElementValue(LoginExtension.LoginField.LIMITS));
            return loginResponse;
        }
        return null;
    }
}
