package com.xdja.gprsconverter.extension;

/**
 * 查询字段Type属性，数据类型扩展（区分大小写）
 * 包含数字表示和字符表示两种方式，不区分大小写
 * 考虑到字符表示形式容易记忆，建议传递字符表示
 * 默认值 1或char
 */

public class TypeExtension {
    /**
     * 数字表示
     */
    public static class NumberExpression {
        /**
         * 字符型（默认值）
         */
        public static final String CHAR_TYPE = "1";
        /**
         * 数字型
         */
        public static final String NUMBER_TYPE = "2";
        /**
         * 日期型，要保证日期的有效性，否则系统将抛出错误给终端
         */
        public static final String DATE_TYPE = "3";
        /**
         * 值转为拼音
         */
        public static final String V2P_TYPE = "4";
    }

    /**
     * 字符表示
     */
    public static class charExpression {
        /**
         * 字符型（默认值）
         */
        public static final String CHAR_TYPE = "Char";
        /**
         * 数字型
         */
        public static final String NUMBER_TYPE = "Number";
        /**
         * 日期型，要保证日期的有效性，否则系统将抛出错误给终端
         */
        public static final String DATE_TYPE = "Date";
        /**
         * 值转为拼音
         */
        public static final String V2P_TYPE = "v2p";
    }
}
