package com.xdja.gprsconverter.protocol;

import android.support.annotation.NonNull;

import java.io.Serializable;

/**
 * 修改密码请求协议内容
 */

public class ChangePwdRequest implements Serializable {
    /**
     * 请求类别
     */
    private String reqType;
    /**
     * 回话id
     */
    private String sessionID;
    /**
     * 登录认证方式
     */
    private String valiDataType;
    /**
     * 登录所用证件号码
     */
    private String valiDataValue;
    /**
     * 新密码
     */
    private String newPwd;
    /**
     * 旧密码
     */
    private String oldPwd;

    public String getReqType() {
        return reqType;
    }

    public void setReqType(@NonNull String reqType) {
        this.reqType = reqType;
    }

    public String getSessionID() {
        return sessionID;
    }

    public void setSessionID(@NonNull String sessionID) {
        this.sessionID = sessionID;
    }

    public String getValiDataType() {
        return valiDataType;
    }

    /**
     * 设置认证登录方式
     *
     * @param valiDataType 登录方式，其值必须为{@link com.xdja.gprsconverter.extension.LoginExtension.Type}中的值
     */
    public void setValiDataType(@NonNull String valiDataType) {
        this.valiDataType = valiDataType;
    }

    public String getValiDataValue() {
        return valiDataValue;
    }

    /**
     * 设置登录所用证件号码，如警号登录方式则对应警号
     *
     * @param valiDataValue
     */
    public void setValiDataValue(@NonNull String valiDataValue) {
        this.valiDataValue = valiDataValue;
    }

    public String getNewPwd() {
        return newPwd;
    }

    /**
     * @param newPwd 新密码
     */
    public void setNewPwd(@NonNull String newPwd) {
        this.newPwd = newPwd;
    }

    public String getOldPwd() {
        return oldPwd;
    }

    /**
     * @param oldPwd 旧密码
     */
    public void setOldPwd(@NonNull String oldPwd) {
        this.oldPwd = oldPwd;
    }
}
