package com.xdja.gprsconverter.resolver;

import com.xdja.gprsconverter.protocol.EntryResponse;
import com.xdja.gprsconverter.protocol.QueryResponse;

import org.w3c.dom.NodeList;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Guojie on 2017/8/30.
 */

public class EntryResponseResolver {
    public static EntryResponse resolverFromXML(String xmlResponse) {
        EntryResponse entryResponse = new EntryResponse();
        XMLResolver xmlResolver = new XMLResolver(xmlResponse);
        if (xmlResolver.getDoc() != null) {
            boolean isSuccess = xmlResolver.getElementValue("Type").equals("0");
            String message = xmlResolver.getElementValue("Result");
            entryResponse.setSuccess(isSuccess);
            entryResponse.setMessage(message);
//            entryResponse.setReturnItemList(getReturnItemList(xmlResolver.getDoc().getElementsByTagName("ReturnItems")));
//            entryResponse.setAlertInfoList(getAlertInfoList(xmlResolver.getDoc().getElementsByTagName("RelNode")));
        } else {
            entryResponse.setSuccess(false);
            entryResponse.setMessage("服务器返回数据格式错误");
        }
        return entryResponse;
    }

    private static List<EntryResponse.ReturnItem> getReturnItemList(NodeList nodeList) {
        List<EntryResponse.ReturnItem> returnItems = new ArrayList<>();
        if (nodeList != null && nodeList.getLength() > 0) {
            NodeList itemNodeList = nodeList.item(0).getChildNodes();
            EntryResponse.ReturnItem returnItem;
            for (int i = 0; i < itemNodeList.getLength(); i++) {
                returnItem = new EntryResponse.ReturnItem();
                returnItem.setKey(itemNodeList.item(0).getFirstChild().getNodeName());
                returnItem.setValue(itemNodeList.item(0).getFirstChild().getNodeValue());
                returnItems.add(returnItem);
            }
        }
        return returnItems;
    }

    private static List<EntryResponse.AlertInfo> getAlertInfoList(NodeList relNodeList) {
        List<EntryResponse.AlertInfo> relationList = new ArrayList<>();
        if (relNodeList != null && relNodeList.getLength() > 0) {
            NodeList relationNode;
            for (int i = 0; i < relNodeList.getLength(); i++) {
                relationNode = relNodeList.item(i).getChildNodes();
                if (relationNode != null) {
                    EntryResponse.AlertInfo relation = new EntryResponse.AlertInfo();
                    relation.setSort(relationNode.item(0).getFirstChild().getNodeValue());//关联请求类别
                    relation.setName(relationNode.item(1).getFirstChild().getNodeValue());//中文名称
                    relation.setCondition(relationNode.item(2).getFirstChild().getNodeValue());//关联查询条件
                    relation.setDbSource(relationNode.item(3).getFirstChild().getNodeValue());//关联业务数据源
                    relation.setXML(relationNode.item(4).getFirstChild().getNodeValue().equals("1"));
                    relation.setAlert(relationNode.item(5).getFirstChild().getNodeValue());
                    relationList.add(relation);
                }
            }
        }
        return relationList;
    }
}
