package com.xdja.gprsconverter.resolver;

import android.util.Log;

import com.xdja.gprsconverter.protocol.QueryResponse;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.ArrayList;
import java.util.List;

/**
 * 查询结果xml转换成bean对象
 * Created by Guojie on 2017/4/19.
 */

public class QueryResponseResolver {

    public static QueryResponse resolverFromXML(String xml) {
        return resolverFromXML(xml, false);
    }

    public static QueryResponse resolverFromXML(String xml, boolean photo) {
        QueryResponse queryResponse;
        XMLResolver xp = new XMLResolver(xml);
        NodeList nodeList = xp.getDoc().getElementsByTagName("Row");
        if (photo) {
            if (nodeList == null || nodeList.getLength() < 2) {
                return null;
            }
        } else {
            if (nodeList == null || nodeList.getLength() < 3) {
                return null;
            }
        }
        //解析Row节点信息
        queryResponse = new QueryResponse();
        if (xp.getElementValue("Rsdc") != null) {
            queryResponse.setRsdc(xp.getElementValue("Rsdc"));
        }
        if (xp.getElementValue("Type") != null) {
            queryResponse.setType(xp.getElementValue("Type"));
        }

        if (photo) {
            queryResponse.setRowDataList(getPhotoValueList(nodeList));
        } else {
            queryResponse.setRowDataList(getValueList(nodeList));
        }
        //解析关联节点信息
        queryResponse.setRelationList(getRelationList(xp.getDoc().getElementsByTagName("RelNode")));
        //照片节点
        queryResponse.setGetPhoto(getPhoto(xp.getDoc().getElementsByTagName("GetPhoto")));

        //解析分页信息
        queryResponse.setPageInfo(getPageInfo(xp.getDoc().getElementsByTagName("Page")));

        return queryResponse;
    }

    /**
     * 解析Values
     *
     * @param nodeList Row节点
     * @return 数据集合
     */
    public static List<QueryResponse.RowData> getValueList(NodeList nodeList) {
        List<QueryResponse.RowData> rowDataList = new ArrayList<>();
        if (nodeList == null || nodeList.getLength() < 3) {
            return rowDataList;
        } else {
            QueryResponse.RowData rowData;
            String[] keyArray = new String[nodeList.item(0).getChildNodes().getLength()];
            String[] aliasArray = new String[nodeList.item(1).getChildNodes().getLength()];
            for (int i = 0; i < nodeList.getLength(); i++) {
                rowData = new QueryResponse.RowData();
                NodeList elements = nodeList.item(i).getChildNodes();
                List<QueryResponse.RowData.FieldData> fieldDataList = new ArrayList<>();
                QueryResponse.RowData.FieldData fieldData;

                for (int j = 0; j < elements.getLength(); j++) {
                    fieldData = new QueryResponse.RowData.FieldData();
                    Node node = elements.item(j).getFirstChild();
                    if (i == 0) {
                        keyArray[j] = node.getNodeValue();
                    } else if (i == 1) {
                        aliasArray[j] = node.getNodeValue();
                    } else {
                        Log.i("TAG", "j=" + j);
                        if (node != null) {
                            fieldData.setKey(keyArray[j]);
                            fieldData.setAlias(aliasArray[j]);
                            fieldData.setValue(node.getNodeValue() == null ? "" : node.getNodeValue());
                            String code = "";
                            if (node.getParentNode() != null && node.getParentNode().getAttributes() != null && node.getParentNode().getAttributes().getNamedItem("CodeValue") != null) {
                                code = node.getParentNode().getAttributes().getNamedItem("CodeValue").getNodeValue();
                            }
                            fieldData.setCode(code == null ? "" : code);
                            fieldDataList.add(fieldData);
                        } else {
                            fieldData.setKey(keyArray[j]);
                            fieldData.setAlias(aliasArray[j]);
                            fieldData.setValue("");
                            fieldData.setCode("");
                            fieldDataList.add(fieldData);
                        }
                        rowData.setFieldDataList(fieldDataList);
                    }

                }
                if (i > 1) {
                    rowDataList.add(rowData);
                }
            }
        }
        return rowDataList;
    }

    /**
     * 解析关联节点数据
     *
     * @param relationNodeList
     * @return 关联节点信息
     */
    public static List<QueryResponse.Relation> getRelationList(NodeList relationNodeList) {
        List<QueryResponse.Relation> relationList = new ArrayList<>();
        if (relationNodeList != null && relationNodeList.getLength() > 0) {
            NodeList relationNode;
            for (int i = 0; i < relationNodeList.getLength(); i++) {
                relationNode = relationNodeList.item(i).getChildNodes();
                if (relationNode != null) {
                    QueryResponse.Relation relation = new QueryResponse.Relation();
                    relation.setSort(relationNode.item(0).getFirstChild().getNodeValue());//关联请求类别
                    relation.setName(relationNode.item(1).getFirstChild().getNodeValue());//中文名称
                    relation.setCondition(relationNode.item(2).getFirstChild().getNodeValue());//关联查询条件
                    relation.setDbSource(relationNode.item(3).getFirstChild().getNodeValue());//关联业务数据源
                    //节点数大于4为报警节点
                    if (relationNode.getLength() > 4) {
                        relation.setIsAlert(true);
                        relation.setAlert(relationNode.item(4).getFirstChild().getNodeValue());//关联请求类别
                    } else {
                        relation.setIsAlert(false);
                    }
                    relationList.add(relation);
                }
            }
        }
        return relationList;
    }

    /**
     * 解析照片节点
     *
     * @param getPhotoNodeList
     * @return
     */
    public static QueryResponse.GetPhoto getPhoto(NodeList getPhotoNodeList) {
        QueryResponse.GetPhoto getPhoto = null;
        if (getPhotoNodeList != null && getPhotoNodeList.getLength() > 0) {
            NodeList photoNodeList = getPhotoNodeList.item(0).getChildNodes();
            if (photoNodeList != null && photoNodeList.getLength() > 0) {
                getPhoto = new QueryResponse.GetPhoto();
                getPhoto.setReqType(photoNodeList.item(0).getFirstChild().getNodeValue());
                getPhoto.setReqTable(photoNodeList.item(1).getFirstChild().getNodeValue());
                getPhoto.setCondition(photoNodeList.item(2).getFirstChild().getNodeValue());
                getPhoto.setDbSource(photoNodeList.item(3).getFirstChild().getNodeValue());
                getPhoto.setFieldList(photoNodeList.item(4).getFirstChild().getNodeValue());
            }
        }
        return getPhoto;
    }

    /**
     * 解析分页信息
     *
     * @param pageInfoNodeList
     * @return
     */
    private static QueryResponse.PageInfo getPageInfo(NodeList pageInfoNodeList) {
        QueryResponse.PageInfo pageInfo = null;
        if (pageInfoNodeList != null && pageInfoNodeList.getLength() > 0) {
            NodeList pageNodeList = pageInfoNodeList.item(0).getChildNodes();
            if (pageNodeList != null && pageNodeList.getLength() > 6) {
                pageInfo = new QueryResponse.PageInfo();
                pageInfo.setSzie(Integer.valueOf(pageNodeList.item(0).getFirstChild().getNodeValue()));
                pageInfo.setTotalLen(Integer.valueOf(pageNodeList.item(1).getFirstChild().getNodeValue()));
                pageInfo.setCurrentLen(Integer.valueOf(pageNodeList.item(2).getFirstChild().getNodeValue()));
                pageInfo.setTotalPage(Integer.valueOf(pageNodeList.item(3).getFirstChild().getNodeValue()));
                pageInfo.setBeginNo(Integer.valueOf(pageNodeList.item(4).getFirstChild().getNodeValue()));
                pageInfo.setSourceCondition(pageNodeList.item(5).getFirstChild().getNodeValue());
                pageInfo.setSourceDbSource(pageNodeList.item(6).getFirstChild().getNodeValue());
            }
        }
        return pageInfo;
    }

    /**
     * 获取照片
     * @param nodeList
     * @return
     */
    private static List<QueryResponse.RowData> getPhotoValueList(NodeList nodeList) {
        List<QueryResponse.RowData> rowDataList = new ArrayList<>();
        if (nodeList == null || nodeList.getLength() < 2) {
            return rowDataList;
        } else {
            QueryResponse.RowData rowData;
            String[] keyArray = new String[nodeList.item(0).getChildNodes().getLength()];
            for (int i = 0; i < nodeList.getLength(); i++) {
                rowData = new QueryResponse.RowData();
                NodeList elements = nodeList.item(i).getChildNodes();
                List<QueryResponse.RowData.FieldData> fieldDataList = new ArrayList<>();
                QueryResponse.RowData.FieldData fieldData;

                for (int j = 0; j < elements.getLength(); j++) {
                    fieldData = new QueryResponse.RowData.FieldData();
                    Node node = elements.item(j).getFirstChild();
                    if (i == 0) {
                        keyArray[j] = node.getNodeValue();
                    } else if (i == 1) {
                        Log.i("TAG", "j=" + j);
                        fieldData.setKey(keyArray[j]);
                        fieldData.setValue(node.getNodeValue() == null ? "" : node.getNodeValue());
                        String code = "";
                        if (node.getParentNode() != null && node.getParentNode().getAttributes() != null && node.getParentNode().getAttributes().getNamedItem("CodeValue") != null) {
                            code = node.getParentNode().getAttributes().getNamedItem("CodeValue").getNodeValue();
                        }
                        fieldData.setCode(code == null ? "" : code);
                        fieldDataList.add(fieldData);
                        rowData.setFieldDataList(fieldDataList);
                    }
                }
                if (i > 0) {
                    rowDataList.add(rowData);
                }
            }
        }
        return rowDataList;
    }
}
