/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.gprsconverter.resolver;

import android.util.Log;
import com.xdja.gprsconverter.protocol.QueryResponse;
import com.xdja.gprsconverter.resolver.XMLResolver;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryResponseResolver {
    public static QueryResponse resolverFromXML(String xml) {
        return QueryResponseResolver.resolverFromXML(xml, false);
    }

    public static QueryResponse resolverFromXML(String xml, boolean photo) {
        XMLResolver xp = new XMLResolver(xml);
        NodeList nodeList = xp.getDoc().getElementsByTagName("Row");
        if (photo ? nodeList == null || nodeList.getLength() < 2 : nodeList == null || nodeList.getLength() < 3) {
            return null;
        }
        QueryResponse queryResponse = new QueryResponse();
        if (xp.getElementValue("Rsdc") != null) {
            queryResponse.setRsdc(xp.getElementValue("Rsdc"));
        }
        if (xp.getElementValue("Type") != null) {
            queryResponse.setType(xp.getElementValue("Type"));
        }
        if (photo) {
            queryResponse.setRowDataList(QueryResponseResolver.getPhotoValueList(nodeList));
        } else {
            queryResponse.setRowDataList(QueryResponseResolver.getValueList(nodeList));
        }
        queryResponse.setRelationList(QueryResponseResolver.getRelationList(xp.getDoc().getElementsByTagName("RelNode")));
        queryResponse.setGetPhoto(QueryResponseResolver.getPhoto(xp.getDoc().getElementsByTagName("GetPhoto")));
        queryResponse.setPageInfo(QueryResponseResolver.getPageInfo(xp.getDoc().getElementsByTagName("Page")));
        return queryResponse;
    }

    public static List<QueryResponse.RowData> getValueList(NodeList nodeList) {
        ArrayList<QueryResponse.RowData> rowDataList = new ArrayList<QueryResponse.RowData>();
        if (nodeList == null || nodeList.getLength() < 3) {
            return rowDataList;
        }
        String[] keyArray = new String[nodeList.item(0).getChildNodes().getLength()];
        String[] aliasArray = new String[nodeList.item(1).getChildNodes().getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            QueryResponse.RowData rowData = new QueryResponse.RowData();
            NodeList elements = nodeList.item(i).getChildNodes();
            ArrayList<QueryResponse.RowData.FieldData> fieldDataList = new ArrayList<QueryResponse.RowData.FieldData>();
            for (int j = 0; j < elements.getLength(); ++j) {
                QueryResponse.RowData.FieldData fieldData = new QueryResponse.RowData.FieldData();
                Node node = elements.item(j).getFirstChild();
                if (i == 0) {
                    keyArray[j] = node.getNodeValue();
                    continue;
                }
                if (i == 1) {
                    aliasArray[j] = node.getNodeValue();
                    continue;
                }
                Log.i((String)"TAG", (String)("j=" + j));
                if (node != null) {
                    fieldData.setKey(keyArray[j]);
                    fieldData.setAlias(aliasArray[j]);
                    fieldData.setValue(node.getNodeValue() == null ? "" : node.getNodeValue());
                    String code = "";
                    if (node.getParentNode() != null && node.getParentNode().getAttributes() != null && node.getParentNode().getAttributes().getNamedItem("CodeValue") != null) {
                        code = node.getParentNode().getAttributes().getNamedItem("CodeValue").getNodeValue();
                    }
                    fieldData.setCode(code == null ? "" : code);
                    fieldDataList.add(fieldData);
                } else {
                    fieldData.setKey(keyArray[j]);
                    fieldData.setAlias(aliasArray[j]);
                    fieldData.setValue("");
                    fieldData.setCode("");
                    fieldDataList.add(fieldData);
                }
                rowData.setFieldDataList(fieldDataList);
            }
            if (i <= 1) continue;
            rowDataList.add(rowData);
        }
        return rowDataList;
    }

    public static List<QueryResponse.Relation> getRelationList(NodeList relationNodeList) {
        ArrayList<QueryResponse.Relation> relationList = new ArrayList<QueryResponse.Relation>();
        if (relationNodeList != null && relationNodeList.getLength() > 0) {
            for (int i = 0; i < relationNodeList.getLength(); ++i) {
                NodeList relationNode = relationNodeList.item(i).getChildNodes();
                if (relationNode == null) continue;
                QueryResponse.Relation relation = new QueryResponse.Relation();
                relation.setSort(relationNode.item(0).getFirstChild().getNodeValue());
                relation.setName(relationNode.item(1).getFirstChild().getNodeValue());
                relation.setCondition(relationNode.item(2).getFirstChild().getNodeValue());
                relation.setDbSource(relationNode.item(3).getFirstChild().getNodeValue());
                if (relationNode.getLength() > 4) {
                    relation.setIsAlert(true);
                    relation.setAlert(relationNode.item(4).getFirstChild().getNodeValue());
                } else {
                    relation.setIsAlert(false);
                }
                relationList.add(relation);
            }
        }
        return relationList;
    }

    public static QueryResponse.GetPhoto getPhoto(NodeList getPhotoNodeList) {
        NodeList photoNodeList;
        QueryResponse.GetPhoto getPhoto = null;
        if (getPhotoNodeList != null && getPhotoNodeList.getLength() > 0 && (photoNodeList = getPhotoNodeList.item(0).getChildNodes()) != null && photoNodeList.getLength() > 0) {
            getPhoto = new QueryResponse.GetPhoto();
            getPhoto.setReqType(photoNodeList.item(0).getFirstChild().getNodeValue());
            getPhoto.setReqTable(photoNodeList.item(1).getFirstChild().getNodeValue());
            getPhoto.setCondition(photoNodeList.item(2).getFirstChild().getNodeValue());
            getPhoto.setDbSource(photoNodeList.item(3).getFirstChild().getNodeValue());
            getPhoto.setFieldList(photoNodeList.item(4).getFirstChild().getNodeValue());
        }
        return getPhoto;
    }

    private static QueryResponse.PageInfo getPageInfo(NodeList pageInfoNodeList) {
        NodeList pageNodeList;
        QueryResponse.PageInfo pageInfo = null;
        if (pageInfoNodeList != null && pageInfoNodeList.getLength() > 0 && (pageNodeList = pageInfoNodeList.item(0).getChildNodes()) != null && pageNodeList.getLength() > 6) {
            pageInfo = new QueryResponse.PageInfo();
            pageInfo.setSzie(Integer.valueOf(pageNodeList.item(0).getFirstChild().getNodeValue()));
            pageInfo.setTotalLen(Integer.valueOf(pageNodeList.item(1).getFirstChild().getNodeValue()));
            pageInfo.setCurrentLen(Integer.valueOf(pageNodeList.item(2).getFirstChild().getNodeValue()));
            pageInfo.setTotalPage(Integer.valueOf(pageNodeList.item(3).getFirstChild().getNodeValue()));
            pageInfo.setBeginNo(Integer.valueOf(pageNodeList.item(4).getFirstChild().getNodeValue()));
            pageInfo.setSourceCondition(pageNodeList.item(5).getFirstChild().getNodeValue());
            pageInfo.setSourceDbSource(pageNodeList.item(6).getFirstChild().getNodeValue());
        }
        return pageInfo;
    }

    private static List<QueryResponse.RowData> getPhotoValueList(NodeList nodeList) {
        ArrayList<QueryResponse.RowData> rowDataList = new ArrayList<QueryResponse.RowData>();
        if (nodeList == null || nodeList.getLength() < 2) {
            return rowDataList;
        }
        String[] keyArray = new String[nodeList.item(0).getChildNodes().getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            QueryResponse.RowData rowData = new QueryResponse.RowData();
            NodeList elements = nodeList.item(i).getChildNodes();
            ArrayList<QueryResponse.RowData.FieldData> fieldDataList = new ArrayList<QueryResponse.RowData.FieldData>();
            for (int j = 0; j < elements.getLength(); ++j) {
                QueryResponse.RowData.FieldData fieldData = new QueryResponse.RowData.FieldData();
                Node node = elements.item(j).getFirstChild();
                if (i == 0) {
                    keyArray[j] = node.getNodeValue();
                    continue;
                }
                if (i != 1) continue;
                Log.i((String)"TAG", (String)("j=" + j));
                fieldData.setKey(keyArray[j]);
                fieldData.setValue(node.getNodeValue() == null ? "" : node.getNodeValue());
                String code = "";
                if (node.getParentNode() != null && node.getParentNode().getAttributes() != null && node.getParentNode().getAttributes().getNamedItem("CodeValue") != null) {
                    code = node.getParentNode().getAttributes().getNamedItem("CodeValue").getNodeValue();
                }
                fieldData.setCode(code == null ? "" : code);
                fieldDataList.add(fieldData);
                rowData.setFieldDataList(fieldDataList);
            }
            if (i <= 0) continue;
            rowDataList.add(rowData);
        }
        return rowDataList;
    }
}

